/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class WordSet {
    public final Set<String> words;
    public final NodePattern formPattern;
    public final NodePattern lemmaPattern;

    public WordSet(Set<String> words) {
        this.words = Collections.unmodifiableSet(words);
        this.formPattern = NodePattern.N.form(StreamEx.of(words).map(s -> s.toLowerCase(Locale.ROOT)).toSet());
        this.lemmaPattern = NodePattern.N.lemma(words);
    }

    public boolean contains(String word) {
        return this.words.contains(word);
    }

    public static WordSet loadResource(String path) {
        return WordSet.loadResource(path, Function.identity());
    }

    public static WordSet loadResource(String path, Function<String, @Nullable String> mapLine) {
        return new WordSet(WordSet.loadLines(path).stream().filter(s -> !s.startsWith("#")).map(mapLine).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static boolean resourceExists(String path) {
        return WordSet.class.getClassLoader().getResource(path) != null;
    }

    public static List<String> loadLines(String path) {
        List<String> list;
        block9: {
            InputStream stream = WordSet.class.getClassLoader().getResourceAsStream(path);
            try {
                if (stream == null) {
                    throw new IllegalStateException("Can't find " + path);
                }
                list = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static NodePattern replaceByForm(String path) {
        return WordSet.replaceByLowForm(WordSet.multiValueMap(WordSet.loadLines(path)));
    }

    public static NodePattern replaceByLowForm(Map<String, List<String>> map2) {
        return NodePattern.N.form(map2.keySet()).and((node, match) -> match.withCorrector(NodeCorrector.replace(node, (List)map2.get(node.lowForm()))));
    }

    public static Map<String, List<String>> multiValueMap(List<String> lines) {
        LinkedHashMap<String, List<String>> map2 = new LinkedHashMap<String, List<String>>();
        for (String line : lines) {
            if (line.isBlank()) continue;
            String[] parts = line.split(":");
            String key = parts[0].trim();
            List prev = map2.put(key, parts.length == 1 ? List.of() : Arrays.stream(parts[1].split("\\|")).map(String::trim).toList());
            if (prev == null) continue;
            throw new IllegalArgumentException("Duplicate entry for " + key);
        }
        return map2;
    }
}

