/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.document;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.document.Delimiter;
import ai.grazie.rules.document.Metadata;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.text.exclusions.Exclusion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentSentence {
    public final String text;
    public final int offset;
    public final Language language;
    public final List<Exclusion> exclusions;
    public final List<Delimiter> intro;
    public Set<TextRange> suppressions;

    public DocumentSentence(String text2, int offset, Language language) {
        this(text2, offset, language, List.of(), List.of(), Set.of());
    }

    protected DocumentSentence(String text2, int offset, Language language, List<Exclusion> exclusions, List<Delimiter> intro, Set<TextRange> suppressions) {
        this.text = text2;
        this.offset = offset;
        this.language = language;
        this.intro = intro;
        this.exclusions = exclusions;
        this.suppressions = suppressions;
    }

    public DocumentSentence withIntro(List<Delimiter> intro) {
        return new DocumentSentence(this.text, this.offset, this.language, this.exclusions, intro, this.suppressions);
    }

    public DocumentSentence withExclusions(List<Exclusion> exclusions) {
        return new DocumentSentence(this.text, this.offset, this.language, exclusions, this.intro, this.suppressions);
    }

    public DocumentSentence withSuppressions(Set<TextRange> suppressions) {
        return new DocumentSentence(this.text, this.offset, this.language, this.exclusions, this.intro, suppressions);
    }

    public static List<List<Analyzed>> fragments(List<Analyzed> sentences2) {
        ArrayList<List<Analyzed>> fragments = new ArrayList<List<Analyzed>>();
        ArrayList<Analyzed> fragment = new ArrayList<Analyzed>();
        for (Analyzed sentence : sentences2) {
            if (!sentence.intro.isEmpty()) {
                if (!fragment.isEmpty()) {
                    fragments.add(fragment);
                }
                fragment = new ArrayList();
            }
            fragment.add(sentence);
        }
        if (!fragment.isEmpty()) {
            fragments.add(fragment);
        }
        return fragments;
    }

    public String toString() {
        return this.text;
    }

    public Parsed withTree(@Nullable Tree tree) {
        return new Parsed(this.text, this.offset, this.language, this.exclusions, this.intro, this.suppressions, tree);
    }

    public static class Analyzed
    extends Parsed {
        public final Metadata metadata;

        private Analyzed(String text2, int offset, Language language, List<Exclusion> exclusions, List<Delimiter> intro, Set<TextRange> suppressions, @Nullable Tree tree, Metadata metadata) {
            super(text2, offset, language, exclusions, intro, suppressions, tree);
            this.metadata = metadata;
        }

        @Override
        public Analyzed withSuppressions(Set<TextRange> suppressions) {
            return new Analyzed(this.text, this.offset, this.language, this.exclusions, this.intro, suppressions, this.tree, this.metadata);
        }
    }

    public static class Parsed
    extends DocumentSentence {
        @Nullable
        public final Tree tree;

        private Parsed(String text2, int offset, Language language, List<Exclusion> exclusions, List<Delimiter> intro, Set<TextRange> suppressions, @Nullable Tree tree) {
            super(text2, offset, language, exclusions, intro, suppressions);
            this.tree = tree;
        }

        public Parsed(@NotNull Tree tree) {
            this(tree.text(), tree.startOffset(), tree.treeSupport().getGrazieLanguage(), List.of(), List.of(), Set.of(), tree);
        }

        public Analyzed withMetadata(@NotNull Metadata metadata) {
            return new Analyzed(this.text, this.offset, this.language, this.exclusions, this.intro, this.suppressions, this.tree, metadata);
        }

        @Override
        public Parsed withIntro(List<Delimiter> intro) {
            return new Parsed(this.text, this.offset, this.language, this.exclusions, intro, this.suppressions, this.tree);
        }

        @Override
        public Parsed withSuppressions(Set<TextRange> suppressions) {
            return new Parsed(this.text, this.offset, this.language, this.exclusions, this.intro, suppressions, this.tree);
        }

        @NotNull
        public Tree treeOrThrow() {
            return Objects.requireNonNull(this.tree);
        }
    }
}

