/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.vale.YamlBasedRule;
import ai.grazie.rules.vale.YamlRuleParser;
import ai.grazie.rules.vale.YamlRuleSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;

class YamlRules {
    private static final String POWERED_BY_VALE = "<br><br>Powered by vale (<a href=\"https://github.com/errata-ai/styles/blob/master/LICENSE\">MIT LICENSE</a>).";
    @Nullable
    private final JLanguageTool tool;
    List<YamlRuleSet> rules;

    YamlRules(@Nullable JLanguageTool tool) {
        this.tool = tool;
        this.rules = List.of(this.msRule("Accessibility"), this.googleMsRule("Acronyms").withPresentableName("Define acronyms before using them"), this.msRule("Adverbs"), this.googleMsRule("AMPM").withPresentableName("Use AM/PM with spaces"), this.msRule("Auto"), this.msRule("AvoidMS").withPresentableName("Terms to avoid in Microsoft style"), this.googleRule("Colons"), this.msRule("Dashes"), this.googleRule("DateFormatGoogle").withPresentableName("Date format (Google style guide)"), this.msRule("DateFormatMS").withPresentableName("Date format (Microsoft style guide)"), this.msRule("DateNumbers").withPresentableName("Ordinal number in dates"), this.msRule("DateOrder").withPresentableName("Always spell out the name of the month"), this.googleMsJbRule("Ellipses"), this.googleRule("EmDash").withPresentableName("Don't put a space before or after a dash"), this.msRule("Foreign"), this.googleMsRule("Gender"), this.msRule("GeneralURL").withPresentableName("Use 'address' rather than 'URL'"), this.msRule("HeadingAcronyms").withPresentableName("Avoid using acronyms in a title or heading"), this.msRule("HeadingColons").withPresentableName("Capitalize words after colons in headings"), this.googleRule("HeadingPunctuationGoogle").withPresentableName("Don't end headings with a perios"), this.msRule("HeadingPunctuationMS").withPresentableName("Don't use end punctuation in headings"), this.googleMsRule("Headings").withPresentableName("Use sentence-style capitalization in headings"), this.googleRule("Latin").withPresentableName("Don't use Latin abbreviations e.g. and i.e."), this.msRule("Negative"), this.googleRule("OptionalPlurals").withPresentableName("Don't use plurals in parentheses"), this.googleMsRule("Ordinal"), this.googleRule("Parens").withPresentableName("Use parentheses judiciously"), this.msRule("Percentages"), this.googleRule("Periods"), this.googleRule("RangesGoogle").withPresentableName("Avoid 'from' or 'between' to describe a range of numbers"), this.msRule("RangeTime").withPresentableName("Use 'to' instead of a dash in time ranges"), this.googleMsRule("Semicolon").withPresentableName("Use semicolons judiciously"), this.msRule("SentenceLength").withPresentableName("Try to keep sentences short (< 30 words)"), this.googleRule("Slang"), this.googleMsRule("Spacing"), this.googleRule("Spelling"), this.msRule("Suspended").withPresentableName("Avoid suspended hyphens"), this.msRule("TermsMS").withPresentableName("Terms prohibited by Microsoft style guide"), this.googleRule("UnitsGoogle").withPresentableName("Put a nonbreaking space between the number and the unit"), this.msRule("UnitsMS").withPresentableName("Don't spell out the number before units of measurement"), this.msRule("URLFormat").withPresentableName("Use 'URL' correctly"), this.msRule("Vocab").withPresentableName("Words to be verified in Microsoft style guide"), this.googleRule("Will").withPresentableName("Avoid 'will'"), this.msRule("Wordiness").withPresentableName("Use simpler phrases (per Microsoft style guide)"), this.googleRule("WordList").withPresentableName("Terms prohibited by Google style guide"), this.jbRule("Abort").withPresentableName("Use 'abort' with care"), this.jbRule("AndOr").withPresentableName("Avoid 'and/or'"), this.jbRule("AndSoOn").withPresentableName("Use 'and so on' with care"), this.jbRule("Available").withPresentableName("Use 'available' with care"), this.jbRule("AvoidJB").withPresentableName("Unnecessary terms to avoid in JetBrains style"), this.jbRule("Caret").withPresentableName("Use 'caret' with care"), this.jbRule("Choose").withPresentableName("Use 'choose' with care"), this.jbRule("Etc").withPresentableName("Avoid Latin 'etc'"), this.jbRule("SlashSpaces").withPresentableName("Spaces around forward slashes"), this.jbRule("TermsJB").withPresentableName("Standardize term spelling in JetBrains style"), this.jbRule("UseEnDashes").withPresentableName("Use en-dashes with spaces"), this.jbRule("YouMust").withPresentableName("Avoid 'you must'"));
    }

    private YamlRuleSet jbRule(String name) {
        String fileName = name + ".yml";
        List<YamlBasedRule> rules = new YamlRuleParser(fileName, this.tool).parseBundled("valeRules/" + fileName);
        String description = "This is a rule from JetBrains Documentation Style Guide implementation.<br><br>Powered by vale (<a href=\"https://github.com/errata-ai/styles/blob/master/LICENSE\">MIT LICENSE</a>).";
        return new YamlRuleSet(YamlRules.globalId(name), name, description, rules, " (by JetBrains style guide)");
    }

    private YamlRuleSet msRule(String name) {
        String fileName = name + ".yml";
        List<YamlBasedRule> rules = new YamlRuleParser(fileName, this.tool).parseBundled("valeRules/" + fileName);
        String link = rules.get((int)0).meta.link;
        if (link != null && !link.contains("microsoft")) {
            throw new AssertionError((Object)("Wrong URL for " + fileName));
        }
        String description = "This is a rule from Microsoft Writing Style Guide implementation (" + YamlRules.msLink(fileName, fileName) + ").<br><br>Powered by vale (<a href=\"https://github.com/errata-ai/styles/blob/master/LICENSE\">MIT LICENSE</a>).";
        return new YamlRuleSet(YamlRules.globalId(name), name, description, rules, " (by Microsoft style guide)");
    }

    private YamlRuleSet googleRule(String name) {
        String fileName = name + ".yml";
        List<YamlBasedRule> rules = new YamlRuleParser(fileName, this.tool).parseBundled("valeRules/" + fileName);
        assert (Objects.requireNonNull(rules.get((int)0).meta.link).contains("google"));
        String description = "This is a rule from Google Developer Documentation Style Guide implementation (" + YamlRules.googleLink(fileName, fileName) + ").<br><br>Powered by vale (<a href=\"https://github.com/errata-ai/styles/blob/master/LICENSE\">MIT LICENSE</a>).";
        return new YamlRuleSet(YamlRules.globalId(name), name, description, rules, " (by Google style guide)");
    }

    private YamlRuleSet googleMsRule(String name) {
        String fileName = name + ".yml";
        List<YamlBasedRule> rules = new YamlRuleParser(fileName, this.tool).parseBundled("valeRules/" + fileName);
        Object googleFileName = "Semicolon".equals(name) ? name + "s" : name;
        String description = "This is a rule from style guide implementations (" + YamlRules.googleLink((String)googleFileName, "Google/" + (String)googleFileName) + " and " + YamlRules.msLink(fileName, "Microsoft/" + fileName) + ").<br><br>Powered by vale (<a href=\"https://github.com/errata-ai/styles/blob/master/LICENSE\">MIT LICENSE</a>).";
        return new YamlRuleSet(YamlRules.globalId(name), name, description, rules, " (by Google and Microsoft style guides)");
    }

    private YamlRuleSet googleMsJbRule(String name) {
        String fileName = name + ".yml";
        List<YamlBasedRule> rules = new YamlRuleParser(fileName, this.tool).parseBundled("valeRules/" + fileName);
        String description = "This is a rule from style guide implementations (" + YamlRules.googleLink(name, "Google/" + name) + ", " + YamlRules.msLink(fileName, "Microsoft/" + fileName) + ", and JetBrains).<br><br>Powered by vale (<a href=\"https://github.com/errata-ai/styles/blob/master/LICENSE\">MIT LICENSE</a>).";
        return new YamlRuleSet(YamlRules.globalId(name), name, description, rules, " (by Google, Microsoft, and JetBrains style guides)");
    }

    private static String globalId(String name) {
        assert (!name.contains(" "));
        assert (Character.isUpperCase(name.charAt(0)));
        return YamlRuleSet.globalIdPrefix("en") + "Assorted_Style_Guides." + name;
    }

    private static String msLink(String fileName, String text2) {
        return "<a href=\"https://github.com/errata-ai/Microsoft/tree/master/Microsoft/" + fileName + "\">" + text2 + "</a>";
    }

    private static String googleLink(String fileName, String text2) {
        return "<a href=\"https://github.com/errata-ai/Google/tree/master/Google/" + fileName + "\">" + text2 + "</a>";
    }
}

