/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.HeadRelations;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tree;

class NodeFlags {
    static final int ROOT = 1;
    static final int PUNCT = 2;
    static final int NO_DEPENDENTS = 4;
    static final int HAS_DEPENDENTS = 8;
    static final int CAPITALIZED = 16;
    static final int LETTER_WORD = 32;
    static final int HAS_POS = 64;
    static final int NO_POS = 128;
    static final int BEFORE_HEAD = 256;
    static final int DIRECTLY_BEFORE_HEAD = 512;
    static final int AFTER_HEAD = 1024;
    static final int DIRECTLY_AFTER_HEAD = 2048;
    static final int SPACE_BEFORE = 4096;
    static final int SPACE_AFTER = 8192;
    static final int NO_SPACE_BEFORE = 16384;
    static final int NO_SPACE_AFTER = 32768;
    private static final short ROOT_REL_ID = HeadRelations.internKnown("root");
    private static final short PUNCT_REL_ID = HeadRelations.internKnown("punct");

    NodeFlags() {
    }

    static int calcFlags(Node node) {
        Node prev;
        int result2 = 0;
        if (node.headRel == ROOT_REL_ID) {
            result2 |= 1;
        } else if (node.headRel == PUNCT_REL_ID) {
            result2 |= 2;
        }
        result2 |= node.dependents.isEmpty() ? 4 : 8;
        String form = node.form();
        if (Character.isUpperCase(form.charAt(0))) {
            result2 |= 0x10;
        }
        if (NodeFlags.isLetterWord(form)) {
            result2 |= 0x20;
        }
        result2 |= NodeFlags.hasAnyPosTag(node) ? 64 : 128;
        int headIndex = node.headIndex;
        if (headIndex >= 0) {
            int index = node.index;
            result2 |= index > headIndex ? 1024 : 256;
            if (index == headIndex - 1) {
                result2 |= 0x200;
            }
            if (index == headIndex + 1) {
                result2 |= 0x800;
            }
        }
        result2 |= (prev = node.prevNode()) == null || prev.endOffset() == node.startOffset() ? 16384 : 4096;
        Node next = node.nextNode();
        return result2 |= next == null || next.startOffset() == node.endOffset() ? 32768 : 8192;
    }

    private static boolean hasAnyPosTag(Node node) {
        for (Tree.Reading r : node.tokenReadings()) {
            if (r.pos() == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isLetterWord(String form) {
        for (int i = 0; i < form.length(); ++i) {
            if (Character.isLetter(form.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

