/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.Literal;
import ai.grazie.rules.util.regex.RegexPath;
import ai.grazie.rules.util.regex.Term;
import ai.grazie.rules.util.regex.Unsupported;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.ranges.IntRange;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

record Postfix(Term term, String modifier) implements Term
{
    private static final RegexPath unboundedPath = new RegexPath(List.of(new Unsupported(0, false, false)));

    @Override
    @NotNull
    public Set<RegexPath> enumerate(int limit, boolean leanRight) {
        Set inner = this.term.enumerate(limit, leanRight);
        if (this.modifier.equals("?")) {
            return inner.size() >= limit ? Set.of(RegexPath.toUnsupported(inner)) : StreamEx.of(inner).append((Object)new RegexPath(List.of(new Literal("")))).toSet();
        }
        if (this.modifier.equals("+")) {
            return Postfix.appendUnbounded(inner, leanRight);
        }
        if (this.modifier.startsWith("{")) {
            Set concat;
            int i;
            Set result2;
            IntRange bounds = this.parseBounds();
            int minCount = bounds.getFirst();
            int maxCount = bounds.getLast();
            if (minCount == 0) {
                result2 = Set.of(new RegexPath(List.of(new Literal(""))));
            } else {
                result2 = inner;
                for (i = 1; i < minCount; ++i) {
                    concat = StreamEx.of(result2).flatMap(p1 -> StreamEx.of((Collection)inner).map(p2 -> p1.concat((RegexPath)p2))).toSet();
                    if (concat.size() > limit) {
                        return Postfix.appendUnbounded(result2, leanRight);
                    }
                    result2 = concat;
                }
            }
            if (maxCount < Integer.MAX_VALUE) {
                result2 = new HashSet<RegexPath>(result2);
                for (i = 0; i < maxCount - minCount; ++i) {
                    concat = StreamEx.of((Collection)result2).flatMap(p1 -> StreamEx.of((Collection)inner).map(p2 -> p1.concat((RegexPath)p2))).toSet();
                    if (result2.size() + concat.size() > limit) {
                        return Postfix.appendUnbounded(result2, leanRight);
                    }
                    result2.addAll(concat);
                }
                return result2;
            }
            return Postfix.appendUnbounded(result2, leanRight);
        }
        return Set.of(unboundedPath);
    }

    private IntRange parseBounds() {
        int commaIndex = this.modifier.indexOf(44);
        if (commaIndex == -1) {
            int exactValue = Integer.parseInt(this.modifier.substring(1, this.modifier.length() - 1));
            return new IntRange(exactValue, exactValue);
        }
        int min = Integer.parseInt(this.modifier.substring(1, commaIndex));
        int max = this.modifier.charAt(commaIndex + 1) == '}' ? Integer.MAX_VALUE : Integer.parseInt(this.modifier.substring(commaIndex + 1, this.modifier.length() - 1));
        return new IntRange(min, max);
    }

    @Override
    public boolean isFinite() {
        return this.term.isFinite() && (this.modifier.equals("?") || this.modifier.matches("\\{\\d+(,\\d+)?}"));
    }

    private static Set<RegexPath> appendUnbounded(Set<RegexPath> paths, boolean leanRight) {
        return StreamEx.of(paths).map(p -> leanRight ? unboundedPath.concat((RegexPath)p) : p.concat(unboundedPath)).toSet();
    }
}

