/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.de.GermanTreeSupport;
import ai.grazie.rules.en.EnglishTreeSupport;
import ai.grazie.rules.ru.RussianTreeSupport;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.uk.UkrainianTreeSupport;
import ai.grazie.text.exclusions.SentenceWithExclusions;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.text.TextContent;
import com.intellij.ml.grazie.pro.CloudOrLocalBatchParser;
import com.intellij.ml.grazie.pro.GrazieProBundle;
import com.intellij.ml.grazie.pro.GrazieProConfig;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.SentenceBatcher;
import com.intellij.ml.grazie.pro.auth.GrazieCloudConnectionState;
import com.intellij.ml.grazie.pro.cloud.APIQueries;
import com.intellij.ml.grazie.pro.license.LoginManager;
import com.intellij.ml.grazie.pro.utils.GrazieUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.progress.RawProgressReporter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.language.English;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/grazie/pro/DependencyParser;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getParser", "Lcom/intellij/ml/grazie/pro/SentenceBatcher$AsyncBatchParser;", "Lai/grazie/rules/tree/Tree;", "text", "Lcom/intellij/grazie/text/TextContent;", "minimal", "", "getLocalParser", "getBatcher", "Lcom/intellij/ml/grazie/pro/DependencyParser$Batcher;", "language", "Lai/grazie/nlp/langs/Language;", "lang2SupportClass", "", "", "supports", "", "Lai/grazie/rules/tree/TreeSupport;", "obtainSupport", "BatcherHolder", "Batcher", "intellij.ml.grazie.pro"})
@SourceDebugExtension(value={"SMAP\nDependencyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyParser.kt\ncom/intellij/ml/grazie/pro/DependencyParser\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,158:1\n30#2,2:159\n*S KotlinDebug\n*F\n+ 1 DependencyParser.kt\ncom/intellij/ml/grazie/pro/DependencyParser\n*L\n67#1:159,2\n*E\n"})
public final class DependencyParser {
    @NotNull
    public static final DependencyParser INSTANCE = new DependencyParser();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<ai.grazie.nlp.langs.Language, String> lang2SupportClass;
    @NotNull
    private static final Map<ai.grazie.nlp.langs.Language, TreeSupport> supports;

    private DependencyParser() {
    }

    @JvmStatic
    @Nullable
    public static final SentenceBatcher.AsyncBatchParser<Tree> getParser(@NotNull TextContent text2, boolean minimal) {
        SentenceBatcher.AsyncBatchParser asyncBatchParser;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (GrazieProConfig.Companion.get().getProcessing() == GrazieProConfig.State.Processing.Local) {
            return INSTANCE.getLocalParser();
        }
        int stripPrefixLength = HighlightingUtil.stripPrefix(text2);
        String string = text2.toString().substring(stripPrefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        ai.grazie.nlp.langs.Language language = GrazieUtilsKt.getLanguageIfAvailable(string);
        if (language == null) {
            return null;
        }
        ai.grazie.nlp.langs.Language language2 = language;
        Batcher batcher = INSTANCE.getBatcher(language2);
        if (batcher == null) {
            return null;
        }
        Batcher batcher2 = batcher;
        PsiFile psiFile = text2.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        if (minimal) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            asyncBatchParser = batcher2.minimal(project);
        } else {
            FileViewProvider fileViewProvider = file.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
            asyncBatchParser = batcher2.forFile(fileViewProvider);
        }
        SentenceBatcher.AsyncBatchParser cloud = asyncBatchParser;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new CloudOrLocalBatchParser(project, cloud, DependencyParser::getParser$lambda$0);
    }

    private final SentenceBatcher.AsyncBatchParser<Tree> getLocalParser() {
        return new SentenceBatcher.AsyncBatchParser<Tree>(){

            public Object parseAsync(List<SentenceWithExclusions> sentences2, Continuation<? super LinkedHashMap<SentenceWithExclusions, Tree>> $completion) {
                return new LinkedHashMap<K, V>();
            }
        };
    }

    private final Batcher getBatcher(ai.grazie.nlp.langs.Language language) {
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<BatcherHolder> serviceClass$iv = BatcherHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((BatcherHolder)object).getBatchers().get(language);
    }

    @JvmStatic
    @Nullable
    public static final TreeSupport obtainSupport(@NotNull ai.grazie.nlp.langs.Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!lang2SupportClass.containsKey(language)) {
            return null;
        }
        Language language2 = SentenceBatcher.Companion.findInstalledLTLanguage(language);
        if (language2 == null) {
            return null;
        }
        Language ltLanguage = language2;
        return supports.computeIfAbsent(language, arg_0 -> DependencyParser.obtainSupport$lambda$2(arg_0 -> DependencyParser.obtainSupport$lambda$1(language, ltLanguage, arg_0), arg_0));
    }

    private static final SentenceBatcher.AsyncBatchParser getParser$lambda$0() {
        return INSTANCE.getLocalParser();
    }

    private static final TreeSupport obtainSupport$lambda$1(ai.grazie.nlp.langs.Language $language, Language $ltLanguage, ai.grazie.nlp.langs.Language it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return switch (WhenMappings.$EnumSwitchMapping$0[$language.ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)$ltLanguage, (String)"null cannot be cast to non-null type org.languagetool.language.English");
                yield new EnglishTreeSupport((English)$ltLanguage);
            }
            case 2 -> new GermanTreeSupport($ltLanguage);
            case 3 -> new UkrainianTreeSupport($ltLanguage);
            case 4 -> new RussianTreeSupport($ltLanguage);
            default -> throw new UnsupportedOperationException();
        };
    }

    private static final TreeSupport obtainSupport$lambda$2(Function1 $tmp0, Object p0) {
        return (TreeSupport)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(DependencyParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ai.grazie.nlp.langs.Language.ENGLISH, (Object)"ai.grazie.rules.en.EnglishTreeSupport"), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.GERMAN, (Object)"ai.grazie.rules.de.GermanTreeSupport"), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.UKRAINIAN, (Object)"ai.grazie.rules.uk.UkrainianTreeSupport"), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.RUSSIAN, (Object)"ai.grazie.rules.ru.RussianTreeSupport")};
        lang2SupportClass = MapsKt.mapOf((Pair[])pairArray);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        supports = concurrentMap;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/grazie/pro/DependencyParser$Batcher;", "Lcom/intellij/ml/grazie/pro/SentenceBatcher;", "Lai/grazie/rules/tree/Tree;", "language", "Lai/grazie/nlp/langs/Language;", "<init>", "(Lai/grazie/nlp/langs/Language;)V", "parse", "", "Lai/grazie/text/exclusions/SentenceWithExclusions;", "sentences", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportStatus", "", "reporter", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "intellij.ml.grazie.pro"})
    @SourceDebugExtension(value={"SMAP\nDependencyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyParser.kt\ncom/intellij/ml/grazie/pro/DependencyParser$Batcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1563#2:159\n1634#2,3:160\n*S KotlinDebug\n*F\n+ 1 DependencyParser.kt\ncom/intellij/ml/grazie/pro/DependencyParser$Batcher\n*L\n134#1:159\n134#1:160,3\n*E\n"})
    private static final class Batcher
    extends SentenceBatcher<Tree> {
        public Batcher(@NotNull ai.grazie.nlp.langs.Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            super(language, TreeSupport.CLOUD_BATCH_SIZE, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected Object parse(@NotNull List<SentenceWithExclusions> sentences2, @NotNull Project project, @NotNull Continuation<? super Map<SentenceWithExclusions, ? extends Tree>> $completion) {
            void $this$mapTo$iv$iv;
            if (GrazieCloudConnectionState.Companion.isAfterRecentGecError()) {
                return MapsKt.emptyMap();
            }
            TreeSupport treeSupport = DependencyParser.obtainSupport(this.getLanguage());
            if (treeSupport == null) {
                return MapsKt.emptyMap();
            }
            TreeSupport support = treeSupport;
            Iterable $this$map$iv = sentences2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SentenceWithExclusions sentenceWithExclusions = (SentenceWithExclusions)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSentence());
            }
            List sentenceStrings = (List)destination$iv$iv;
            return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<SentenceWithExclusions, ? extends Tree>>, Object>(support, this, (List<String>)sentenceStrings, project, sentences2, null){
                Object L$1;
                Object L$2;
                long J$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ TreeSupport $support;
                final /* synthetic */ Batcher this$0;
                final /* synthetic */ List<String> $sentenceStrings;
                final /* synthetic */ Project $project;
                final /* synthetic */ List<SentenceWithExclusions> $sentences;
                {
                    this.$support = $support;
                    this.this$0 = $receiver;
                    this.$sentenceStrings = $sentenceStrings;
                    this.$project = $project;
                    this.$sentences = $sentences;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var21_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            start = System.currentTimeMillis();
                            asyncLabels = this.$support.needsNer() != false ? BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends SentenceWithNERAnnotations>>, Object>(this.this$0, this.$sentenceStrings, this.$project, null){
                                int label;
                                final /* synthetic */ Batcher this$0;
                                final /* synthetic */ List<String> $sentenceStrings;
                                final /* synthetic */ Project $project;
                                {
                                    this.this$0 = $receiver;
                                    this.$sentenceStrings = $sentenceStrings;
                                    this.$project = $project;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = APIQueries.INSTANCE.nerAnnotations(this.this$0.getLanguage(), this.$sentenceStrings, this.$project, (Continuation<? super List<SentenceWithNERAnnotations>>)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super List<SentenceWithNERAnnotations>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null) : null;
                            v0 = this.this$0.getLanguage();
                            v1 = this.$support.getCloudTreeModelName();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getCloudTreeModelName(...)");
                            v2 = this.$support.getCloudParserOptions();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"getCloudParserOptions(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = asyncLabels;
                            this.J$0 = start;
                            this.label = 1;
                            v3 = APIQueries.INSTANCE.trees(v0, v1, v2, this.$sentenceStrings, this.$project, (Continuation<? super List<SentenceWithTreeDependencies>>)((Continuation)this));
                            if (v3 == var21_3) {
                                return var21_3;
                            }
                            ** GOTO lbl26
                        }
                        case 1: {
                            start = this.J$0;
                            asyncLabels = (Deferred)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl26:
                            // 2 sources

                            trees = (List)v3;
                            v4 /* !! */  = asyncLabels;
                            if (v4 /* !! */  == null) ** GOTO lbl-1000
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)asyncLabels);
                            this.L$2 = trees;
                            this.J$0 = start;
                            this.label = 2;
                            v5 = v4 /* !! */ .await((Continuation)this);
                            if (v5 == var21_3) {
                                return var21_3;
                            }
                            ** GOTO lbl44
                        }
                        case 2: {
                            start = this.J$0;
                            trees = (List)this.L$2;
                            asyncLabels = (Deferred)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl44:
                            // 2 sources

                            if ((v4 /* !! */  = (List)v5) != null) {
                                $this$associateBy$iv = (Iterable)v4 /* !! */ ;
                                $i$f$associateBy = false;
                                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                                var13_12 = $this$associateBy$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                $i$f$associateByTo = false;
                                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                                    var18_19 = (SentenceWithNERAnnotations)element$iv$iv;
                                    var20_21 = destination$iv$iv;
                                    $i$a$-associateBy-DependencyParser$Batcher$parse$2$labels$1 = false;
                                    var20_21.put(it.getText(), element$iv$iv);
                                }
                                v6 = destination$iv$iv;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v6 = MapsKt.emptyMap();
                            }
                            labels = v6;
                            DependencyParser.access$getLOG$p().debug("Parsing servers responded in " + (System.currentTimeMillis() - start) + "ms for " + this.$sentenceStrings.size() + " sentences");
                            if (trees == null) {
                                v7 = MapsKt.emptyMap();
                            } else {
                                var8_23 = CollectionsKt.zip((Iterable)this.$sentences, (Iterable)trees);
                                var9_24 = this.$support;
                                $i$f$associate = false;
                                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                                capacity$iv = $this$associate$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                $i$f$associateTo = false;
                                for (T element$iv$iv : $this$associateTo$iv$iv) {
                                    var17_18 = destination$iv$iv;
                                    it = (Pair)element$iv$iv;
                                    $i$a$-associate-DependencyParser$Batcher$parse$2$1 = false;
                                    var18_19 = TuplesKt.to((Object)it.getFirst(), (Object)var9_24.buildTree((SentenceWithTreeDependencies)it.getSecond(), (SentenceWithNERAnnotations)labels.get(((SentenceWithExclusions)it.getFirst()).getSentence())));
                                    var17_18.put(var18_19.getFirst(), var18_19.getSecond());
                                }
                                v7 = destination$iv$iv;
                            }
                            return v7;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Map<SentenceWithExclusions, ? extends Tree>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        protected void reportStatus(@NotNull RawProgressReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            super.reportStatus(reporter);
            reporter.text(GrazieProBundle.msg("progress.text.parsing.natural.language.text", new String[0]));
        }
    }

    @Service
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/grazie/pro/DependencyParser$BatcherHolder;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "batchers", "", "Lai/grazie/nlp/langs/Language;", "Lcom/intellij/ml/grazie/pro/DependencyParser$Batcher;", "getBatchers", "()Ljava/util/Map;", "clearCaches", "", "dispose", "intellij.ml.grazie.pro"})
    @SourceDebugExtension(value={"SMAP\nDependencyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyParser.kt\ncom/intellij/ml/grazie/pro/DependencyParser$BatcherHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1869#2,2:159\n1869#2,2:161\n*S KotlinDebug\n*F\n+ 1 DependencyParser.kt\ncom/intellij/ml/grazie/pro/DependencyParser$BatcherHolder\n*L\n120#1:159,2\n124#1:161,2\n*E\n"})
    private static final class BatcherHolder
    implements Disposable {
        @NotNull
        private final Map<ai.grazie.nlp.langs.Language, Batcher> batchers;

        public BatcherHolder() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ai.grazie.nlp.langs.Language.ENGLISH, (Object)new Batcher(ai.grazie.nlp.langs.Language.ENGLISH)), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.GERMAN, (Object)new Batcher(ai.grazie.nlp.langs.Language.GERMAN)), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.UKRAINIAN, (Object)new Batcher(ai.grazie.nlp.langs.Language.UKRAINIAN)), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.RUSSIAN, (Object)new Batcher(ai.grazie.nlp.langs.Language.RUSSIAN))};
            this.batchers = MapsKt.mapOf((Pair[])pairArray);
            GrazieProConfig.Companion.subscribe(this, (Function1<? super GrazieProConfig.State, Unit>)((Function1)arg_0 -> BatcherHolder._init_$lambda$0(this, arg_0)));
            LoginManager.Companion.subscribe(this, (Function0<Unit>)((Function0)() -> BatcherHolder._init_$lambda$1(this)));
            HighlightingUtil.addGrazieConfigListener(this, new GrazieStateLifecycle(){

                public void update(GrazieConfig.State prevState, GrazieConfig.State newState) {
                    Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
                    Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                    this.clearCaches();
                }
            });
        }

        @NotNull
        public final Map<ai.grazie.nlp.langs.Language, Batcher> getBatchers() {
            return this.batchers;
        }

        private final void clearCaches() {
            supports.clear();
            Iterable $this$forEach$iv = this.batchers.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Batcher it = (Batcher)element$iv;
                boolean bl = false;
                it.clearCache();
            }
        }

        public void dispose() {
            Iterable $this$forEach$iv = this.batchers.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Disposable p0 = (Disposable)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
        }

        private static final Unit _init_$lambda$0(BatcherHolder this$0, GrazieProConfig.State it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.clearCaches();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(BatcherHolder this$0) {
            this$0.clearCaches();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ai.grazie.nlp.langs.Language.values().length];
            try {
                nArray[ai.grazie.nlp.langs.Language.ENGLISH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ai.grazie.nlp.langs.Language.GERMAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ai.grazie.nlp.langs.Language.UKRAINIAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ai.grazie.nlp.langs.Language.RUSSIAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

