/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.WhitespaceWordTokenizer;
import ai.grazie.rules.toolkit.LanguageToolkit;
import com.google.common.base.Strings;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.ml.grazie.pro.GrazieProBundle;
import com.intellij.ml.grazie.pro.GrazieProConfig;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.ParsedSentence;
import com.intellij.ml.grazie.pro.SentenceTokenizer;
import com.intellij.ml.grazie.pro.TreeRuleChecker;
import com.intellij.ml.grazie.pro.cloud.APIQueries;
import com.intellij.ml.grazie.pro.fus.GrazieProCounterUsagesCollector;
import com.intellij.ml.grazie.pro.ui.PaddedListCellRenderer;
import com.intellij.ml.grazie.pro.utils.GrazieUtilsKt;
import com.intellij.ml.grazie.pro.utils.TextUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RephraseAction
extends IntentionAndQuickFixAction {
    RephraseAction() {
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = GrazieProBundle.msg("intention.rephrase.text", new String[0]);
        if (string == null) {
            RephraseAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RephraseAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(2);
        }
        if (GrazieUtilsKt.isFunctionallyDisabled()) {
            return false;
        }
        if (editor == null || CommitMessage.isCommitMessage((PsiElement)psiFile)) {
            return false;
        }
        if (!GrazieProConfig.get().seemsCloudConnected()) {
            return false;
        }
        TextContent content = TextExtractor.findTextAt((PsiFile)psiFile, (int)editor.getCaretModel().getOffset(), (Set)TextContent.TextDomain.ALL);
        if (content == null) {
            return false;
        }
        TextRange range = content.fileRangeToText(HighlightingUtil.selectionRange(editor));
        if (range == null) {
            return false;
        }
        Language language = LangDetector.INSTANCE.getLanguage(content.toString());
        if (language == null || !APIQueries.rephraseLanguages.contains(language)) {
            return false;
        }
        return SentenceTokenizer.tokenize(content).stream().anyMatch(t -> t.start() <= range.getStartOffset() && range.getEndOffset() <= t.end());
    }

    public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        SuggestionsWithLanguage rephraseData = (SuggestionsWithLanguage)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (SuggestionsWithLanguage)ReadAction.compute(() -> {
            ParsedSentence sentence = ParsedSentence.findSentenceInFile(psiFile, selStart);
            if (sentence == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), null, null, null);
            }
            Integer sentenceLength = sentence.text.length();
            TextRange textRange = RephraseAction.fileRangeToText(selStart, selEnd, sentence);
            if (textRange == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), sentenceLength, null, null);
            }
            Language iso = LangDetector.INSTANCE.getLanguage(sentence.text);
            if (iso == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), sentenceLength, null, null);
            }
            String rangeText = textRange.subSequence((CharSequence)sentence.text).toString();
            int wordsRangeCount = WhitespaceWordTokenizer.INSTANCE.words(rangeText).size();
            int rangeLength = textRange.getLength();
            GrazieProCounterUsagesCollector.reportRephraseRequested(iso, sentence.text.length(), rangeLength, wordsRangeCount);
            List<TextRange> ranges = RephraseAction.getRangesToRephrase(sentence, textRange);
            List<String> result2 = APIQueries.rephrase(sentence.text, ranges, iso, project);
            if (result2 == null) {
                return new SuggestionsWithLanguage(iso, Collections.emptyList(), sentenceLength, rangeLength, wordsRangeCount);
            }
            TextRange minRange = TextUtils.alignToWordBounds(textRange, sentence.text);
            List suggestions = ContainerUtil.mapNotNull(result2, s -> RephraseAction.toListItem(minRange, sentence, sentence.text, s));
            return new SuggestionsWithLanguage(iso, suggestions, sentenceLength, rangeLength, wordsRangeCount);
        }), GrazieProBundle.msg("intention.rephrase.progress.title", new String[0]), true, project);
        if (rephraseData.suggestions().isEmpty()) {
            GrazieProCounterUsagesCollector.reportRephraseEmpty(rephraseData.language, rephraseData.textLength, rephraseData.rangeLength, rephraseData.wordRangeCount);
            HintManager.getInstance().showErrorHint(editor, GrazieProBundle.msg("intention.rephrase.no.results.popup", new String[0]));
            return;
        }
        this.showPopup(project, editor, psiFile, rephraseData);
    }

    @Nullable
    private static TextRange fileRangeToText(int selStart, int selEnd, ParsedSentence sentence) {
        Integer textStart = sentence.fileOffsetToText(selStart);
        Integer textEnd = sentence.fileOffsetToText(selEnd);
        return textStart == null || textEnd == null ? null : new TextRange(textStart.intValue(), textEnd.intValue());
    }

    private static ListItem toListItem(TextRange minRange, ParsedSentence sentence, String sentenceText, String suggestion) {
        int commonPrefix = Strings.commonPrefix((CharSequence)sentenceText, (CharSequence)suggestion).length();
        int commonSuffix = Strings.commonSuffix((CharSequence)sentenceText, (CharSequence)suggestion.substring(commonPrefix)).length();
        if (commonPrefix > minRange.getEndOffset() + 1 || sentenceText.length() - commonSuffix < minRange.getStartOffset() - 1) {
            return null;
        }
        TextRange range = TextUtils.alignToWordBounds(new TextRange(Math.min(minRange.getStartOffset(), commonPrefix), Math.max(sentenceText.length() - commonSuffix, minRange.getEndOffset())), sentenceText);
        String replacement = suggestion.substring(range.getStartOffset(), suggestion.length() - (sentenceText.length() - range.getEndOffset()));
        TextRange fileRange = new TextRange(sentence.textOffsetToFile(range.getStartOffset()), sentence.textOffsetToFile(range.getEndOffset()));
        return new ListItem(fileRange, replacement);
    }

    private void showPopup(Project project, Editor editor, PsiFile file, final SuggestionsWithLanguage descriptor) {
        final Ref highlighter = new Ref();
        final List<ListItem> suggestions = descriptor.suggestions();
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(suggestions).setSelectionMode(0).setRenderer((ListCellRenderer)new PaddedListCellRenderer()).setItemChosenCallback(item -> WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getName(), null, () -> {
            int selectedRank = suggestions.indexOf(item);
            int textLength = item.fileRange.getEndOffset() - item.fileRange.getStartOffset();
            editor.getDocument().replaceString(item.fileRange.getStartOffset(), item.fileRange.getEndOffset(), (CharSequence)item.replacement);
            int rephraseLength = item.replacement.length();
            int rephraseWordCount = WhitespaceWordTokenizer.INSTANCE.words(item.replacement).size();
            GrazieProCounterUsagesCollector.reportRephraseApplied(descriptor.language, suggestions.size(), rephraseLength, rephraseWordCount, selectedRank);
        }, (PsiFile[])new PsiFile[]{file})).setNamerForFiltering(i -> i.replacement).setItemSelectedCallback(item -> {
            RephraseAction.dropHighlighter((Ref<RangeHighlighter>)highlighter);
            if (item != null) {
                highlighter.set((Object)editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, item.fileRange.getStartOffset(), item.fileRange.getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE));
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RephraseAction.dropHighlighter((Ref<RangeHighlighter>)highlighter);
                if (!event.isOk()) {
                    GrazieProCounterUsagesCollector.reportRephraseRejected(descriptor.language(), suggestions.size());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ml/grazie/pro/RephraseAction$1", "onClosed"));
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static void dropHighlighter(Ref<RangeHighlighter> highlighter) {
        RangeHighlighter rh = (RangeHighlighter)highlighter.get();
        if (rh != null) {
            rh.dispose();
        }
        highlighter.set(null);
    }

    private static List<TextRange> getRangesToRephrase(ParsedSentence sentence, TextRange textRange) {
        ai.grazie.rules.tree.TextRange range;
        if (textRange.getLength() > 0) {
            return List.of(TextUtils.alignToWordBounds(textRange, sentence.text));
        }
        LanguageToolkit toolkit = LanguageToolkit.forLanguage(sentence.tree.treeSupport().getGrazieLanguage());
        List<ai.grazie.rules.tree.TextRange> extendRanges = toolkit.selectioner().calcExtendSelectionRanges(sentence.tree, textRange.getStartOffset(), textRange.getEndOffset());
        assert (!extendRanges.isEmpty());
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        result2.add(TreeRuleChecker.toIdeaRange(extendRanges.get(0)));
        for (int i = 1; i < extendRanges.size() && com.intellij.openapi.util.text.Strings.countChars((CharSequence)sentence.text.substring((range = extendRanges.get(i)).start(), range.end()), (char)' ') <= 10; ++i) {
            result2.add(TreeRuleChecker.toIdeaRange(range));
        }
        return result2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ml/grazie/pro/RephraseAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ml/grazie/pro/RephraseAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public record SuggestionsWithLanguage(@NotNull Language language, @NotNull List<ListItem> suggestions, @Nullable Integer textLength, @Nullable Integer rangeLength, @Nullable Integer wordRangeCount) {
        @NotNull
        private final Language language;
        @NotNull
        private final List<ListItem> suggestions;

        public SuggestionsWithLanguage(@NotNull Language language, @NotNull List<ListItem> suggestions, @Nullable Integer textLength, @Nullable Integer rangeLength, @Nullable Integer wordRangeCount) {
            if (language == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(0);
            }
            if (suggestions == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Language language() {
            Language language = this.language;
            if (language == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(2);
            }
            return language;
        }

        @NotNull
        public List<ListItem> suggestions() {
            List<ListItem> list = this.suggestions;
            if (list == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ml/grazie/pro/RephraseAction$SuggestionsWithLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ml/grazie/pro/RephraseAction$SuggestionsWithLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "language";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record ListItem(TextRange fileRange, String replacement) {
        @Override
        public String toString() {
            return this.replacement;
        }
    }
}

