/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.util;

import ai.grazie.nlp.tokenizer.Tokenizer;
import com.intellij.grazie.text.TextContent;
import com.intellij.ml.grazie.pro.SentenceTokenizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public record QuotedMarkup(TextContent.WithMarkup seq, TextContent original, List<Tokenizer.Token> sentences) {
    private static final Key<QuotedMarkup> quotedText = Key.create((String)"grazie pro quoted text");

    @Nullable
    public static QuotedMarkup createFrom(TextContent content) {
        QuotedMarkup result2 = (QuotedMarkup)content.getUserData(quotedText);
        if (result2 == null) {
            if (content.markupOffsets().length == 0) {
                return null;
            }
            TextContent.WithMarkup seq = content.replaceMarkupWith('\"');
            result2 = new QuotedMarkup(seq, content, SentenceTokenizer.tokenize((CharSequence)seq));
            content.putUserData(quotedText, (Object)result2);
        }
        return result2;
    }

    public TextRange quotedToOriginal(TextRange range) {
        return new TextRange(this.seq.offsetToOriginal(range.getStartOffset()), this.seq.offsetToOriginal(range.getEndOffset()));
    }
}

