/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.yaml;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextProblem;
import com.intellij.ml.grazie.pro.utils.GrazieUtilsKt;
import com.intellij.ml.grazie.pro.yaml.YamlRuleWrapper;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RuleEngineStyleGuideProblemFilter
extends ProblemFilter {
    private static final String ASSORTED_RULE_ID_PREFIX = YamlRuleWrapper.toGlobalId("Assorted Style Guides.yaml");

    RuleEngineStyleGuideProblemFilter() {
    }

    public boolean shouldIgnore(@NotNull TextProblem problem) {
        if (problem == null) {
            RuleEngineStyleGuideProblemFilter.$$$reportNull$$$0(0);
        }
        if (GrazieUtilsKt.isFunctionallyDisabled()) {
            return false;
        }
        List ranges = problem.getHighlightRanges();
        if (problem instanceof YamlRuleWrapper.YamlProblem && ranges.size() == 1) {
            TextRange range = (TextRange)ranges.get(0);
            String problemText = range.subSequence((CharSequence)problem.getText()).toString();
            String id = problem.getRule().getGlobalId();
            if (id.startsWith(ASSORTED_RULE_ID_PREFIX)) {
                return "application".equals(problemText) && problem.getText().toString().substring(range.getEndOffset()).matches("/[a-z]+.*");
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/intellij/ml/grazie/pro/yaml/RuleEngineStyleGuideProblemFilter", "shouldIgnore"));
    }
}

