/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context;

import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/context/ContextRetrievalFilter;", "", "<init>", "()V", "disabledRetrievers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "disabledTransformers", "disabledPostProcessors", "enableRetriever", "", "id", "enabled", "enableTransformer", "enablePostProcessor", "isRetrieverEnabled", "isTransformerEnabled", "isPostProcessorEnabled", "intellij.ml.llm.context"})
public final class ContextRetrievalFilter {
    @NotNull
    private final CopyOnWriteArraySet<String> disabledRetrievers = new CopyOnWriteArraySet();
    @NotNull
    private final CopyOnWriteArraySet<String> disabledTransformers = new CopyOnWriteArraySet();
    @NotNull
    private final CopyOnWriteArraySet<String> disabledPostProcessors = new CopyOnWriteArraySet();

    public final boolean enableRetriever(@NotNull String id, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        boolean wasEnabled = !this.disabledRetrievers.contains(id);
        boolean bl = enabled ? this.disabledRetrievers.remove(id) : this.disabledRetrievers.add(id);
        return wasEnabled;
    }

    public final boolean enableTransformer(@NotNull String id, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        boolean wasEnabled = !this.disabledTransformers.contains(id);
        boolean bl = enabled ? this.disabledTransformers.remove(id) : this.disabledTransformers.add(id);
        return wasEnabled;
    }

    public final boolean enablePostProcessor(@NotNull String id, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        boolean wasEnabled = !this.disabledPostProcessors.contains(id);
        boolean bl = enabled ? this.disabledPostProcessors.remove(id) : this.disabledPostProcessors.add(id);
        return wasEnabled;
    }

    public final boolean isRetrieverEnabled(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !this.disabledRetrievers.contains(id);
    }

    public final boolean isTransformerEnabled(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !this.disabledTransformers.contains(id);
    }

    public final boolean isPostProcessorEnabled(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !this.disabledPostProcessors.contains(id);
    }
}

