/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.settings.LLMDataSharingManager;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.rating.InsightRating;
import com.intellij.ml.llm.daemon.insight.ui.FeedbackPanel;
import com.intellij.ml.llm.daemon.insight.ui.InsightRenderTextBlock;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u00020\u001cH\u0002J\u0014\u0010 \u001a\u00020\u00112\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J,\u0010#\u001a\u00020\u001a2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\f\u0010*\u001a\u00020+*\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;)V", "rating", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "getRating", "()Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "block", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock;", "iconGap", "", "buttonWidth", "buttonHeight", "highlightedButton", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Rating;", "buttonY", "likeX", "dislikeX", "processHover", "", "point", "Ljava/awt/Point;", "processOutOfHover", "processClick", "findButtonUnder", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "formatTabs", "", "intellij.ml.llm.daemon"})
public final class InsightElementRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final InsightModel insight;
    @NotNull
    private final InsightRenderTextBlock block;
    private final int iconGap;
    private final int buttonWidth;
    private final int buttonHeight;
    @Nullable
    private InsightRating.Rating highlightedButton;
    private int buttonY;
    private int likeX;
    private int dislikeX;

    public InsightElementRenderer(@NotNull Editor editor2, @NotNull Project project2, @NotNull InsightModel insight) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        this.editor = editor2;
        this.project = project2;
        this.insight = insight;
        this.block = new InsightRenderTextBlock(this.formatTabs(this.insight.getText()));
        this.iconGap = 5;
        this.buttonWidth = MLLlmIcons.Like.getIconWidth();
        this.buttonHeight = MLLlmIcons.Like.getIconHeight();
        this.highlightedButton = this.getRating().getRating(this.insight);
        this.buttonY = -1;
        this.likeX = -1;
        this.dislikeX = -1;
    }

    private final InsightRating getRating() {
        return InsightRating.Companion.getInstance(this.project);
    }

    public final void processHover(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.getRating().getRating(this.insight) != null) {
            return;
        }
        InsightRating.Rating rating = this.findButtonUnder(point);
        if (rating == null) {
            InsightElementRenderer $this$processHover_u24lambda_u240 = this;
            boolean bl = false;
            if ($this$processHover_u24lambda_u240.highlightedButton != null) {
                $this$processHover_u24lambda_u240.highlightedButton = null;
                $this$processHover_u24lambda_u240.editor.getContentComponent().repaint();
            }
            return;
        }
        InsightRating.Rating button2 = rating;
        if (button2 != this.highlightedButton) {
            this.highlightedButton = button2;
            this.editor.getContentComponent().repaint();
            return;
        }
    }

    public final void processOutOfHover() {
        if (this.getRating().getRating(this.insight) == null && this.highlightedButton != null) {
            this.highlightedButton = null;
            this.editor.getContentComponent().repaint();
        }
    }

    public final void processClick(@NotNull Point point) {
        InsightRating.Rating button2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        LLMDataSharingManager.Companion.askDataSharingConsentIfNeeded(this.project);
        if (this.getRating().getRating(this.insight) != null) {
            return;
        }
        InsightRating.Rating rating = this.findButtonUnder(point);
        if (rating == null) {
            return;
        }
        this.highlightedButton = button2 = rating;
        this.getRating().addRating(this.insight, button2);
        new FeedbackPanel().show(this.editor, this.project, this.insight, button2, point);
    }

    private final InsightRating.Rating findButtonUnder(Point $this$findButtonUnder) {
        int n = this.likeX;
        int n2 = this.likeX + this.buttonWidth;
        int n3 = $this$findButtonUnder.x;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            return InsightRating.Rating.LIKE;
        }
        n = this.dislikeX;
        n2 = this.dislikeX + this.buttonWidth;
        n3 = $this$findButtonUnder.x;
        boolean bl2 = n <= n3 ? n3 <= n2 : false;
        if (bl2) {
            return InsightRating.Rating.DISLIKE;
        }
        return null;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Font font = this.editor.getColorsScheme().getFont(this.block.getFontType());
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        FontMetrics fontMetrics = this.editor.getContentComponent().getFontMetrics(font2);
        return fontMetrics.stringWidth(this.block.getText()) + this.buttonWidth * 2 + this.iconGap * 3;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        if (((CharSequence)this.block.getText()).length() == 0) {
            return;
        }
        g.setFont(this.editor.getColorsScheme().getFont(this.block.getFontType()));
        g.setColor((Color)this.block.getForegroundColor());
        g.drawString(this.block.getText(), targetRegion.x, targetRegion.y + this.editor.getAscent());
        this.buttonY = targetRegion.y + (targetRegion.height - this.buttonHeight) / 2;
        this.likeX = targetRegion.x + g.getFontMetrics().stringWidth(this.block.getText()) + this.iconGap;
        Icon icon2 = this.highlightedButton == InsightRating.Rating.LIKE ? MLLlmIcons.LikeSelected : MLLlmIcons.Like;
        Intrinsics.checkNotNull((Object)icon2);
        Icon likeIcon = icon2;
        likeIcon.paintIcon(this.editor.getContentComponent(), g, this.likeX, this.buttonY);
        this.dislikeX = this.likeX + this.buttonWidth + this.iconGap;
        Icon icon3 = this.highlightedButton == InsightRating.Rating.DISLIKE ? MLLlmIcons.DislikeSelected : MLLlmIcons.Dislike;
        Intrinsics.checkNotNull((Object)icon3);
        Icon dislikeIcon = icon3;
        dislikeIcon.paintIcon(this.editor.getContentComponent(), g, this.dislikeX, this.buttonY);
    }

    private final String formatTabs(String $this$formatTabs) {
        int tabSize = this.editor.getSettings().getTabSize(this.editor.getProject());
        String tab = StringsKt.repeat((CharSequence)" ", (int)tabSize);
        return StringsKt.replace$default((String)$this$formatTabs, (String)"\t", (String)tab, (boolean)false, (int)4, null);
    }
}

