/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.dbConnection.service;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.dataspell.llm.DatabaseLlmFacade;
import com.intellij.ml.llm.ds.agents.dbConnection.model.ConnectionTypeModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.DbConnectionSolutionModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.DbConnectivityModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.DbConnectivitySolutionModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.DriverModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.ParameterModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.ParameterSolutionModel;
import com.intellij.ml.llm.ds.agents.dbConnection.model.ValueModel;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\u00020\t*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u0007*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010'\u001a\u0004\u0018\u00010\u0014*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/ds/agents/dbConnection/service/DbConnectivityService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isAvailable", "", "getDbConnectivityModel", "Lcom/intellij/ml/llm/ds/agents/dbConnection/model/DbConnectivityModel;", "buildDbConnectivityModel", "Lcom/intellij/database/dataSource/DatabaseDriverManager;", "buildDriverModel", "Lcom/intellij/ml/llm/ds/agents/dbConnection/model/DriverModel;", "Lcom/intellij/database/dataSource/DatabaseDriver;", "buildConnectionTypeModel", "Lcom/intellij/ml/llm/ds/agents/dbConnection/model/ConnectionTypeModel;", "", "Lcom/intellij/database/dataSource/url/StatelessJdbcUrlParser;", "name", "", "buildParameterModel", "Lcom/intellij/ml/llm/ds/agents/dbConnection/model/ParameterModel;", "Lcom/intellij/database/dataSource/url/template/StatelessParametersHolder$ParameterInfo;", "adjustedDrivers", "getAdjustedDrivers", "(Lcom/intellij/database/dataSource/DatabaseDriverManager;)Ljava/util/List;", "isActual", "(Lcom/intellij/database/dataSource/DatabaseDriver;)Z", "applyDbConnectivitySolution", "solution", "Lcom/intellij/ml/llm/ds/agents/dbConnection/model/DbConnectivitySolutionModel;", "createDataSourceURL", "driver", "Lcom/intellij/ml/llm/ds/agents/dbConnection/model/DbConnectionSolutionModel;", "createDataSource", "Ljava/lang/Object;", "Lcom/intellij/database/dataSource/DatabaseDriverImpl;", "url", "nonDefaultName", "getNonDefaultName", "(Lcom/intellij/database/dataSource/url/StatelessJdbcUrlParser;)Ljava/lang/String;", "intellij.ml.llm.ds"})
@SourceDebugExtension(value={"SMAP\nDbConnectivityService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbConnectivityService.kt\ncom/intellij/ml/llm/ds/agents/dbConnection/service/DbConnectivityService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n50#2:112\n30#2,2:162\n1563#3:113\n1634#3,3:114\n1491#3:117\n1516#3,3:118\n1519#3,3:128\n1563#3:131\n1634#3,3:132\n1617#3,9:135\n1869#3:144\n1870#3:146\n1626#3:147\n1193#3,2:149\n1267#3,4:151\n1740#3,3:155\n1563#3:158\n1634#3,3:159\n1491#3:164\n1516#3,3:165\n1519#3,3:175\n382#4,7:121\n382#4,7:168\n1#5:145\n1#5:148\n*S KotlinDebug\n*F\n+ 1 DbConnectivityService.kt\ncom/intellij/ml/llm/ds/agents/dbConnection/service/DbConnectivityService\n*L\n19#1:112\n84#1:162,2\n30#1:113\n30#1:114,3\n35#1:117\n35#1:118,3\n35#1:128,3\n35#1:131\n35#1:132,3\n42#1:135,9\n42#1:144\n42#1:146\n42#1:147\n52#1:149,2\n52#1:151,4\n70#1:155,3\n83#1:158\n83#1:159,3\n89#1:164\n89#1:165,3\n89#1:175,3\n35#1:121,7\n89#1:168,7\n42#1:145\n*E\n"})
public final class DbConnectivityService {
    @NotNull
    private final Project project;

    public DbConnectivityService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public final boolean isAvailable() {
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)this.project;
        boolean $i$f$serviceOrNull = false;
        return $this$serviceOrNull$iv.getService(DatabaseLlmFacade.class) != null;
    }

    @NotNull
    public final DbConnectivityModel getDbConnectivityModel() {
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        Intrinsics.checkNotNull((Object)driverManager);
        return this.buildDbConnectivityModel(driverManager);
    }

    /*
     * WARNING - void declaration
     */
    private final DbConnectivityModel buildDbConnectivityModel(DatabaseDriverManager $this$buildDbConnectivityModel) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getAdjustedDrivers($this$buildDbConnectivityModel);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DatabaseDriver databaseDriver = (DatabaseDriver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.buildDriverModel((DatabaseDriver)it));
        }
        List drivers = (List)destination$iv$iv;
        return new DbConnectivityModel(drivers);
    }

    /*
     * WARNING - void declaration
     */
    private final DriverModel buildDriverModel(DatabaseDriver $this$buildDriverModel) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        List list = $this$buildDriverModel.getJDBCUrlParsers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJDBCUrlParsers(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (StatelessJdbcUrlParser)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String key$iv$iv = this.getNonDefaultName((StatelessJdbcUrlParser)it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.entrySet();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(this.buildConnectionTypeModel((List)it.getValue(), (String)it.getKey()));
        }
        List connectionTypes = (List)destination$iv$iv;
        String string = $this$buildDriverModel.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$buildDriverModel.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new DriverModel(string, string2, connectionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final ConnectionTypeModel buildConnectionTypeModel(List<? extends StatelessJdbcUrlParser> $this$buildConnectionTypeModel, String name) {
        void $this$mapNotNullTo$iv$iv;
        StatelessJdbcUrlParser parser = (StatelessJdbcUrlParser)CollectionsKt.first($this$buildConnectionTypeModel);
        Collection collection = parser.getParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getParameterNames(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ParameterModel parameterModel;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            StatelessParametersHolder.ParameterInfo parameterInfo = parser.getParameterInfo(it);
            if (parameterInfo != null) {
                Intrinsics.checkNotNull((Object)it);
                parameterModel = this.buildParameterModel(parameterInfo, it);
            } else {
                parameterModel = null;
            }
            if (parameterModel == null) continue;
            ParameterModel it$iv$iv = parameterModel;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List parameters = (List)destination$iv$iv;
        return new ConnectionTypeModel(name, parameters);
    }

    /*
     * Unable to fully structure code
     */
    private final ParameterModel buildParameterModel(StatelessParametersHolder.ParameterInfo $this$buildParameterModel, String name) {
        var4_3 = $this$buildParameterModel.getConfiguration();
        if (var4_3 == null) ** GOTO lbl-1000
        it = var4_3;
        $i$a$-let-DbConnectivityService$buildParameterModel$possibleValues$1 = false;
        var5_7 = TypesRegistry.parseConfiguration((String)it);
        if (var5_7 != null) {
            var6_8 = var5_7;
            $i$f$associate = false;
            capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            var9_9 = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
            $i$f$associateTo = false;
            for (T element$iv$iv : $this$associateTo$iv$iv) {
                var14_14 = destination$iv$iv;
                it = (Pair)element$iv$iv;
                $i$a$-associate-DbConnectivityService$buildParameterModel$possibleValues$2 = false;
                v0 = it.second;
                v1 = it.second;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"second");
                var15_15 = TuplesKt.to((Object)v0, (Object)new ValueModel((String)v1, (String)it.first));
                var14_14.put(var15_15.getFirst(), var15_15.getSecond());
            }
            v2 = destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        possibleValues = v2;
        defaultValue = $this$buildParameterModel.getDefValue();
        return new ParameterModel(name, possibleValues, defaultValue);
    }

    private final List<DatabaseDriver> getAdjustedDrivers(DatabaseDriverManager $this$adjustedDrivers) {
        Collection collection = $this$adjustedDrivers.getDrivers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrivers(...)");
        Sequence drivers = CollectionsKt.asSequence((Iterable)collection);
        Sequence uniqueDrivers = SequencesKt.distinctBy((Sequence)drivers, DbConnectivityService::_get_adjustedDrivers_$lambda$6);
        Sequence actualDrivers = SequencesKt.filter((Sequence)uniqueDrivers, arg_0 -> DbConnectivityService._get_adjustedDrivers_$lambda$7(this, arg_0));
        return SequencesKt.toList((Sequence)actualDrivers);
    }

    private final boolean isActual(DatabaseDriver $this$isActual) {
        boolean bl;
        block3: {
            Set set = $this$isActual.getConstraints();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getConstraints(...)");
            Iterable $this$all$iv = set;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DatabaseDriver.Constraint it = (DatabaseDriver.Constraint)element$iv;
                    boolean bl2 = false;
                    if (it.to == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean applyDbConnectivitySolution(@NotNull DbConnectivitySolutionModel solution) {
        void $this$mapTo$iv$iv;
        Iterable url;
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        List dataSourceConfigurations = new ArrayList();
        for (DbConnectionSolutionModel configuration : solution.getDbConnections()) {
            DatabaseDriver databaseDriver = driverManager.getDriver(configuration.getDriverId());
            DatabaseDriverImpl databaseDriverImpl = databaseDriver instanceof DatabaseDriverImpl ? (DatabaseDriverImpl)databaseDriver : null;
            if (databaseDriverImpl == null) {
                return false;
            }
            DatabaseDriverImpl driver = databaseDriverImpl;
            if (this.createDataSourceURL((DatabaseDriver)driver, configuration) == null) {
                return false;
            }
            dataSourceConfigurations.add(new kotlin.Pair((Object)driver, (Object)url));
        }
        Iterable $this$map$iv = dataSourceConfigurations;
        boolean $i$f$map = false;
        url = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            kotlin.Pair pair = (kotlin.Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createDataSource((DatabaseDriverImpl)it.getFirst(), (String)it.getSecond()));
        }
        List dataSources = (List)destination$iv$iv;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DatabaseLlmFacade> serviceClass$iv = DatabaseLlmFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((DatabaseLlmFacade)object).addDataSourcesAndSelectTablesDialog(this.project, dataSources);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String createDataSourceURL(DatabaseDriver driver, DbConnectionSolutionModel solution) {
        void $this$groupByTo$iv$iv;
        List list = driver.getJDBCUrlParsers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJDBCUrlParsers(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            StatelessJdbcUrlParser it = (StatelessJdbcUrlParser)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String key$iv$iv = this.getNonDefaultName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        List statelessJdbcUrlParsers = (List)destination$iv$iv.get(solution.getConnectionTypeName());
        List list2 = statelessJdbcUrlParsers;
        if (list2 == null || (list2 = (StatelessJdbcUrlParser)CollectionsKt.firstOrNull((List)list2)) == null) {
            return null;
        }
        List statelessJdbcUrlParser = list2;
        JdbcUrlParser jdbcUrlParser = statelessJdbcUrlParser.createStateful();
        Intrinsics.checkNotNullExpressionValue((Object)jdbcUrlParser, (String)"createStateful(...)");
        JdbcUrlParser jdbcUrlParser2 = jdbcUrlParser;
        for (ParameterSolutionModel parameter : solution.getParameters()) {
            jdbcUrlParser2.setParameter(parameter.getName(), parameter.getValue().getValue());
        }
        return jdbcUrlParser2.getUrlText();
    }

    private final Object createDataSource(DatabaseDriverImpl driver, String url) {
        LocalDataSource dataSource = driver.createDataSource(null);
        dataSource.setUrl(url);
        driver.setDefaultProperties(dataSource, true);
        Intrinsics.checkNotNull((Object)dataSource, (String)"null cannot be cast to non-null type java.lang.Object");
        return dataSource;
    }

    private final String getNonDefaultName(StatelessJdbcUrlParser $this$nonDefaultName) {
        String string;
        String it = string = $this$nonDefaultName.getName();
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it, (Object)"default") ? string : null;
    }

    private static final String _get_adjustedDrivers_$lambda$6(DatabaseDriver it) {
        return it.getName();
    }

    private static final boolean _get_adjustedDrivers_$lambda$7(DbConnectivityService this$0, DatabaseDriver it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isActual(it);
    }
}

