/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.go.testGeneration;

import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.intellij.ml.llm.core.chat.context.UtilsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.psi.PsiElementPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a&\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u001a\"\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\u0017\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u0004*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u0004*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006\u001d"}, d2={"METHOD_SIZE_LIMIT", "", "getPresentableNameAndDescription", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/privacy/PSString;", "declaration", "Lcom/intellij/psi/PsiElement;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "getFileDescription", "file", "Lcom/goide/psi/GoFile;", "getFunctionDescription", "function", "Lcom/goide/psi/GoFunctionDeclaration;", "getTypeDescription", "typeSpec", "Lcom/goide/psi/GoTypeSpec;", "targetMethod", "Lcom/goide/psi/GoMethodDeclaration;", "getDescription", "fileContents", "getTypeDeclarationText", "getFunctionStubsText", "except", "textWithoutImplementation", "getTextWithoutImplementation", "(Lcom/goide/psi/GoMethodDeclaration;)Lcom/intellij/ml/llm/privacy/PSString;", "(Lcom/goide/psi/GoFunctionDeclaration;)Lcom/intellij/ml/llm/privacy/PSString;", "intellij.ml.llm.go"})
@SourceDebugExtension(value={"SMAP\nGoTestsPromptBuildUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTestsPromptBuildUtil.kt\ncom/intellij/ml/llm/go/testGeneration/GoTestsPromptBuildUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n774#2:126\n865#2,2:127\n1617#2,9:129\n1869#2:138\n1870#2:140\n1626#2:141\n774#2:143\n865#2,2:144\n1617#2,9:146\n1869#2:155\n1870#2:157\n1626#2:158\n1#3:139\n1#3:142\n1#3:156\n1#3:159\n*S KotlinDebug\n*F\n+ 1 GoTestsPromptBuildUtil.kt\ncom/intellij/ml/llm/go/testGeneration/GoTestsPromptBuildUtilKt\n*L\n98#1:126\n98#1:127,2\n99#1:129,9\n99#1:138\n99#1:140\n99#1:141\n83#1:143\n83#1:144,2\n85#1:146,9\n85#1:155\n85#1:157\n85#1:158\n99#1:139\n85#1:156\n*E\n"})
public final class GoTestsPromptBuildUtilKt {
    public static final int METHOD_SIZE_LIMIT = 300;

    @Nullable
    public static final Pair<PSString, PSString> getPresentableNameAndDescription(@NotNull PsiElement declaration, @NotNull Tokenizer tokenizer) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        PsiElement psiElement = declaration;
        if (psiElement instanceof GoFile) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.go.privacy.extensions.ExtensionsKtKt.getPrivacySafe((GoFile)declaration).getName()};
            PSString fileName = ConstantsKt.getPrivacyConst((String)"all functions and methods in file `%s`").format(pSStringConvertibleArray);
            PSString fileDescription = GoTestsPromptBuildUtilKt.getFileDescription((GoFile)declaration, tokenizer);
            pair = TuplesKt.to((Object)fileName, (Object)fileDescription);
        } else if (psiElement instanceof GoFunctionDeclaration) {
            PSStringConvertible[] fileDescription = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)declaration).getName()};
            PSString functionName = ConstantsKt.getPrivacyConst((String)"the function `%s`").format(fileDescription);
            PSString functionDescription = GoTestsPromptBuildUtilKt.getFunctionDescription((GoFunctionDeclaration)declaration);
            pair = TuplesKt.to((Object)functionName, (Object)functionDescription);
        } else if (psiElement instanceof GoMethodDeclaration) {
            PSStringConvertible[] pSStringConvertibleArray = ((GoMethodDeclaration)declaration).getReceiverType();
            GoPointerType goPointerType = pSStringConvertibleArray instanceof GoPointerType ? (GoPointerType)pSStringConvertibleArray : null;
            if ((goPointerType == null || (goPointerType = goPointerType.getType()) == null) && (goPointerType = ((GoMethodDeclaration)declaration).getReceiverType()) == null) {
                return null;
            }
            GoPointerType receiverType = goPointerType;
            pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)declaration).getName(), com.intellij.ml.llm.go.privacy.extensions.ExtensionsKtKt.getPrivacySafe((GoType)receiverType).getPresentationText()};
            PSString methodName = ConstantsKt.getPrivacyConst((String)"the method `%s` in `%s`").format(pSStringConvertibleArray);
            PsiElement psiElement2 = receiverType.resolve(declaration);
            GoTypeSpec goTypeSpec = psiElement2 instanceof GoTypeSpec ? (GoTypeSpec)psiElement2 : null;
            if (goTypeSpec == null) {
                return null;
            }
            GoTypeSpec receiverTypeSpec = goTypeSpec;
            PSString methodDescription = GoTestsPromptBuildUtilKt.getTypeDescription(receiverTypeSpec, (GoMethodDeclaration)declaration, tokenizer);
            pair = TuplesKt.to((Object)methodName, (Object)methodDescription);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final PSString getFileDescription(GoFile file, Tokenizer tokenizer) {
        PSString contents = PSStringKt.buildStringPrivacySafe(arg_0 -> GoTestsPromptBuildUtilKt.getFileDescription$lambda$0(file, tokenizer, arg_0));
        return GoTestsPromptBuildUtilKt.getDescription(file, contents);
    }

    private static final PSString getFunctionDescription(GoFunctionDeclaration function) {
        PsiFile psiFile = function.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        GoFile file = (GoFile)psiFile;
        PSString contents = UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)function)).plus(GoTestsPromptBuildUtilKt.getFunctionStubsText(file, function));
        return GoTestsPromptBuildUtilKt.getDescription(file, contents);
    }

    @NotNull
    public static final PSString getTypeDescription(@NotNull GoTypeSpec typeSpec, @Nullable GoMethodDeclaration targetMethod, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)typeSpec, (String)"typeSpec");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        GoFile goFile = typeSpec.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)goFile, (String)"getContainingFile(...)");
        GoFile file = goFile;
        PSString contents = GoTestsPromptBuildUtilKt.getTypeDeclarationText(typeSpec, targetMethod, tokenizer).plus(GoTestsPromptBuildUtilKt.getFunctionStubsText$default(file, null, 2, null));
        return GoTestsPromptBuildUtilKt.getDescription(file, contents);
    }

    private static final PSString getDescription(GoFile file, PSString fileContents) {
        return PSStringKt.buildStringPrivacySafe(arg_0 -> GoTestsPromptBuildUtilKt.getDescription$lambda$4(file, fileContents, arg_0));
    }

    private static final PSString getTypeDeclarationText(GoTypeSpec typeSpec, GoMethodDeclaration targetMethod, Tokenizer tokenizer) {
        return PSStringKt.buildStringPrivacySafe(arg_0 -> GoTestsPromptBuildUtilKt.getTypeDeclarationText$lambda$8(typeSpec, targetMethod, tokenizer, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final PSString getFunctionStubsText(GoFile file, GoFunctionDeclaration except) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection = file.getFunctions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFunctions(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GoFunctionDeclaration it = (GoFunctionDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)except))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PSString it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GoFunctionDeclaration it = (GoFunctionDeclaration)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (GoTestsPromptBuildUtilKt.getTextWithoutImplementation(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return PSStringKt.joinToString$default((Iterable)((List)destination$iv$iv), (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null);
    }

    static /* synthetic */ PSString getFunctionStubsText$default(GoFile goFile, GoFunctionDeclaration goFunctionDeclaration, int n, Object object) {
        if ((n & 2) != 0) {
            goFunctionDeclaration = null;
        }
        return GoTestsPromptBuildUtilKt.getFunctionStubsText(goFile, goFunctionDeclaration);
    }

    private static final PSString getTextWithoutImplementation(GoMethodDeclaration $this$textWithoutImplementation) {
        PSString name = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)$this$textWithoutImplementation).getName();
        Object object = $this$textWithoutImplementation.getReceiver();
        if (object == null || (object = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)object)) == null || (object = ((PsiElementPrivacyWrapper)((Object)object)).getText()) == null) {
            return null;
        }
        Object receiverText = object;
        Object object2 = $this$textWithoutImplementation.getSignature();
        if (object2 == null || (object2 = ExtensionsKtKt.getPrivacySafe((PsiElement)object2)) == null || (object2 = ((PsiElementPrivacyWrapper)((Object)object2)).getText()) == null) {
            return null;
        }
        Object signatureText = object2;
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{receiverText, name, signatureText};
        return ConstantsKt.getPrivacyConst((String)"\n    func %s %s%s {\n      // implementation\n    }\n    ").format(pSStringConvertibleArray).trimIndent();
    }

    private static final PSString getTextWithoutImplementation(GoFunctionDeclaration $this$textWithoutImplementation) {
        PSString name = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)$this$textWithoutImplementation).getName();
        Object object = $this$textWithoutImplementation.getSignature();
        if (object == null || (object = ExtensionsKtKt.getPrivacySafe((PsiElement)object)) == null || (object = ((PsiElementPrivacyWrapper)((Object)object)).getText()) == null) {
            return null;
        }
        Object signatureText = object;
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{name, signatureText};
        return ConstantsKt.getPrivacyConst((String)"\n    func %s%s {\n      // implementation\n    }\n    ").format(pSStringConvertibleArray).trimIndent().trimIndent();
    }

    private static final Unit getFileDescription$lambda$0(GoFile $file, Tokenizer $tokenizer, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        for (GoTypeSpec type2 : $file.getTypes()) {
            Intrinsics.checkNotNull((Object)type2);
            $this$buildStringPrivacySafe.append(GoTestsPromptBuildUtilKt.getTypeDeclarationText(type2, null, $tokenizer));
        }
        for (GoFunctionDeclaration function : $file.getFunctions()) {
            Intrinsics.checkNotNull((Object)function);
            $this$buildStringPrivacySafe.appendLine(UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)function)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getDescription$lambda$4(GoFile $file, PSString $fileContents, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.go.privacy.extensions.ExtensionsKtKt.getPrivacySafe($file).getName()};
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"File: %s").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"```Go"));
        Object object2 = $file.getPackage();
        if (object2 != null && (object2 = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)object2)) != null && (object2 = ((PsiElementPrivacyWrapper)((Object)object2)).getText()) != null) {
            Object it = object2;
            boolean bl = false;
            $this$buildStringPrivacySafe.appendLine((PSString)it);
        }
        if ((object = $file.getImportList()) != null && (object = ExtensionsKtKt.getPrivacySafe((PsiElement)object)) != null && (object = ((PsiElementPrivacyWrapper)((Object)object)).getText()) != null) {
            Object object3;
            Object it = object3 = object;
            boolean bl = false;
            object = ((CharSequence)it).length() > 0 ? object3 : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                $this$buildStringPrivacySafe.appendLine((PSString)it);
            }
        }
        $this$buildStringPrivacySafe.appendLine($fileContents.trim());
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getTypeDeclarationText$lambda$8(GoTypeSpec $typeSpec, GoMethodDeclaration $targetMethod, Tokenizer $tokenizer, ConcatenateBuilder $this$buildStringPrivacySafe) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        List list = $typeSpec.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMethods(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GoMethodDeclaration it = (GoMethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$targetMethod))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PSString it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GoMethodDeclaration it = (GoMethodDeclaration)element$iv$iv;
            boolean bl2 = false;
            PSString compactText = UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)it));
            if (($tokenizer.count((String)compactText.unwrap()) <= 300 ? compactText : GoTestsPromptBuildUtilKt.getTextWithoutImplementation(it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List methodTexts = (List)destination$iv$iv;
        PSString compactTypeSpec = UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)$typeSpec));
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{compactTypeSpec};
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"type %s").format(pSStringConvertibleArray));
        GoMethodDeclaration goMethodDeclaration = $targetMethod;
        if (goMethodDeclaration != null) {
            GoMethodDeclaration it = goMethodDeclaration;
            boolean bl = false;
            $this$buildStringPrivacySafe.appendLine(UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)it)));
        }
        $this$buildStringPrivacySafe.appendLine(PSStringKt.joinToString$default((Iterable)methodTexts, (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null));
        return Unit.INSTANCE;
    }
}

