/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ideolog.explainWithAi;

import com.intellij.execution.filters.Filter;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainButtonItem;
import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRange;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.ml.llm.ideolog.explainWithAi.LogExplainWithAiButtonItem;
import com.intellij.ml.llm.ideolog.filter.EditorFilter;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/ideolog/explainWithAi/LogErrorExplainFilter;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "Lcom/intellij/ml/llm/ideolog/filter/EditorFilter;", "<init>", "()V", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldProcess", "", "getShouldProcess", "()Z", "isErrorBegin", "line", "", "entireLength", "", "isErrorEnd", "getErrorExplainButtonItem", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainButtonItem;", "inlayPosition", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "entireOffset", "setEditor", "", "calcInlayPosition", "getPostprocessor", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "getAdjustedLineNumber", "offset", "(I)Ljava/lang/Integer;", "intellij.ml.llm.ideolog"})
public final class LogErrorExplainFilter
extends ErrorExplainFilter
implements EditorFilter {
    private Editor editor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldProcess() {
        Boolean bl;
        if (this.editor == null) return false;
        Editor editor2 = this.editor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            editor2 = null;
        }
        if (editor2.getUserData(LargeFileEditor.LARGE_FILE_EDITOR_KEY) != null) return false;
        Editor editor3 = this.editor;
        if (editor3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            editor3 = null;
        }
        Project project2 = editor3.getProject();
        if (project2 == null) return true;
        Project project3 = project2;
        boolean bl2 = false;
        Editor editor4 = this.editor;
        if (editor4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            editor4 = null;
        }
        VirtualFile virtualFile2 = editor4.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl3 = false;
            bl = PrivacyPathCheckerKt.isAiIgnoreBlocked(project3, virtualFile3);
        } else {
            bl = null;
        }
        boolean bl4 = Intrinsics.areEqual((Object)bl, (Object)true);
        if (bl4) return false;
        return true;
    }

    public boolean isErrorBegin(@NotNull String line, int entireLength) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!Registry.Companion.is("ideolog.explain.with.ai.enabled") || !this.getShouldProcess()) {
            return false;
        }
        Integer n = this.getAdjustedLineNumber(entireLength);
        if (n == null) {
            return false;
        }
        int lineNumber = n;
        Editor editor2 = this.editor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            editor2 = null;
        }
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        int eventStart = IdeologDocumentContextKt.getIdeologContext((Document)document2).getEvent(lineNumber).getStart();
        CharSequence lineStart = line.subSequence(0, Math.min(1000, line.length()));
        return eventStart == lineNumber && new Regex("\\W(e(rror)?|severe|critical)\\s*[-:|\\]]", RegexOption.IGNORE_CASE).containsMatchIn(charSequence = lineStart);
    }

    public boolean isErrorEnd(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return true;
    }

    @NotNull
    public ErrorExplainButtonItem getErrorExplainButtonItem(int inlayPosition) {
        return new LogExplainWithAiButtonItem(inlayPosition, this.getResults(), this.getResults().size() - 1, this.getPostprocessor());
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireOffset) {
        Filter.Result result2;
        block0: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Filter.Result $this$applyFilter_u24lambda_u242 = result2 = super.applyFilter(line, entireOffset);
            boolean bl = false;
            Filter.Result result3 = $this$applyFilter_u24lambda_u242;
            if (result3 == null) break block0;
            result3.setNextAction(Filter.NextAction.CONTINUE_FILTERING);
        }
        return result2;
    }

    @Override
    public void setEditor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    public int calcInlayPosition(@NotNull String line, int entireOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return entireOffset;
    }

    @NotNull
    public ExceptionRangePostprocessor getPostprocessor() {
        return new ExceptionRangePostprocessor(this){
            final /* synthetic */ LogErrorExplainFilter this$0;
            {
                this.this$0 = $receiver;
            }

            public ExceptionRange postprocess(Document consoleDocument, ExceptionRange oldExceptionRange) {
                Intrinsics.checkNotNullParameter((Object)consoleDocument, (String)"consoleDocument");
                Intrinsics.checkNotNullParameter((Object)oldExceptionRange, (String)"oldExceptionRange");
                Integer n = LogErrorExplainFilter.access$getAdjustedLineNumber(this.this$0, oldExceptionRange.getStartOffset());
                if (n == null) {
                    return oldExceptionRange;
                }
                int lineNumber = n;
                Editor editor2 = LogErrorExplainFilter.access$getEditor$p(this.this$0);
                if (editor2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
                    editor2 = null;
                }
                Document document2 = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                int eventEnd = IdeologDocumentContextKt.getIdeologContext((Document)document2).getEvent(lineNumber).getEndInclusive();
                return new ExceptionRange(oldExceptionRange.getStartOffset(), Integer.valueOf(consoleDocument.getLineEndOffset(eventEnd)));
            }
        };
    }

    private final Integer getAdjustedLineNumber(int offset) {
        Integer n;
        Editor editor2 = this.editor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            editor2 = null;
        }
        if (offset > editor2.getDocument().getTextLength()) {
            n = null;
        } else {
            Editor editor3 = this.editor;
            if (editor3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
                editor3 = null;
            }
            n = editor3.getDocument().getLineNumber(offset);
        }
        return n;
    }

    public static final /* synthetic */ Integer access$getAdjustedLineNumber(LogErrorExplainFilter $this, int offset) {
        return $this.getAdjustedLineNumber(offset);
    }

    public static final /* synthetic */ Editor access$getEditor$p(LogErrorExplainFilter $this) {
        return $this.editor;
    }
}

