/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javascript.generate.test;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0018H\u0000\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\r\u0010\u0004\u00a8\u0006\u0019"}, d2={"TEST_SUFFIXES", "", "", "getTEST_SUFFIXES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "TEST_DIR_NAMES", "", "getTEST_DIR_NAMES", "()Ljava/util/Set;", "TEST_FILE_EXT", "getTEST_FILE_EXT", "E2E_DIR_NAMES", "getE2E_DIR_NAMES", "getUsedTestSuffix", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasTestFileName", "", "isTestDirectory", "isTestFile", "project", "Lcom/intellij/openapi/project/Project;", "isPrivateMember", "Lcom/intellij/psi/PsiElement;", "intellij.ml.llm.javascript"})
@SourceDebugExtension(value={"SMAP\nJSTestGenerationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTestGenerationUtils.kt\ncom/intellij/ml/llm/javascript/generate/test/JSTestGenerationUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class JSTestGenerationUtilsKt {
    @NotNull
    private static final String[] TEST_SUFFIXES;
    @NotNull
    private static final Set<String> TEST_DIR_NAMES;
    @NotNull
    private static final Set<String> TEST_FILE_EXT;
    @NotNull
    private static final String[] E2E_DIR_NAMES;

    @NotNull
    public static final String[] getTEST_SUFFIXES() {
        return TEST_SUFFIXES;
    }

    @NotNull
    public static final Set<String> getTEST_DIR_NAMES() {
        return TEST_DIR_NAMES;
    }

    @NotNull
    public static final Set<String> getTEST_FILE_EXT() {
        return TEST_FILE_EXT;
    }

    @NotNull
    public static final String[] getE2E_DIR_NAMES() {
        return E2E_DIR_NAMES;
    }

    @Nullable
    public static final String getUsedTestSuffix(@NotNull VirtualFile file) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String[] stringArray = TEST_SUFFIXES;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String it = string2 = stringArray[i];
                boolean bl = false;
                String string3 = file.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(...)");
                if (!StringsKt.endsWith$default((String)string3, (String)it, (boolean)false, (int)2, null)) continue;
                string = string2;
                break block1;
            }
            string = null;
        }
        return string;
    }

    public static final boolean hasTestFileName(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JSTestGenerationUtilsKt.getUsedTestSuffix(file) != null;
    }

    public static final boolean isTestDirectory(@Nullable VirtualFile file) {
        return file != null && file.isValid() && file.isDirectory() && TEST_DIR_NAMES.contains(file.getName());
    }

    public static final boolean isTestFile(@NotNull Project project2, @NotNull VirtualFile file) {
        JSFile jsFile;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid() || !CollectionsKt.contains((Iterable)TEST_FILE_EXT, (Object)file.getExtension())) {
            return false;
        }
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)file, (Project)project2);
        JSFile jSFile = jsFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        boolean bl = jSFile != null ? jSFile.isTestFile() : false;
        if (bl) {
            return true;
        }
        return JSTestGenerationUtilsKt.hasTestFileName(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrivateMember(@NotNull PsiElement $this$isPrivateMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrivateMember, (String)"<this>");
        if ($this$isPrivateMember instanceof JSQualifiedNamedElement) {
            if (((JSQualifiedNamedElement)$this$isPrivateMember).isPrivateName()) return true;
        }
        if (!($this$isPrivateMember instanceof JSAttributeListOwner)) return false;
        JSAttributeList jSAttributeList = ((JSAttributeListOwner)$this$isPrivateMember).getAttributeList();
        if ((jSAttributeList != null ? jSAttributeList.getAccessType() : null) != JSAttributeList.AccessType.PRIVATE) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{"-spec", "_spec", ".spec", ".Spec", "-test", "_test", ".test", ".Test", "-tests", "_tests", ".tests", ".Tests", "-unit", "_unit", ".unit", ".Unit", ".cy"};
        TEST_SUFFIXES = objectArray;
        objectArray = new String[]{"spec", "test", "specs", "tests", "testSrc", "__test__", "__tests__", "_test_", "_tests_"};
        TEST_DIR_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"ts", "mts", "cts", "tsx", "js", "jsx", "mjs", "cjs"};
        TEST_FILE_EXT = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"e2e", "e2e_tests", "e2e-tests", "cypress", "playwright", "Playwright", "playwright_tests", "playwright-tests"};
        E2E_DIR_NAMES = objectArray;
    }
}

