/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ml.llm.mcp.client.McpLogEntryType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "writeLogEntry", "", "writer", "Ljava/io/BufferedWriter;", "message", "", "type", "Lcom/intellij/ml/llm/mcp/client/McpLogEntryType;", "intellij.ml.llm.mcp"})
public final class McpLogEntryKt {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");

    public static final void writeLogEntry(@NotNull BufferedWriter writer, @NotNull String message, @NotNull McpLogEntryType type2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        String timestamp = LocalDateTime.now().format(DATE_FORMAT);
        String prefix = timestamp + " " + type2.getPrefix() + " - ";
        Object entry = prefix + message;
        if (StringsKt.endsWith$default((String)entry, (String)"\n", (boolean)false, (int)2, null)) {
            entry = StringsKt.dropLast((String)entry, (int)1);
        }
        writer.write((String)entry);
        writer.newLine();
        writer.flush();
    }
}

