/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.input;

import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpTool;
import com.intellij.ml.llm.mcp.client.endpoints.McpToolEndpoint;
import com.intellij.model.Pointer;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/mcp/client/input/McpToolDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "endpoint", "Lcom/intellij/ml/llm/mcp/client/endpoints/McpToolEndpoint;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/endpoints/McpToolEndpoint;Lcom/intellij/psi/PsiElement;)V", "getEndpoint", "()Lcom/intellij/ml/llm/mcp/client/endpoints/McpToolEndpoint;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.ml.llm.mcp"})
final class McpToolDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final McpToolEndpoint endpoint;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;

    public McpToolDocumentationTarget(@NotNull McpToolEndpoint endpoint, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.endpoint = endpoint;
        this.pointer = SmartPointersKt.createSmartPointer((PsiElement)element2);
    }

    @NotNull
    public final McpToolEndpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.delegatingPointer((Pointer)((Pointer)this.pointer), arg_0 -> McpToolDocumentationTarget.createPointer$lambda$1(arg_0 -> McpToolDocumentationTarget.createPointer$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"delegatingPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.endpoint.getTool().getName()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public DocumentationResult computeDocumentation() {
        Object object = new Object[]{this.endpoint.getClient().getServerCommand().getName()};
        StringBuilder sb = new StringBuilder(McpBundle.message("ml.llm.mcp.server.header", (Object[])object));
        object = new Object[]{this.endpoint.getTool().getName()};
        sb.append("<br/>").append(McpBundle.message("ml.llm.mcp.tool.header", (Object[])object));
        sb.append("<p>").append(this.endpoint.getTool().getDescription()).append("</p>");
        if (!this.endpoint.getTool().getProperties().isEmpty()) {
            sb.append("<br/><b>").append(McpBundle.message("ml.llm.mcp.tool.parameters", new Object[0])).append("</b>");
            for (Map.Entry entry : this.endpoint.getTool().getProperties().entrySet()) {
                String type2 = StringsKt.removeSurrounding((String)((McpTool.McpToolProperty)entry.getValue()).getType(), (CharSequence)"\"");
                String description = StringsKt.removeSurrounding((String)((McpTool.McpToolProperty)entry.getValue()).getDescription(), (CharSequence)"\"");
                List<String> list = this.endpoint.getTool().getRequired();
                sb.append("<p>").append("<b>" + entry.getKey() + "</b>: " + type2 + " ").append(!(list != null ? !list.contains(entry.getKey()) : false) ? "<i>(" + McpBundle.message("ml.llm.mcp.tool.parameters.required", new Object[0]) + ")</i>" : "<i>(" + McpBundle.message("ml.llm.mcp.tool.parameters.optional", new Object[0]) + ")</i>").append("<br/>").append(description).append("</p>");
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (DocumentationResult)DocumentationResult.Companion.documentation(string);
    }

    private static final McpToolDocumentationTarget createPointer$lambda$0(McpToolDocumentationTarget this$0, PsiElement it) {
        return this$0;
    }

    private static final McpToolDocumentationTarget createPointer$lambda$1(Function1 $tmp0, Object p0) {
        return (McpToolDocumentationTarget)$tmp0.invoke(p0);
    }
}

