/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.caches;

import com.intellij.ml.llm.nextEdits.context.NextEditContext;
import com.intellij.ml.llm.nextEdits.diffing.Change;
import com.intellij.ml.llm.nextEdits.diffing.Hunk;
import com.intellij.ml.llm.nextEdits.diffing.TextDiff;
import com.intellij.ml.llm.nextEdits.diffing.TextDiffUtils;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/nextEdits/caches/PartialHunkMatcher;", "", "<init>", "()V", "isMatch", "", "before", "", "forFullMatch", "", "Lcom/intellij/ml/llm/nextEdits/diffing/Hunk;", "forPartialMatch", "after", "Lcom/intellij/ml/llm/nextEdits/context/NextEditContext;", "adjustHunkOffsets", "appliedHunks", "hunk", "isPartialMatch", "line", "prefix", "intellij.ml.llm.nextEdits"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPartialHunkMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialHunkMatcher.kt\ncom/intellij/ml/llm/nextEdits/caches/PartialHunkMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,126:1\n1869#2,2:127\n1869#2,2:129\n434#3:131\n507#3,5:132\n*S KotlinDebug\n*F\n+ 1 PartialHunkMatcher.kt\ncom/intellij/ml/llm/nextEdits/caches/PartialHunkMatcher\n*L\n32#1:127,2\n76#1:129,2\n124#1:131\n124#1:132,5\n*E\n"})
public final class PartialHunkMatcher {
    @NotNull
    public static final PartialHunkMatcher INSTANCE = new PartialHunkMatcher();

    private PartialHunkMatcher() {
    }

    public final boolean isMatch(@NotNull String before, @NotNull List<Hunk> forFullMatch, @NotNull Hunk forPartialMatch, @NotNull NextEditContext after) {
        String string;
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter(forFullMatch, (String)"forFullMatch");
        Intrinsics.checkNotNullParameter((Object)forPartialMatch, (String)"forPartialMatch");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        boolean bl = forFullMatch.isEmpty();
        if (bl) {
            string = before;
        } else if (!bl) {
            string = TextDiffUtils.INSTANCE.tryMerge(before, new TextDiff(forFullMatch));
            if (string == null) {
                return false;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String beforePlusFullMatch = string;
        Hunk adjustedHunk = this.adjustHunkOffsets(forFullMatch, forPartialMatch);
        return this.isMatch(beforePlusFullMatch, adjustedHunk, after);
    }

    private final Hunk adjustHunkOffsets(List<Hunk> appliedHunks, Hunk hunk) {
        if (appliedHunks.isEmpty()) {
            return hunk;
        }
        int sourceStart = 0;
        sourceStart = hunk.getSourceStart();
        Iterable $this$forEach$iv = appliedHunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Hunk it = (Hunk)element$iv;
            boolean bl = false;
            if (it.getSourceStart() >= sourceStart) continue;
            sourceStart += it.getTargetLength() - it.getSourceLength();
        }
        return Hunk.copy$default(hunk, sourceStart, 0, hunk.getTargetStart(), 0, null, 26, null);
    }

    private final boolean isMatch(String before, Hunk hunk, NextEditContext after) {
        List beforeLines = StringsKt.lines((CharSequence)before);
        if (hunk.getSourceStart() + hunk.getSourceLength() > beforeLines.size()) {
            return false;
        }
        List afterLines = StringsKt.lines((CharSequence)after.getCurrentFile().getContent());
        if (Intrinsics.areEqual((Object)beforeLines, (Object)afterLines)) {
            return true;
        }
        if (hunk.getTargetStart() + hunk.getTargetLength() > afterLines.size()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)beforeLines, (int)hunk.getSourceStart()), (Object)CollectionsKt.take((Iterable)afterLines, (int)hunk.getTargetStart()))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)CollectionsKt.drop((Iterable)beforeLines, (int)(hunk.getSourceStart() + hunk.getSourceLength())), (Object)CollectionsKt.drop((Iterable)afterLines, (int)(hunk.getTargetStart() + hunk.getTargetLength())))) {
            return false;
        }
        if (Intrinsics.areEqual((Object)TextDiffUtils.INSTANCE.tryMerge(before, new TextDiff(CollectionsKt.listOf((Object)hunk))), (Object)after.getCurrentFile().getContent())) {
            return true;
        }
        int indexInBefore = 0;
        indexInBefore = hunk.getSourceStart();
        int indexInAfter = 0;
        indexInAfter = hunk.getTargetStart();
        Iterable $this$forEach$iv = hunk.getChanges();
        boolean $i$f$forEach = false;
        block5: for (Object element$iv : $this$forEach$iv) {
            Change change = (Change)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[change.getType().ordinal()]) {
                case 1: {
                    if (indexInBefore >= hunk.getSourceStart() + hunk.getSourceLength() || indexInAfter >= hunk.getTargetStart() + hunk.getTargetLength()) {
                        return false;
                    }
                    if (!Intrinsics.areEqual(beforeLines.get(indexInBefore), afterLines.get(indexInAfter))) {
                        return false;
                    }
                    ++indexInBefore;
                    int n = indexInAfter;
                    indexInAfter = n + 1;
                    break;
                }
                case 2: {
                    if (indexInBefore >= hunk.getSourceStart() + hunk.getSourceLength()) continue block5;
                    if (!Intrinsics.areEqual((Object)change.getContent(), beforeLines.get(indexInBefore)) && !INSTANCE.isPartialMatch(change.getContent(), (String)beforeLines.get(indexInBefore))) {
                        return false;
                    }
                    int n = indexInBefore;
                    indexInBefore = n + 1;
                    break;
                }
                case 3: {
                    if (indexInAfter >= hunk.getTargetStart() + hunk.getTargetLength()) continue block5;
                    if (!Intrinsics.areEqual((Object)change.getContent(), afterLines.get(indexInAfter)) && !INSTANCE.isPartialMatch(change.getContent(), (String)afterLines.get(indexInAfter))) {
                        return false;
                    }
                    int n = indexInAfter;
                    indexInAfter = n + 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return true;
    }

    private final boolean isPartialMatch(String line, String prefix) {
        char it;
        char element$iv$iv;
        int index$iv$iv;
        CharSequence $this$filterTo$iv$iv;
        Object[] objectArray = new Character[]{Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('>'), Character.valueOf(' ')};
        Set symbolsToIgnore = SetsKt.setOf((Object[])objectArray);
        String $this$filter$iv = line;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!symbolsToIgnore.contains(Character.valueOf(it)))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        $this$filter$iv = prefix;
        String string = ((StringBuilder)destination$iv$iv).toString();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new StringBuilder();
        $i$f$filterTo = false;
        n = $this$filterTo$iv$iv.length();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!symbolsToIgnore.contains(Character.valueOf(it)))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return StringsKt.startsWith$default((String)string, (String)((StringBuilder)destination$iv$iv).toString(), (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Change.Type.values().length];
            try {
                nArray[Change.Type.Context.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.Deletion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.Addition.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

