/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.listeners;

import com.intellij.ml.llm.nextEdits.context.NextEditFilePath;
import com.intellij.ml.llm.nextEdits.history.NextEditRecentFileChangesProvider;
import com.intellij.ml.llm.nextEdits.services.NextEditRequestService;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettingsControllerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/nextEdits/listeners/NextEditDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "Lcom/intellij/ml/llm/nextEdits/context/NextEditFilePath;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/nextEdits/context/NextEditFilePath;)V", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "recentChangesProvider", "Lcom/intellij/ml/llm/nextEdits/history/NextEditRecentFileChangesProvider;", "getRecentChangesProvider", "()Lcom/intellij/ml/llm/nextEdits/history/NextEditRecentFileChangesProvider;", "isEnabled", "", "intellij.ml.llm.nextEdits"})
public final class NextEditDocumentListener
implements DocumentListener {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final NextEditFilePath filePath;

    public NextEditDocumentListener(@NotNull Editor editor2, @NotNull Project project2, @NotNull NextEditFilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.editor = editor2;
        this.project = project2;
        this.filePath = filePath;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled() || !(event.getDocument() instanceof DocumentImpl)) {
            return;
        }
        NextEditSessionManager nextEditSessionManager = NextEditSessionManager.Companion.getInstance(this.editor);
        if (nextEditSessionManager != null) {
            nextEditSessionManager.onDocumentEvent(event);
        }
        NextEditRequestService.Companion.getInstance(this.project).cancelRequests();
        NextEditRecentFileChangesProvider nextEditRecentFileChangesProvider = this.getRecentChangesProvider();
        Document document2 = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        nextEditRecentFileChangesProvider.initializeFileIfNeeded(this.filePath, document2);
        this.getRecentChangesProvider().recordDocumentEvent(this.filePath, event);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled() || !(event.getDocument() instanceof DocumentImpl)) {
            return;
        }
        this.getRecentChangesProvider().modificationStampUpdated(this.filePath, event.getDocument().getModificationStamp());
    }

    private final NextEditRecentFileChangesProvider getRecentChangesProvider() {
        return NextEditRecentFileChangesProvider.Companion.getInstance(this.project);
    }

    private final boolean isEnabled() {
        return NextEditSettingsControllerKt.getNextEditEnabled();
    }
}

