/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.session;

import com.intellij.ml.llm.nextEdits.session.guarder.SuppressSessionGuardPurpose;
import com.intellij.ml.llm.nextEdits.settings.NextEditPreviewMode;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayIntrusionMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditIntrusionModeController;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "previewMode", "Lcom/intellij/ml/llm/nextEdits/settings/NextEditPreviewMode;", "initialCaretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/nextEdits/settings/NextEditPreviewMode;Lcom/intellij/openapi/editor/LogicalPosition;)V", "currentIntrusionMode", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayIntrusionMode;", "getIntrusionMode", "sessionSuppressed", "", "purpose", "Lcom/intellij/ml/llm/nextEdits/session/guarder/SuppressSessionGuardPurpose;", "sessionUnsuppressed", "stepAccepted", "jumpAccepted", "beforeNewViewShown", "editRange", "Lcom/intellij/openapi/util/TextRange;", "caretMoved", "", "limitMaximalIntrusion", "maximal", "classifyCurrentCaretLocation", "Lcom/intellij/ml/llm/nextEdits/session/NextEditIntrusionModeController$CaretLocation;", "CaretLocation", "Companion", "intellij.ml.llm.nextEdits"})
public final class NextEditIntrusionModeController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final NextEditPreviewMode previewMode;
    @NotNull
    private final LogicalPosition initialCaretPosition;
    @NotNull
    private NextEditDisplayIntrusionMode currentIntrusionMode;
    private static final int LINES_NUMBER_THRESHOLD = 2;

    private NextEditIntrusionModeController(Editor editor2, NextEditPreviewMode previewMode, LogicalPosition initialCaretPosition) {
        this.editor = editor2;
        this.previewMode = previewMode;
        this.initialCaretPosition = initialCaretPosition;
        this.currentIntrusionMode = switch (WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 1 -> NextEditDisplayIntrusionMode.STEP;
            case 2 -> NextEditDisplayIntrusionMode.NON_INTRUSIVE_STEP_OR_JUMP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final NextEditDisplayIntrusionMode getIntrusionMode() {
        return this.currentIntrusionMode;
    }

    public final void sessionSuppressed(@NotNull SuppressSessionGuardPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
    }

    public final void sessionUnsuppressed(@NotNull SuppressSessionGuardPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        switch (WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 2: {
                if (!purpose.getRequiresNonIntrusiveDisplay()) break;
                this.limitMaximalIntrusion(NextEditDisplayIntrusionMode.JUMP);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void stepAccepted() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 2: {
                this.currentIntrusionMode = NextEditDisplayIntrusionMode.STEP;
                break;
            }
            case 1: {
                this.currentIntrusionMode = NextEditDisplayIntrusionMode.STEP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void jumpAccepted() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 2: {
                this.currentIntrusionMode = NextEditDisplayIntrusionMode.STEP;
                break;
            }
            case 1: {
                this.currentIntrusionMode = NextEditDisplayIntrusionMode.STEP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void beforeNewViewShown(@NotNull TextRange editRange) {
        Intrinsics.checkNotNullParameter((Object)editRange, (String)"editRange");
        CaretLocation caretLocation = this.classifyCurrentCaretLocation(editRange);
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 2: {
                switch (WhenMappings.$EnumSwitchMapping$1[caretLocation.ordinal()]) {
                    case 1: {
                        this.limitMaximalIntrusion(NextEditDisplayIntrusionMode.STEP);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.limitMaximalIntrusion(NextEditDisplayIntrusionMode.JUMP);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 1: {
                this.currentIntrusionMode = switch (WhenMappings.$EnumSwitchMapping$1[caretLocation.ordinal()]) {
                    case 1 -> NextEditDisplayIntrusionMode.STEP;
                    case 2 -> NextEditDisplayIntrusionMode.STEP;
                    case 3 -> NextEditDisplayIntrusionMode.JUMP;
                    default -> throw new NoWhenBranchMatchedException();
                };
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean caretMoved(@NotNull TextRange editRange) {
        Intrinsics.checkNotNullParameter((Object)editRange, (String)"editRange");
        switch (WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 2: {
                LogicalPosition logicalPosition = this.editor.getCaretModel().getLogicalPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                LogicalPosition currentCaretPosition = logicalPosition;
                if (!editRange.contains(this.editor.getCaretModel().getOffset()) && currentCaretPosition.line != this.initialCaretPosition.line) {
                    return false;
                }
                this.limitMaximalIntrusion(NextEditDisplayIntrusionMode.JUMP);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return true;
    }

    private final void limitMaximalIntrusion(NextEditDisplayIntrusionMode maximal) {
        this.currentIntrusionMode = NextEditDisplayIntrusionMode.Companion.min(this.currentIntrusionMode, maximal);
    }

    private final CaretLocation classifyCurrentCaretLocation(TextRange editRange) {
        if (editRange.containsOffset(this.editor.getCaretModel().getOffset())) {
            return CaretLocation.WITHIN_EDIT_RANGE;
        }
        int currentLine = this.editor.getDocument().getLineNumber(this.editor.getCaretModel().getOffset());
        int editStartLine = this.editor.getDocument().getLineNumber(editRange.getStartOffset());
        int editEndLine = this.editor.getDocument().getLineNumber(Math.max(editRange.getEndOffset() - 1, editRange.getStartOffset()));
        if (Math.min(Math.abs(currentLine - editStartLine), Math.abs(currentLine - editEndLine)) <= 2) {
            return CaretLocation.NEAR_EDIT_RANGE;
        }
        return CaretLocation.FAR_FROM_EDIT_RANGE;
    }

    public /* synthetic */ NextEditIntrusionModeController(Editor editor2, NextEditPreviewMode previewMode, LogicalPosition initialCaretPosition, DefaultConstructorMarker $constructor_marker) {
        this(editor2, previewMode, initialCaretPosition);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditIntrusionModeController$CaretLocation;", "", "<init>", "(Ljava/lang/String;I)V", "WITHIN_EDIT_RANGE", "NEAR_EDIT_RANGE", "FAR_FROM_EDIT_RANGE", "intellij.ml.llm.nextEdits"})
    private static final class CaretLocation
    extends Enum<CaretLocation> {
        public static final /* enum */ CaretLocation WITHIN_EDIT_RANGE = new CaretLocation();
        public static final /* enum */ CaretLocation NEAR_EDIT_RANGE = new CaretLocation();
        public static final /* enum */ CaretLocation FAR_FROM_EDIT_RANGE = new CaretLocation();
        private static final /* synthetic */ CaretLocation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CaretLocation[] values() {
            return (CaretLocation[])$VALUES.clone();
        }

        public static CaretLocation valueOf(String value2) {
            return Enum.valueOf(CaretLocation.class, value2);
        }

        @NotNull
        public static EnumEntries<CaretLocation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = caretLocationArray = new CaretLocation[]{CaretLocation.WITHIN_EDIT_RANGE, CaretLocation.NEAR_EDIT_RANGE, CaretLocation.FAR_FROM_EDIT_RANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditIntrusionModeController$Companion;", "", "<init>", "()V", "LINES_NUMBER_THRESHOLD", "", "of", "Lcom/intellij/ml/llm/nextEdits/session/NextEditIntrusionModeController;", "editor", "Lcom/intellij/openapi/editor/Editor;", "previewMode", "Lcom/intellij/ml/llm/nextEdits/settings/NextEditPreviewMode;", "intellij.ml.llm.nextEdits"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @NotNull
        public final NextEditIntrusionModeController of(@NotNull Editor editor2, @NotNull NextEditPreviewMode previewMode) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)previewMode), (String)"previewMode");
            ThreadingAssertions.assertReadAccess();
            LogicalPosition logicalPosition = editor2.getCaretModel().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            LogicalPosition initialCaretPosition = logicalPosition;
            return new NextEditIntrusionModeController(editor2, previewMode, initialCaretPosition, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NextEditPreviewMode.values().length];
            try {
                nArray[NextEditPreviewMode.Instant.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditPreviewMode.ConfirmationBased.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CaretLocation.values().length];
            try {
                nArray[CaretLocation.WITHIN_EDIT_RANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretLocation.NEAR_EDIT_RANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretLocation.FAR_FROM_EDIT_RANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

