/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.ui.inlay;

import com.intellij.codeInsight.inline.hint.InlineShortcutHintRendererBase;
import com.intellij.ml.llm.nextEdits.NextEditsBundle;
import com.intellij.ml.llm.nextEdits.ui.NextEditColors;
import com.intellij.ml.llm.nextEdits.ui.NextEditShortcuts;
import com.intellij.ml.llm.nextEdits.ui.inlay.NextEditShortcutHint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Disposer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a*\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a(\u0010\u0000\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a*\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u0017\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"renderShortcutHint", "", "Lcom/intellij/openapi/editor/Inlay;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "hint", "Lcom/intellij/ml/llm/nextEdits/ui/inlay/NextEditShortcutHint;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "doRenderShortcutHint", "getShortcutRenderer", "Lcom/intellij/codeInsight/inline/hint/InlineShortcutHintRendererBase;", "shortcut", "", "getTextRenderer", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "text", "getShortcutRepresentation", "actionId", "disposeWith", "parentDisposable", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditInlineShortcutInlays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditInlineShortcutInlays.kt\ncom/intellij/ml/llm/nextEdits/ui/inlay/NextEditInlineShortcutInlaysKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1869#2,2:109\n*S KotlinDebug\n*F\n+ 1 NextEditInlineShortcutInlays.kt\ncom/intellij/ml/llm/nextEdits/ui/inlay/NextEditInlineShortcutInlaysKt\n*L\n104#1:109,2\n*E\n"})
public final class NextEditInlineShortcutInlaysKt {
    @NotNull
    public static final List<Inlay<?>> renderShortcutHint(@NotNull Editor editor2, int offset, @NotNull NextEditShortcutHint hint) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        return NextEditInlineShortcutInlaysKt.doRenderShortcutHint(editor2, offset, hint);
    }

    public static final void renderShortcutHint(@NotNull Editor editor2, int offset, @NotNull NextEditShortcutHint hint, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        List<Inlay<?>> inlays = NextEditInlineShortcutInlaysKt.renderShortcutHint(editor2, offset, hint);
        NextEditInlineShortcutInlaysKt.disposeWith(inlays, disposable);
    }

    private static final List<Inlay<?>> doRenderShortcutHint(Editor editor2, int offset, NextEditShortcutHint hint) {
        String string;
        String actionId = Intrinsics.areEqual((Object)hint, (Object)NextEditShortcutHint.Complete.INSTANCE) ? "InsertInlineCompletionAction" : "InsertNextEditAction";
        NextEditShortcutHint nextEditShortcutHint = hint;
        if (Intrinsics.areEqual((Object)nextEditShortcutHint, (Object)NextEditShortcutHint.Complete.INSTANCE)) {
            string = NextEditsBundle.message("next.edit.inline.shortcut.apply.completion.hint.text", new Object[0]);
        } else if (Intrinsics.areEqual((Object)nextEditShortcutHint, (Object)NextEditShortcutHint.Insert.INSTANCE)) {
            string = NextEditsBundle.message("next.edit.inline.shortcut.apply.insertion.hint.text", new Object[0]);
        } else if (Intrinsics.areEqual((Object)nextEditShortcutHint, (Object)NextEditShortcutHint.Remove.INSTANCE)) {
            string = NextEditsBundle.message("next.edit.inline.shortcut.apply.removal.hint.text", new Object[0]);
        } else if (Intrinsics.areEqual((Object)nextEditShortcutHint, (Object)NextEditShortcutHint.Replace.INSTANCE)) {
            string = NextEditsBundle.message("next.edit.inline.shortcut.apply.replacement.hint.text", new Object[0]);
        } else if (Intrinsics.areEqual((Object)nextEditShortcutHint, (Object)NextEditShortcutHint.Review.INSTANCE)) {
            string = NextEditsBundle.message("next.edit.inline.shortcut.review.hint.text", new Object[0]);
        } else if (Intrinsics.areEqual((Object)nextEditShortcutHint, (Object)NextEditShortcutHint.Jump.INSTANCE)) {
            string = NextEditsBundle.message("next.edit.inline.shortcut.jump.hint.text", new Object[0]);
        } else if (nextEditShortcutHint instanceof NextEditShortcutHint.Action) {
            string = ((NextEditShortcutHint.Action)hint).getShortcutHintText();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String text2 = string;
        if (!(editor2 instanceof EditorImpl)) {
            return CollectionsKt.emptyList();
        }
        String string2 = NextEditInlineShortcutInlaysKt.getShortcutRepresentation(actionId);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String shortcut = string2;
        InlineShortcutHintRendererBase shortcutRenderer = NextEditInlineShortcutInlaysKt.getShortcutRenderer(shortcut);
        InlineShortcutHintRendererBase textRenderer = NextEditInlineShortcutInlaysKt.getTextRenderer((EditorImpl)editor2, text2);
        Object[] objectArray = new Inlay[]{((EditorImpl)editor2).getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)shortcutRenderer), ((EditorImpl)editor2).getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)textRenderer)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final InlineShortcutHintRendererBase getShortcutRenderer(String shortcut) {
        return new InlineShortcutHintRendererBase(shortcut){

            protected boolean isEnabled(Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                return true;
            }

            protected TextAttributes getTextAttributes(Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                TextAttributes textAttributes = super.getTextAttributes(editor2);
                if (textAttributes == null || (textAttributes = textAttributes.clone()) == null) {
                    return null;
                }
                TextAttributes base = textAttributes;
                Color backgroundColor = editor2.getColorsScheme().getColor(NextEditColors.INSTANCE.getREVIEW_HINT_BACKGROUND());
                base.setBackgroundColor(backgroundColor);
                return base;
            }

            protected void paintIfEnabled(Inlay<?> inlay, Graphics g, Rectangle r, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                this.paintHint(inlay, g, r, this.clearEffects(textAttributes));
            }
        };
    }

    private static final InlineShortcutHintRendererBase getTextRenderer(EditorImpl editor2, String text2) {
        return new InlineShortcutHintRendererBase(text2, editor2){
            final /* synthetic */ String $text;
            final /* synthetic */ EditorImpl $editor;
            {
                this.$text = $text;
                this.$editor = $editor;
                super($text);
            }

            protected boolean isEnabled(Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                return true;
            }

            protected void paintIfEnabled(Inlay<?> inlay, Graphics g, Rectangle r, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                InlineShortcutHintRendererBase.paintLabel$default((InlineShortcutHintRendererBase)this, (Graphics)g, (EditorImpl)this.$editor, (Rectangle)r, (String)this.$text, (TextAttributes)this.clearEffects(textAttributes), null, (int)32, null);
            }
        };
    }

    private static final String getShortcutRepresentation(String actionId) {
        return NextEditShortcuts.INSTANCE.getPrettyRepresentation(actionId);
    }

    private static final void disposeWith(List<? extends Disposable> $this$disposeWith, Disposable parentDisposable) {
        if (!((Collection)$this$disposeWith).isEmpty()) {
            DisposerUtilKt.whenDisposed((Disposable)parentDisposable, () -> NextEditInlineShortcutInlaysKt.disposeWith$lambda$1($this$disposeWith));
        }
    }

    private static final Unit disposeWith$lambda$1(List $this_disposeWith) {
        Iterable $this$forEach$iv = $this_disposeWith;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable it = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        return Unit.INSTANCE;
    }
}

