/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.aiignore;

import com.intellij.ml.llm.privacy.aiignore.AiIgnoreManagerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0007H\u0007J\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/AiIgnoreUxHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "canCreateNewFile", "", "createNewFile", "", "canOpenExistingFile", "openExistingFile", "openFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.ml.llm.privacy"})
public final class AiIgnoreUxHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public AiIgnoreUxHelper(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @RequiresReadLock
    public final boolean canCreateNewFile() {
        AiIgnoreManagerSettings aiIgnoreManager = AiIgnoreManagerSettings.Companion.getInstance(this.project);
        if (aiIgnoreManager.getAiIgnoreFromSettings() != null) {
            return false;
        }
        return ProjectUtil.guessProjectDir((Project)this.project) != null;
    }

    public final void createNewFile() {
        if (!this.canCreateNewFile()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> AiIgnoreUxHelper.createNewFile$lambda$0(this));
    }

    @RequiresReadLock
    public final boolean canOpenExistingFile() {
        return AiIgnoreManagerSettings.Companion.getInstance(this.project).getAiIgnoreFromSettings() != null;
    }

    public final void openExistingFile() {
        VirtualFile file = AiIgnoreManagerSettings.Companion.getInstance(this.project).getAiIgnoreFromSettings();
        if (file != null) {
            this.openFile(file);
        }
    }

    private final void openFile(VirtualFile file) {
        FileEditorManager.getInstance((Project)this.project).openTextEditor(new OpenFileDescriptor(this.project, file, 0), true);
    }

    private static final void createNewFile$lambda$0(AiIgnoreUxHelper this$0) {
        VirtualFile file;
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)this$0.project);
        VirtualFile virtualFile3 = file = virtualFile2 != null ? virtualFile2.createChildData((Object)this$0.project, ".aiignore") : null;
        if (file != null) {
            VirtualFileUtil.writeText((VirtualFile)file, (String)"# An .aiignore file follows the same syntax as a .gitignore file.\n# .gitignore documentation: https://git-scm.com/docs/gitignore\n\n# you can ignore files\n.DS_Store\n*.log\n*.tmp\n\n# or folders\ndist/\nbuild/\nout/\n");
            this$0.openFile(file);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/AiIgnoreUxHelper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/privacy/aiignore/AiIgnoreUxHelper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.privacy"})
    @SourceDebugExtension(value={"SMAP\nAiIgnoreUxHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiIgnoreUxHelper.kt\ncom/intellij/ml/llm/privacy/aiignore/AiIgnoreUxHelper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n30#2,2:74\n*S KotlinDebug\n*F\n+ 1 AiIgnoreUxHelper.kt\ncom/intellij/ml/llm/privacy/aiignore/AiIgnoreUxHelper$Companion\n*L\n17#1:74,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AiIgnoreUxHelper getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<AiIgnoreUxHelper> serviceClass$iv = AiIgnoreUxHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AiIgnoreUxHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

