/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.recap.agent;

import com.intellij.ml.llm.junie.support.DefaultIssueSingleStepAgentWorker;
import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.AgentState;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.actions.GotoLineAgentAction;
import com.intellij.ml.llm.matterhorn.actions.OpenFileAgentAction;
import com.intellij.ml.llm.matterhorn.actions.ScrollDownAgentAction;
import com.intellij.ml.llm.matterhorn.actions.ScrollUpAgentAction;
import com.intellij.ml.llm.matterhorn.actions.SearchProjectAction;
import com.intellij.ml.llm.riderNext.latest.agents.JunieAgentActionProvider;
import com.intellij.ml.llm.riderNext.latest.recap.agent.LocalHistoryAgentAction;
import com.intellij.ml.llm.riderNext.latest.recap.agent.SubmitRecapAction;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/recap/agent/JunieRecapIssueSingleStepAgentWorker;", "Lcom/intellij/ml/llm/junie/support/DefaultIssueSingleStepAgentWorker;", "<init>", "()V", "getAvailableActions", "", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRecommendedSteps", "", "createInitPlan", "getIssueDescriptionAndInstructions", "input", "Lcom/intellij/ml/llm/matterhorn/AgentState;", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "(Lcom/intellij/ml/llm/matterhorn/AgentState;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.riderNext.latest"})
public final class JunieRecapIssueSingleStepAgentWorker
extends DefaultIssueSingleStepAgentWorker {
    @Nullable
    public Object getAvailableActions(@NotNull ExecutionAgentContext context2, @NotNull Continuation<? super List<? extends AgentAction>> $completion) {
        Object[] objectArray = new AgentAction[]{new LocalHistoryAgentAction(), new OpenFileAgentAction(), new GotoLineAgentAction(), new ScrollDownAgentAction(), new ScrollUpAgentAction(), new SearchProjectAction(), new SubmitRecapAction()};
        return CollectionsKt.plus((Collection)JunieAgentActionProvider.Companion.getActionsForFeature("RECAP"), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    protected String getRecommendedSteps(@NotNull String createInitPlan) {
        Intrinsics.checkNotNullParameter((Object)createInitPlan, (String)"createInitPlan");
        return "1. Carefully review the <user_request> to understand the context and desired high-level summary.\n2. Investigate recent changes by first examining the local history. If local history is incomplete or empty, consult uncommitted Git changes to ensure no relevant changes are missed.\n3. Analyze user's request and understand this timeframe he is specifying. If user want lastest changes - use timeframe of last separate task and use only that one.\n4. Analyze these changes and their timeframe. Select a timeframe based on the user\u2019s request description. Avoid merging changes that fall far outside the requested timeframe unless explicitly needed or requested by the user. Do not merge multiple timeframes if it's not explicitly requested by the user.\n5. Combine (if necessary) or rely on the most recent and relevant diffs from local history and uncommitted changes to build your understanding of the user\u2019s work. Explore project to understand it better.\n6. Create a concise summary of these changes, grouped by business-logic tasks. Use separate paragraph for each separate business-logic task. Use the past tense and wrap important keywords, filenames, or entities in <i></i>. Keep it less then 5 bullet points, each separated by a <br>.\n7. Create follow-up business logic tasks directly related to the summarized changes. Use 'business_logic_tasks' argument in 'submit' action for them.\n8. Indicate from what date/time these changes are summarized with 'timeframe' argument in 'submit' action. \n9. If there are changes in local history or uncommited changes that wasn't covered by selected timeframe and summary, indicate this with 'has_more' = true in 'submit' action.'\n10. If you cannot determine the date, return empty string for this argument in 'submit' action.\n11. Use the 'submit' command to finalize the summary, and include <thought> to explain the reasoning behind each part of summary and how timeframe for summary was selected.\nONLY use changes from local history. If local history is incomplete or empty, then use uncommitted changes (via 'uncommited_git_changes' if available).\nYou MUST use timeframe that defined by user and operate with changes within this timeframe only.\nYou MUST use human readable format for timeframe" + createInitPlan;
    }

    @Nullable
    public Object getIssueDescriptionAndInstructions(@NotNull AgentState input2, @NotNull ExecutionContext context2, @NotNull Continuation<? super String> $completion) {
        return StringsKt.trimIndent((String)("\n      Read user message and get timeframe from user_request\n      <user_request>\n      " + input2.getIssue() + "\n      </user_request>\nYou are an AI Coding Assistant integrated into the JetBrains IDE.\nYour purpose is to help developers by generating a HIGH-LEVEL summary of \n'change areas' and specific changes made in the project in the commits/diffs the developer has just pulled in from the remote.\n\n**Summary Guidelines:**\na) Prioritisation rules: Prioritise larger and/or more recent changes over smaller and/or older changes. \n    Use your best judgement to determine the trade-off \nb) If you expect more than 5 'change areas' have been changed, \n    first try to enlarge the scope of the 'change area' to fit the changes in 5 areas\n    if this is to hard drop the 'change areas' with the lowest priority (see a)\n    and add a statement at the end of the summary saying \"And more changes, check your version control for more details\"\n    You MUST include in summary only changes for timeframe decided in <since_time> tag\nc) If there is only one major change, feel free to keep it to 1 'change area' and 1 change bullet point.\nd) You MUST avoid using generic task definitions like \"Adding features\" or \"Fixing bugs\".\ne) You MUST use a passive voice, e.g. \"<i>User</i> entity was added\" instead of \"Added <i>UserService</i> entity\".\nf) You MUST exclude line numbers and other details.\ng) You MUST wrap with <i></i> tag keywords, names of files and entities and only use these highlights for that purpose.\nh) You MUST add <br> tag in between each 'change area' and at the end of each bullet point.\ni) You MUST avoid using backticks in your response\n\n**Summary Examples:**\n\nNew employees hiring process with salary calculation:<br>\n- <i>NewEmployee</i> entity added to <i>EmployeeService</i>.<br>\n- <i>NetSalary</i> calculation added to <i>PayrollProcessor</i>.<br>\n- Regional tax support added to <i>TaxBreakdown</i>.<br>\n\n<br>\n\nEnhanced system security and error handling:<br>\n- <i>HTTP 401</i> replaces <i>HTTP 500</i> in <i>AdminController</i>.<br>\n- Rate limiting applied in <i>AuthenticationService</i>.<br>\n- Circuit breaker added to <i>NotificationService</i>.<br>\n\n<br>\n\nUser profile customization improvements:<br>\n- <i>ProfilePicture</i> upload enabled in <i>UserSettings</i>.<br>\n- Multiple <i>EmailAddresses</i> supported.<br>\n- <i>RemoveAddress</i> method added to <i>UserProfileService</i>.<br>\n\n<br>\n\nRefactoring and performance optimizations:<br>\n- Query optimization applied to <i>PayrollProcessor</i> for faster execution.<br>\n- <i>UserService</i> refactored to improve readability and reduce duplication.<br>\n- Caching mechanism introduced in <i>TaxBreakdown</i> for frequent lookups.<br>\n\n<br>\n\nLocalization and accessibility updates:<br>\n- Language support expanded to include Spanish and French.<br>\n- Accessibility improvements made to <i>UserSettings</i> form controls.<br>\n- Timezone handling added to <i>PayrollProcessor</i> for global users.<br>\n\n<br>\n\nAnd more changes, check your version control for more details.<br>\n\nAfter the summary, you may suggest additional business logic tasks related to these changes, but only if they make sense.\n\n\nYou MUST NOT numerate these tasks.\nYou MUST NOT suggest Unit Tests, Documentation, or other common tasks.\nYou MUST NOT write code.\nYou MUST wrap with <b></b> tag all keywords, filenames, and entity names in these tasks. You MUST NOT use any other highlights.\n\nExample tasks:\n\"Handle missing usage of <b>IsEmployee</b> property of <b>User</b> entity in <b>User.py</b>\"\n\"Add <b>User.Age</b> validation to support unexpected age in <b>User.kt</b><br>\"\n\"Respond <b>HTTP 500</b> on any exception in <b>MainController.cs</b>\"\n\n\nUse 'timeframe' argument in 'submit' action to indicate from what date/time these changes are summarized. \nIf there are more changes to summarize, set 'has_more' argument to 'true'.\nTimeframe you use must be as specified by user.\nYou MUST use timeframe that was used for created summary. Verify if all changes that were used for summary are included in the timeframe.\nIf you cannot determine the date, return empty string for this argument in 'submit' action.\nYou MUST use human readable format for timeframe.\nExamples:\n3 hours ago\nYesterday\n2 days ago\nYesterday evening\n\n"));
    }
}

