/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.recap.lvcs;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.ml.llm.riderNext.latest.recap.lvcs.RecapLVCSChange;
import com.intellij.ml.llm.riderNext.latest.recap.lvcs.RecapLVCSChunk;
import com.intellij.ml.llm.riderNext.latest.recap.lvcs.RecapLVCSTimestamp;
import com.intellij.ml.llm.riderNext.latest.recap.vcs.RecapLatestCommits;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u001a \u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0005H\u0002\u001a&\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0014j\u0002`\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a*\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0002\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"getChangesDiffs", "Ljava/util/ArrayList;", "Lcom/intellij/ml/llm/riderNext/latest/recap/lvcs/RecapLVCSChunk;", "Lkotlin/collections/ArrayList;", "changesNewToLatest", "", "Lcom/intellij/ml/llm/riderNext/latest/recap/lvcs/RecapLVCSChange;", "localHistoryImpl", "Lcom/intellij/history/integration/LocalHistoryImpl;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "latestCommits", "Lcom/intellij/ml/llm/riderNext/latest/recap/vcs/RecapLatestCommits;", "isChangeEarlierThanCommit", "", "change", "chunksAreEmpty", "CONTEXT_LINES", "", "getDiff", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "it", "getUnifiedDiff", "", "hunks", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "writeLine", "", "writer", "line", "prefix", "", "findEntry", "Lcom/intellij/history/core/tree/Entry;", "rootEntry", "Lcom/intellij/history/core/tree/RootEntry;", "Lcom/intellij/history/core/changes/Change;", "isBefore", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "intellij.ml.llm.riderNext.latest"})
public final class RecapLVCSDiffKt {
    private static final int CONTEXT_LINES = 20;

    private static final ArrayList<RecapLVCSChunk> getChangesDiffs(List<RecapLVCSChange> changesNewToLatest, LocalHistoryImpl localHistoryImpl, Tokenizer tokenizer, RecapLatestCommits latestCommits) {
        ArrayList<RecapLVCSChunk> chunks = new ArrayList<RecapLVCSChunk>();
        int currentLength = 0;
        for (RecapLVCSChange change : changesNewToLatest) {
            String str;
            StringBuilder chunk;
            if (Intrinsics.areEqual((Object)change.getChangeName(), (Object)"External change")) continue;
            String string = change.getChangeName();
            if ((string != null ? StringsKt.startsWith$default((String)string, (String)"Commit changes:", (boolean)false, (int)2, null) : false) || (chunk = RecapLVCSDiffKt.getDiff(change, localHistoryImpl)) == null) continue;
            if (latestCommits != null && RecapLVCSDiffKt.isChangeEarlierThanCommit(latestCommits, change, chunks.isEmpty())) break;
            Intrinsics.checkNotNullExpressionValue((Object)chunk.toString(), (String)"toString(...)");
            int chunkLength = tokenizer.count(str);
            if (currentLength + chunkLength > 16000) break;
            chunks.add(new RecapLVCSChunk(str, new RecapLVCSTimestamp(change.getTimestamp())));
            currentLength += chunkLength;
        }
        return chunks;
    }

    private static final boolean isChangeEarlierThanCommit(RecapLatestCommits latestCommits, RecapLVCSChange change, boolean chunksAreEmpty) {
        if (latestCommits.getNoChangesAfterLatestCommit()) {
            if (latestCommits.getBeforeLatestCommit() == null) {
                return false;
            }
            if (change.getTimestamp() < latestCommits.getBeforeLatestCommit().getTimestamp()) {
                return !chunksAreEmpty;
            }
            return false;
        }
        if (change.getTimestamp() < latestCommits.getLatestCommit().getTimestamp()) {
            if (chunksAreEmpty) {
                latestCommits.setNoChangesAfterLatestCommit(true);
                return false;
            }
            return true;
        }
        return false;
    }

    private static final StringBuilder getDiff(RecapLVCSChange it, LocalHistoryImpl localHistoryImpl) {
        LocalHistoryFacade localHistoryFacade = localHistoryImpl.getFacade();
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        LocalHistoryFacade facade = localHistoryFacade;
        Entry before = RecapLVCSDiffKt.findEntry(it.getRoot(), it.getChangeBefore(), true, facade);
        Entry after = RecapLVCSDiffKt.findEntry(it.getRoot(), it.getChangeAfter(), false, facade);
        List diff2 = Entry.getDifferencesBetween((Entry)before, (Entry)after);
        StringBuilder chunkBuilder = new StringBuilder();
        chunkBuilder.append("===================================================================").append('\n');
        if (it.getChangeName() != null) {
            chunkBuilder.append(it.getChangeName()).append('\n');
        } else {
            for (String fileName : (List)it.getRevisionAfter().getAffectedFileNames().first) {
                chunkBuilder.append("Changed file " + fileName).append('\n');
            }
        }
        boolean hasBody = false;
        for (Difference d : diff2) {
            List hunks;
            ContentRevision beforeContentRevision = d.getLeftContentRevision(localHistoryImpl.getGateway());
            ContentRevision afterContentRevision = d.getRightContentRevision(localHistoryImpl.getGateway());
            if (beforeContentRevision == null || afterContentRevision == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)TextPatchBuilder.buildPatchHunks((String)String.valueOf(beforeContentRevision.getContent()), (String)String.valueOf(afterContentRevision.getContent()), (int)20), (String)"buildPatchHunks(...)");
            String fileDiff = RecapLVCSDiffKt.getUnifiedDiff(hunks);
            chunkBuilder.append(fileDiff).append('\n');
            if (!(((CharSequence)fileDiff).length() > 0)) continue;
            hasBody = true;
        }
        if (!hasBody) {
            return null;
        }
        chunkBuilder.append("===================================================================").append('\n');
        return chunkBuilder;
    }

    private static final String getUnifiedDiff(List<? extends PatchHunk> hunks) {
        StringBuilder writer = new StringBuilder();
        for (PatchHunk patchHunk : hunks) {
            if (patchHunk == null) continue;
            writer.append(System.lineSeparator());
            for (PatchLine line : patchHunk.getLines()) {
                String text2;
                char prefixChar = switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                    case 1 -> ' ';
                    case 2 -> '+';
                    case 3 -> '-';
                    default -> throw new NoWhenBranchMatchedException();
                };
                Intrinsics.checkNotNullExpressionValue((Object)line.getText(), (String)"getText(...)");
                RecapLVCSDiffKt.writeLine(writer, text2, prefixChar);
                writer.append(System.lineSeparator());
            }
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void writeLine(StringBuilder writer, String line, char prefix) {
        CharSequence charSequence = line;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)line, (Object)"null")) {
            return;
        }
        if (StringsKt.startsWith$default((String)line, (String)"@@", (boolean)false, (int)2, null)) {
            return;
        }
        writer.append(prefix);
        writer.append(line);
    }

    private static final Entry findEntry(RootEntry rootEntry, Change change, boolean isBefore, LocalHistoryFacade facade) {
        RootEntry rootEntry2 = rootEntry.copy();
        Intrinsics.checkNotNullExpressionValue((Object)rootEntry2, (String)"copy(...)");
        RootEntry rootCopy = rootEntry2;
        String path = facade.revertUpToChange(rootCopy, change.getId(), "", isBefore, false);
        return rootCopy.findEntry(path);
    }

    public static final /* synthetic */ ArrayList access$getChangesDiffs(List changesNewToLatest, LocalHistoryImpl localHistoryImpl, Tokenizer tokenizer, RecapLatestCommits latestCommits) {
        return RecapLVCSDiffKt.getChangesDiffs(changesNewToLatest, localHistoryImpl, tokenizer, latestCommits);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PatchLine.Type.values().length];
            try {
                nArray[PatchLine.Type.CONTEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatchLine.Type.ADD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatchLine.Type.REMOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

