/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.ui.common;

import com.intellij.ml.llm.core.ui.XNextThemeHelper;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/ui/common/HighlightedLabel;", "Ljavax/swing/JLabel;", "text", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "intellij.ml.llm.riderNext.latest"})
final class HighlightedLabel
extends JLabel {
    public HighlightedLabel(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        int xStart;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        FontMetrics fontMetrics = g2d.getFontMetrics(this.getFont());
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics fm = fontMetrics;
        String string = this.getText();
        if (string == null) {
            return;
        }
        String fullText = string;
        String[] stringArray = new String[]{"AI Power"};
        List parts = StringsKt.split$default((CharSequence)fullText, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        int xCurrent = xStart = (this.getWidth() - fm.stringWidth(fullText)) / 2;
        g2d.setColor(this.getForeground());
        g2d.drawString((String)parts.get(0), xCurrent, fm.getAscent());
        Rectangle accentedRect = new Rectangle(xCurrent += fm.stringWidth((String)parts.get(0)), 0, fm.stringWidth("AI Power"), this.getHeight());
        Paint highlightColor = XNextThemeHelper.getButtonAiXNextDoubleColorBackground().getGradientPaint(accentedRect);
        g2d.setPaint(highlightColor);
        if (parts.size() > 1) {
            g2d.drawString("AI Power", xCurrent, fm.getAscent());
            g2d.setColor(this.getForeground());
            g2d.drawString((String)parts.get(1), xCurrent += fm.stringWidth("AI Power"), fm.getAscent());
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics fm = fontMetrics;
        return new Dimension(fm.stringWidth(this.getText()), fm.getHeight());
    }
}

