/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.privacy;

import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.fileContentReaders.PrivacyReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.toolchain.impl.RustcMessage;
import org.rust.cargo.toolchain.impl.RustcSpan;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/rust/privacy/RustcMessagePrivacyReader;", "Lcom/intellij/ml/llm/privacy/fileContentReaders/PrivacyReader;", "Lorg/rust/cargo/toolchain/impl/RustcMessage;", "", "unsafeContent", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "<init>", "(Ljava/lang/String;Lorg/rust/cargo/project/model/CargoProject;)V", "isPrivate", "", "entity", "project", "Lcom/intellij/openapi/project/Project;", "readContentsUnsafe", "intellij.ml.llm.rust"})
@SourceDebugExtension(value={"SMAP\nCargoTopMessagePrivacyWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTopMessagePrivacyWrapper.kt\ncom/intellij/ml/llm/rust/privacy/RustcMessagePrivacyReader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1255#2,2:57\n1761#3,3:59\n*S KotlinDebug\n*F\n+ 1 CargoTopMessagePrivacyWrapper.kt\ncom/intellij/ml/llm/rust/privacy/RustcMessagePrivacyReader\n*L\n45#1:57,2\n49#1:59,3\n*E\n"})
final class RustcMessagePrivacyReader
implements PrivacyReader<RustcMessage, String> {
    @NotNull
    private final String unsafeContent;
    @NotNull
    private final CargoProject cargoProject;

    public RustcMessagePrivacyReader(@NotNull String unsafeContent, @NotNull CargoProject cargoProject) {
        Intrinsics.checkNotNullParameter((Object)unsafeContent, (String)"unsafeContent");
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        this.unsafeContent = unsafeContent;
        this.cargoProject = cargoProject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrivate(@NotNull RustcMessage entity, @Nullable Project project2) {
        String it;
        Iterable $this$any$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)entity.getSpans()), RustcMessagePrivacyReader::isPrivate$lambda$0);
        boolean $i$f$any = false;
        for (Object e : $this$any$iv) {
            boolean bl;
            it = (String)e;
            boolean bl2 = false;
            VirtualFile virtualFile2 = this.cargoProject.getRootDir();
            if (virtualFile2 == null || (virtualFile2 = VirtualFileUtil.findFileOrDirectory((VirtualFile)virtualFile2, (String)it)) == null) {
                bl = false;
            } else {
                VirtualFile file = virtualFile2;
                if (project2 == null) return true;
                if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, file)) {
                    return true;
                }
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        boolean bl = false;
        boolean isPrivate = bl;
        if (isPrivate) return true;
        $this$any$iv = entity.getChildren();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object t = iterator.next();
            it = (RustcMessage)t;
            boolean bl3 = false;
        } while (!this.isPrivate((RustcMessage)it, project2));
        return true;
    }

    @NotNull
    public String readContentsUnsafe(@NotNull RustcMessage entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.unsafeContent;
    }

    private static final String isPrivate$lambda$0(RustcSpan it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile_name();
    }
}

