/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.formatting;

import com.intellij.database.actions.ActionAvailability;
import com.intellij.database.actions.BasicElementActionFun;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.sql.formatting.SqlAiFormatter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlStatement;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/sql/formatting/SqlAiFormatAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkAvailability", "Lcom/intellij/database/actions/ActionAvailability;", "actionPerformed", "peekSqlStatement", "Lcom/intellij/sql/psi/SqlStatement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "innerElement", "Lcom/intellij/psi/PsiElement;", "intellij.ml.llm.sql"})
@SourceDebugExtension(value={"SMAP\nSqlAiFormatAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlAiFormatAction.kt\ncom/intellij/ml/llm/sql/formatting/SqlAiFormatAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,99:1\n30#2,2:100\n*S KotlinDebug\n*F\n+ 1 SqlAiFormatAction.kt\ncom/intellij/ml/llm/sql/formatting/SqlAiFormatAction\n*L\n69#1:100,2\n*E\n"})
public final class SqlAiFormatAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return SqlAiFormatter.Companion.getEnabled() ? ActionUpdateThread.BGT : ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation p = presentation2;
        if (SqlAiFormatter.Companion.getEnabled()) {
            BasicElementActionFun.setAvailability((Presentation)p, (ActionAvailability)this.checkAvailability(e));
        } else {
            p.setEnabledAndVisible(false);
        }
    }

    private final ActionAvailability checkAvailability(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return ActionAvailability.ACTION_HIDDEN;
        }
        Project project3 = project2;
        if (!AIAssistantUIUtil.INSTANCE.isAssistantActive(project3)) {
            return ActionAvailability.ACTION_HIDDEN;
        }
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext ctx = dataContext2;
        Language language = (Language)ctx.getData(PlatformDataKeys.LANGUAGE);
        if (!(language instanceof SqlLanguageDialect)) {
            return ActionAvailability.ACTION_HIDDEN;
        }
        Editor editor2 = (Editor)ctx.getData(PlatformDataKeys.EDITOR);
        if (editor2 == null) {
            return ActionAvailability.ACTION_HIDDEN;
        }
        Editor editor3 = editor2;
        if (!ProjectKt.isDirectoryBased((Project)project3)) {
            return ActionAvailability.ACTION_DISABLED;
        }
        if (editor3.getSelectionModel().hasSelection()) {
            return ActionAvailability.ACTION_DISABLED;
        }
        Path path = ProjectKt.getStateStore((Project)project3).getDirectoryStorePath();
        if (path == null) {
            return ActionAvailability.ACTION_DISABLED;
        }
        Path dotIdeaPath = path;
        Object object = editor3.getVirtualFile();
        if (object == null || (object = VirtualFileUtil.toNioPathOrNull((VirtualFile)object)) == null) {
            return ActionAvailability.ACTION_DISABLED;
        }
        Object filePath = object;
        if (filePath.startsWith(dotIdeaPath)) {
            return ActionAvailability.ACTION_DISABLED;
        }
        SqlStatement statement = this.peekSqlStatement(project3, editor3);
        return statement != null ? ActionAvailability.ACTION_ENABLED : ActionAvailability.ACTION_DISABLED;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext ctx = dataContext2;
        Editor editor2 = (Editor)ctx.getData(PlatformDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Language language = (Language)ctx.getData(PlatformDataKeys.LANGUAGE);
        if (!(language instanceof SqlLanguageDialect)) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<SqlAiFormatter> serviceClass$iv = SqlAiFormatter.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        SqlAiFormatter service = (SqlAiFormatter)object;
        SelectionModel selectionModel = editor3.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (!selectionModel2.hasSelection()) {
            SqlStatement sqlStatement = this.peekSqlStatement(project3, editor3);
            if (sqlStatement == null) {
                return;
            }
            SqlStatement statement = sqlStatement;
            service.formatStatementWithProgress$intellij_ml_llm_sql(project3, language, editor3, statement);
        }
    }

    private final SqlStatement peekSqlStatement(Project project2, Editor editor2) {
        VirtualFile virtualFile2 = editor2.getVirtualFile();
        if (virtualFile2 == null || (virtualFile2 = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile2, (Project)project2)) == null) {
            return null;
        }
        VirtualFile psiFile = virtualFile2;
        if (psiFile.getFirstChild() == null) {
            return null;
        }
        int pos = editor2.getCaretModel().getCurrentCaret().getOffset();
        PsiElement elementAtCaret = psiFile.findElementAt(pos);
        return this.peekSqlStatement(elementAtCaret);
    }

    private final SqlStatement peekSqlStatement(PsiElement innerElement) {
        for (PsiElement e = innerElement; e != null && !(e instanceof PsiFile); e = e.getParent()) {
            if (!(e instanceof SqlStatement)) continue;
            return (SqlStatement)e;
        }
        return null;
    }
}

