/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.formatting;

import com.intellij.database.util.common.StringFun;
import com.intellij.lang.Language;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.sql.formatting.SqlAiResult;
import com.intellij.sql.dialects.SqlLanguageDialect;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/sql/formatting/SqlAiPromptProducer;", "", "<init>", "()V", "ourGenericDialectId", "", "prepareFormatExampleIntroduction", "Lcom/intellij/ml/llm/privacy/PSString;", "dialect", "Lcom/intellij/lang/Language;", "formatRequestPhrase", "getFormatRequestPhrase", "()Lcom/intellij/ml/llm/privacy/PSString;", "preparePrompt", "exampleText", "textToFormat", "encloseCodeText", "text", "extractCodeSnippet", "Lcom/intellij/ml/llm/sql/formatting/SqlAiResult;", "aiResultText", "", "resultQuotationPattern", "Lkotlin/text/Regex;", "getResultQuotationPattern$intellij_ml_llm_sql", "()Lkotlin/text/Regex;", "intellij.ml.llm.sql"})
public final class SqlAiPromptProducer {
    @NotNull
    public static final SqlAiPromptProducer INSTANCE = new SqlAiPromptProducer();
    @NotNull
    public static final String ourGenericDialectId = "GenericSQL";
    @NotNull
    private static final PSString formatRequestPhrase = ConstantsKt.getPrivacyConst((String)"|Please reformat the following code to get the formatting similar to my example above.\n    ").trimMargin();
    @NotNull
    private static final Regex resultQuotationPattern = new Regex("^(.*?\\n)?\\s*`{3,}[^\\n]*?\\n(.*\\n)\\s*`{3,}.*?$", RegexOption.DOT_MATCHES_ALL);

    private SqlAiPromptProducer() {
    }

    @NotNull
    public final PSString prepareFormatExampleIntroduction(@NotNull Language dialect) {
        PSString pSString;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        boolean bl2 = bl = dialect instanceof SqlLanguageDialect && !Intrinsics.areEqual((Object)((SqlLanguageDialect)dialect).getID(), (Object)ourGenericDialectId);
        if (bl) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe(dialect).getDisplayName()};
            pSString = ConstantsKt.getPrivacyConst((String)"|Hello!\n                 |I'm using %s.\n                 |Here is the example of the good SQL code formatting:\n              ").format(pSStringConvertibleArray).trimMargin();
        } else if (!bl) {
            pSString = ConstantsKt.getPrivacyConst((String)"|Hello!\n                  |Here is the example of the good SQL code formatting:\n               ").trimMargin();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pSString;
    }

    @NotNull
    public final PSString getFormatRequestPhrase() {
        return formatRequestPhrase;
    }

    @NotNull
    public final PSString preparePrompt(@NotNull Language dialect, @NotNull PSString exampleText, @NotNull PSString textToFormat) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)exampleText, (String)"exampleText");
        Intrinsics.checkNotNullParameter((Object)textToFormat, (String)"textToFormat");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{this.prepareFormatExampleIntroduction(dialect), this.encloseCodeText(exampleText, dialect), formatRequestPhrase, this.encloseCodeText(textToFormat, dialect)};
        return ConstantsKt.getPrivacyConst((String)"|%s\n              |\n              |%s\n              |\n              |%s\n              |\n              |%s\n           ").format(pSStringConvertibleArray).trimMargin();
    }

    private final PSString encloseCodeText(PSString text2, Language dialect) {
        PSString dialectMarker = ConstantsKt.getPrivacyConst((String)"SQL");
        return PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)dialectMarker, (PSString)text2);
    }

    @NotNull
    public final SqlAiResult extractCodeSnippet(@NotNull CharSequence aiResultText) {
        MatchResult m;
        Intrinsics.checkNotNullParameter((Object)aiResultText, (String)"aiResultText");
        if (StringsKt.isBlank((CharSequence)aiResultText)) {
            return SqlAiResult.Companion.failure("ai.FormatByExample.fail.noText", "Cannot format: no text");
        }
        MatchResult matchResult = m = StringFun.match((CharSequence)aiResultText, (Regex)resultQuotationPattern);
        CharSequence snippet = matchResult != null ? (CharSequence)matchResult.getGroupValues().get(2) : aiResultText;
        return SqlAiResult.Companion.success(((Object)snippet).toString());
    }

    @NotNull
    public final Regex getResultQuotationPattern$intellij_ml_llm_sql() {
        return resultQuotationPattern;
    }
}

