/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.privacy.extensions;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.Version;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExternalPrivacyWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\f\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/sql/privacy/extensions/DataSourceWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalPrivacyWrapper;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "<init>", "(Lcom/intellij/database/model/DasDataSource;)V", "uniqueId", "Lcom/intellij/ml/llm/privacy/PSString;", "getUniqueId", "()Lcom/intellij/ml/llm/privacy/PSString;", "dbmsDisplayName", "getDbmsDisplayName", "dbmsVersion", "getDbmsVersion", "intellij.ml.llm.sql"})
@SourceDebugExtension(value={"SMAP\nExtensionsKt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionsKt.kt\ncom/intellij/ml/llm/sql/privacy/extensions/DataSourceWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class DataSourceWrapper
extends ExternalPrivacyWrapper {
    @NotNull
    private final DasDataSource dataSource;

    public DataSourceWrapper(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
    }

    @NotNull
    public final PSString getUniqueId() {
        String string = this.dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        return this.promisedSafety(string);
    }

    @NotNull
    public final PSString getDbmsDisplayName() {
        String string = this.dataSource.getDbms().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return this.promisedSafety(string);
    }

    @Nullable
    public final PSString getDbmsVersion() {
        PSString pSString;
        Version version = this.dataSource.getVersion();
        if (version != null) {
            Version it = version;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            pSString = this.promisedSafety(string);
        } else {
            pSString = null;
        }
        return pSString;
    }
}

