/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.summary;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.summary.SelectionCommitSummary;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J$\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/vcs/summary/SelectionCommitSummaryIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "getText", "", "startInWriteAction", "", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.ml.llm.vcs"})
public final class SelectionCommitSummaryIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return LLMVcsBundle.message("action.ai.generated.summary.file.selection.title", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!LLMSettingsManager.Companion.getInstance().isSelectionGenerateCommitSummaryEnabled()) return false;
        Editor editor3 = editor2;
        Editor editor4 = editor3;
        if (editor3 == null) return false;
        SelectionModel selectionModel = editor4.getSelectionModel();
        editor4 = selectionModel;
        if (selectionModel == null) return false;
        if (!editor4.hasSelection()) return false;
        return true;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (psiFile == null || editor2 == null) {
                return;
            }
            Document document2 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            Document document3 = document2;
            int startLine = document3.getLineNumber(editor2.getSelectionModel().getSelectionStart());
            int endLine = document3.getLineNumber(editor2.getSelectionModel().getSelectionEnd());
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            Task.Backgroundable backgroundable = new SelectionCommitSummary(project2, virtualFile2, startLine, endLine).createTask();
            if (backgroundable == null) break block1;
            backgroundable.queue();
        }
    }
}

