/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.AgentIssue;
import com.intellij.ml.llm.matterhorn.AgentSessionHistory;
import com.intellij.ml.llm.matterhorn.CustomContext;
import com.intellij.ml.llm.matterhorn.ExecutionContextUserDataKey;
import com.intellij.ml.llm.matterhorn.FileWithLine;
import com.intellij.ml.llm.matterhorn.RootExecutionContext;
import com.intellij.ml.llm.matterhorn.run.ExecutionEnvironment;
import com.intellij.ml.llm.matterhorn.run.ExecutionMode;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.docker.DockerExecutionEnvironment;
import com.intellij.ml.llm.matterhorn.run.docker.GlobalDockerProjectState;
import com.intellij.ml.llm.matterhorn.run.docker.LayoutType;
import com.intellij.ml.llm.matterhorn.run.local.LocalExecutionEnvironment;
import com.intellij.ml.llm.matterhorn.settings.MatterhornPersistentStateComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/matterhorn/AgentContext;", "Lcom/intellij/ml/llm/matterhorn/CustomContext;", "currentIssue", "Lcom/intellij/ml/llm/matterhorn/AgentIssue;", "currentDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/AgentIssue;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getCurrentDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCurrentDir", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "currentScreenPosition", "Lcom/intellij/ml/llm/matterhorn/FileWithLine;", "getCurrentScreenPosition", "()Lcom/intellij/ml/llm/matterhorn/FileWithLine;", "setCurrentScreenPosition", "(Lcom/intellij/ml/llm/matterhorn/FileWithLine;)V", "editsHistory", "", "", "Lcom/intellij/openapi/vcs/changes/Change;", "sessionHistory", "Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "getSessionHistory", "()Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "changes", "getChanges", "()Ljava/util/List;", "pushChange", "", "popChange", "getExecutionEnvironment", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionEnvironment;", "root", "Lcom/intellij/ml/llm/matterhorn/RootExecutionContext;", "copy", "Companion", "ej-core"})
@SourceDebugExtension(value={"SMAP\nAgentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentContext.kt\ncom/intellij/ml/llm/matterhorn/AgentContext\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,217:1\n31#2,2:218\n31#2,2:220\n14#3:222\n*S KotlinDebug\n*F\n+ 1 AgentContext.kt\ncom/intellij/ml/llm/matterhorn/AgentContext\n*L\n72#1:218,2\n84#1:220,2\n56#1:222\n*E\n"})
public final class AgentContext
implements CustomContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AgentIssue currentIssue;
    @NotNull
    private VirtualFile currentDir;
    @Nullable
    private FileWithLine currentScreenPosition;
    @NotNull
    private List<List<Change>> editsHistory;
    @NotNull
    private final AgentSessionHistory sessionHistory;
    @NotNull
    private final List<List<Change>> changes;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ExecutionContextUserDataKey<AgentContext> KEY;

    public AgentContext(@Nullable AgentIssue currentIssue, @NotNull VirtualFile currentDir) {
        Intrinsics.checkNotNullParameter((Object)currentDir, (String)"currentDir");
        this.currentIssue = currentIssue;
        this.currentDir = currentDir;
        this.editsHistory = new ArrayList();
        this.sessionHistory = AgentSessionHistory.Companion.initialHistoryContext();
        this.changes = this.editsHistory;
    }

    @NotNull
    public final VirtualFile getCurrentDir() {
        return this.currentDir;
    }

    public final void setCurrentDir(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.currentDir = virtualFile;
    }

    @Nullable
    public final FileWithLine getCurrentScreenPosition() {
        return this.currentScreenPosition;
    }

    public final void setCurrentScreenPosition(@Nullable FileWithLine fileWithLine) {
        this.currentScreenPosition = fileWithLine;
    }

    @NotNull
    public final AgentSessionHistory getSessionHistory() {
        return this.sessionHistory;
    }

    @NotNull
    public final List<List<Change>> getChanges() {
        return this.changes;
    }

    public final void pushChange(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.editsHistory.add(changes);
    }

    @NotNull
    public final List<Change> popChange() {
        return this.editsHistory.isEmpty() ? CollectionsKt.emptyList() : (List)CollectionsKt.removeLast(this.editsHistory);
    }

    @NotNull
    public final ExecutionEnvironment getExecutionEnvironment(@NotNull RootExecutionContext root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Project project = root.getService().getProject();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MatterhornPersistentStateComponent> serviceClass$iv = MatterhornPersistentStateComponent.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        MatterhornPersistentStateComponent settings = (MatterhornPersistentStateComponent)((Object)object);
        ExecutionMode executionMode = settings.getEffectiveExecutionMode();
        if (executionMode == null) {
            executionMode = ExecutionMode.UnsafeLocal;
        }
        ExecutionMode executionMode2 = executionMode;
        logger.info("Execution mode from settings: " + settings.getEffectiveExecutionMode() + ", effective execution mode: " + executionMode2);
        ExecutionEnvironment environment = switch (WhenMappings.$EnumSwitchMapping$0[executionMode2.ordinal()]) {
            case 1 -> new LocalExecutionEnvironment(AgentAction.Companion.getShell(root));
            case 2 -> {
                VirtualFile v3 = ProjectUtil.guessProjectDir((Project)project);
                if (v3 == null) {
                    throw new IllegalStateException("No project dir found".toString());
                }
                VirtualFile projectDir = v3;
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GlobalDockerProjectState> serviceClass$iv = GlobalDockerProjectState.class;
                Object v4 = $this$service$iv.getService(serviceClass$iv);
                if (v4 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                String projectContainerName = ((GlobalDockerProjectState)v4).getProjectContainerName();
                Path v5 = projectDir.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toNioPath(...)");
                yield new DockerExecutionEnvironment(project, new LocalPath(v5), LayoutType.MirrorHost, projectContainerName);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return environment;
    }

    @NotNull
    public final CustomContext copy() {
        AgentContext result = new AgentContext(this.currentIssue, this.currentDir);
        result.currentScreenPosition = this.currentScreenPosition;
        return result;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AgentContext.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AgentContext.logger = logger;
        KEY = new ExecutionContextUserDataKey("AgentContextKey");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/matterhorn/AgentContext$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "KEY", "Lcom/intellij/ml/llm/matterhorn/ExecutionContextUserDataKey;", "Lcom/intellij/ml/llm/matterhorn/AgentContext;", "getKEY", "()Lcom/intellij/ml/llm/matterhorn/ExecutionContextUserDataKey;", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutionContextUserDataKey<AgentContext> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutionMode.values().length];
            try {
                nArray[ExecutionMode.UnsafeLocal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionMode.DockerLocal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

