/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ1\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u0005J'\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0014J/\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0010J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J4\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/LevenshteinDistance;", "", "<init>", "()V", "DEFAULT_WEIGHTS", "Lcom/intellij/ml/llm/matterhorn/actions/LevenshteinDistance$Weights;", "getDEFAULT_WEIGHTS", "()Lcom/intellij/ml/llm/matterhorn/actions/LevenshteinDistance$Weights;", "ratio", "", "s1", "", "s2", "distance", "weights", "scoreCutoff", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/actions/LevenshteinDistance$Weights;Ljava/lang/Integer;)I", "normalizedDistance", "", "uniformDistance", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)I", "genericDistance", "maxDistance", "findCommonAffix", "Lkotlin/Pair;", "getTrimmedStrings", "prefixLen", "suffixLen", "Weights", "ej-core"})
public final class LevenshteinDistance {
    @NotNull
    public static final LevenshteinDistance INSTANCE = new LevenshteinDistance();
    @NotNull
    private static final Weights DEFAULT_WEIGHTS = new Weights(0, 0, 0, 7, null);

    private LevenshteinDistance() {
    }

    @NotNull
    public final Weights getDEFAULT_WEIGHTS() {
        return DEFAULT_WEIGHTS;
    }

    public final int ratio(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int lengthMax = Math.max(s1.length(), s2.length());
        int distance = LevenshteinDistance.distance$default(this, s1, s2, null, null, 12, null);
        return MathKt.roundToInt((double)(((double)(lengthMax - distance) + 0.0) / (double)lengthMax * (double)100));
    }

    public final int distance(@NotNull String s1, @NotNull String s2, @NotNull Weights weights, @Nullable Integer scoreCutoff) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
        if (((CharSequence)s1).length() == 0) {
            return s2.length() * weights.getInsertCost();
        }
        if (((CharSequence)s2).length() == 0) {
            return s1.length() * weights.getDeleteCost();
        }
        Pair<Integer, Integer> pair = this.findCommonAffix(s1, s2);
        int prefixLen = ((Number)pair.component1()).intValue();
        int suffixLen = ((Number)pair.component2()).intValue();
        Pair<String, String> pair2 = this.getTrimmedStrings(s1, s2, prefixLen, suffixLen);
        String trimmed1 = (String)pair2.component1();
        String trimmed2 = (String)pair2.component2();
        if (((CharSequence)trimmed1).length() == 0) {
            return trimmed2.length() * weights.getInsertCost();
        }
        if (((CharSequence)trimmed2).length() == 0) {
            return trimmed1.length() * weights.getDeleteCost();
        }
        return Intrinsics.areEqual((Object)weights, (Object)DEFAULT_WEIGHTS) ? this.uniformDistance(trimmed1, trimmed2, scoreCutoff) : this.genericDistance(trimmed1, trimmed2, weights, scoreCutoff);
    }

    public static /* synthetic */ int distance$default(LevenshteinDistance levenshteinDistance, String string, String string2, Weights weights, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            weights = DEFAULT_WEIGHTS;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return levenshteinDistance.distance(string, string2, weights, n);
    }

    public final double normalizedDistance(@NotNull String s1, @NotNull String s2, @NotNull Weights weights) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
        int dist = LevenshteinDistance.distance$default(this, s1, s2, weights, null, 8, null);
        int maxDistance = this.maxDistance(s1, s2, weights);
        return (double)dist / (double)maxDistance;
    }

    public static /* synthetic */ double normalizedDistance$default(LevenshteinDistance levenshteinDistance, String string, String string2, Weights weights, int n, Object object) {
        if ((n & 4) != 0) {
            weights = new Weights(0, 0, 0, 7, null);
        }
        return levenshteinDistance.normalizedDistance(string, string2, weights);
    }

    private final int uniformDistance(String s1, String s2, Integer scoreCutoff) {
        int len1 = s1.length();
        int len2 = s2.length();
        int n = 0;
        int n2 = len1 + 1;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        int[] cache = nArray;
        int j = 1;
        if (j <= len2) {
            do {
                int prevDiag = cache[0];
                cache[0] = ++j;
                int i = 1;
                if (i <= len1) {
                    while (true) {
                        int temp = cache[i];
                        cache[i] = s1.charAt(i - 1) == s2.charAt(j - 1) ? prevDiag : Math.min(prevDiag + 1, Math.min(cache[i - 1] + 1, cache[i] + 1));
                        prevDiag = temp;
                        if (i == len1) break;
                        ++i;
                    }
                }
                if (scoreCutoff == null || cache[len1] <= scoreCutoff) continue;
                return scoreCutoff + 1;
            } while (j != len2);
        }
        return cache[len1];
    }

    private final int genericDistance(String s1, String s2, Weights weights, Integer scoreCutoff) {
        int len1 = s1.length();
        int n = 0;
        int n2 = len1 + 1;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = n3 * weights.getDeleteCost();
        }
        int[] cache = nArray;
        int j = 1;
        n2 = s2.length();
        if (j <= n2) {
            while (true) {
                int prevDiag = cache[0];
                cache[0] = j * weights.getInsertCost();
                int i = 1;
                if (i <= len1) {
                    while (true) {
                        int temp = cache[i];
                        cache[i] = s1.charAt(i - 1) == s2.charAt(j - 1) ? prevDiag : Math.min(prevDiag + weights.getSubstituteCost(), Math.min(cache[i - 1] + weights.getInsertCost(), cache[i] + weights.getDeleteCost()));
                        prevDiag = temp;
                        if (i == len1) break;
                        ++i;
                    }
                }
                if (scoreCutoff != null && cache[len1] > scoreCutoff) {
                    return scoreCutoff + 1;
                }
                if (j == n2) break;
                ++j;
            }
        }
        return cache[len1];
    }

    private final int maxDistance(String s1, String s2, Weights weights) {
        int len1 = s1.length();
        int len2 = s2.length();
        int maxDist = len1 * weights.getDeleteCost() + len2 * weights.getInsertCost();
        maxDist = len1 >= len2 ? Math.min(maxDist, len2 * weights.getSubstituteCost() + (len1 - len2) * weights.getDeleteCost()) : Math.min(maxDist, len1 * weights.getSubstituteCost() + (len2 - len1) * weights.getInsertCost());
        return maxDist;
    }

    private final Pair<Integer, Integer> findCommonAffix(String s1, String s2) {
        int prefixLen;
        int suffixLen = 0;
        int minLen = Math.min(s1.length(), s2.length());
        for (prefixLen = 0; prefixLen < minLen && s1.charAt(prefixLen) == s2.charAt(prefixLen); ++prefixLen) {
        }
        while (suffixLen < minLen - prefixLen && s1.charAt(s1.length() - 1 - suffixLen) == s2.charAt(s2.length() - 1 - suffixLen)) {
            ++suffixLen;
        }
        return new Pair((Object)prefixLen, (Object)suffixLen);
    }

    private final Pair<String, String> getTrimmedStrings(String s1, String s2, int prefixLen, int suffixLen) {
        String string = s1.substring(prefixLen, s1.length() - suffixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String trimmed1 = string;
        String string2 = s2.substring(prefixLen, s2.length() - suffixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String trimmed2 = string2;
        return new Pair((Object)trimmed1, (Object)trimmed2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/LevenshteinDistance$Weights;", "", "insertCost", "", "deleteCost", "substituteCost", "<init>", "(III)V", "getInsertCost", "()I", "getDeleteCost", "getSubstituteCost", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ej-core"})
    public static final class Weights {
        private final int insertCost;
        private final int deleteCost;
        private final int substituteCost;

        public Weights(int insertCost, int deleteCost, int substituteCost) {
            this.insertCost = insertCost;
            this.deleteCost = deleteCost;
            this.substituteCost = substituteCost;
        }

        public /* synthetic */ Weights(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 1;
            }
            if ((n4 & 2) != 0) {
                n2 = 1;
            }
            if ((n4 & 4) != 0) {
                n3 = 1;
            }
            this(n, n2, n3);
        }

        public final int getInsertCost() {
            return this.insertCost;
        }

        public final int getDeleteCost() {
            return this.deleteCost;
        }

        public final int getSubstituteCost() {
            return this.substituteCost;
        }

        public final int component1() {
            return this.insertCost;
        }

        public final int component2() {
            return this.deleteCost;
        }

        public final int component3() {
            return this.substituteCost;
        }

        @NotNull
        public final Weights copy(int insertCost, int deleteCost, int substituteCost) {
            return new Weights(insertCost, deleteCost, substituteCost);
        }

        public static /* synthetic */ Weights copy$default(Weights weights, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = weights.insertCost;
            }
            if ((n4 & 2) != 0) {
                n2 = weights.deleteCost;
            }
            if ((n4 & 4) != 0) {
                n3 = weights.substituteCost;
            }
            return weights.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Weights(insertCost=" + this.insertCost + ", deleteCost=" + this.deleteCost + ", substituteCost=" + this.substituteCost + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.insertCost);
            result = result * 31 + Integer.hashCode(this.deleteCost);
            result = result * 31 + Integer.hashCode(this.substituteCost);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Weights)) {
                return false;
            }
            Weights weights = (Weights)other;
            if (this.insertCost != weights.insertCost) {
                return false;
            }
            if (this.deleteCost != weights.deleteCost) {
                return false;
            }
            return this.substituteCost == weights.substituteCost;
        }

        public Weights() {
            this(0, 0, 0, 7, null);
        }
    }
}

