/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions.edit;

import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.edit.EditEvent;
import com.intellij.ml.llm.matterhorn.actions.edit.FileChange;
import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.PathConverter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a8\u0006\u0013"}, d2={"getEditedScreen", "", "pathConverter", "Lcom/intellij/ml/llm/matterhorn/run/PathConverter;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "startLineIncl", "", "Lcom/intellij/ml/llm/matterhorn/OneBasedIndex;", "window", "editedDoc", "Lcom/intellij/openapi/editor/Document;", "createEditPathMarker", "", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "changes", "", "Lcom/intellij/ml/llm/matterhorn/actions/edit/FileChange;", "ej-core"})
public final class AbstractEditActionKt {
    private static final String getEditedScreen(PathConverter pathConverter, VirtualFile virtualFile, int startLineIncl, int window, Document editedDoc) {
        Path path = virtualFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        ExecutionPath executionPath = pathConverter.convertLocalPathToExecutionPath(new LocalPath(path));
        int startLine = Math.max(startLineIncl - window / 2, 1);
        int constrainedStartLine = AgentUtilsKt.constraintStartLineNum(startLine, window, editedDoc.getLineCount());
        return AgentUtilsKt.printScreen(constrainedStartLine, window, editedDoc, executionPath, ":");
    }

    public static final void createEditPathMarker(@NotNull ExecutionAgentContext context2, @NotNull List<FileChange> changes) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return;
        }
        context2.getExecutionContext().sendEvent(new EditEvent(changes));
    }

    public static final /* synthetic */ String access$getEditedScreen(PathConverter pathConverter, VirtualFile virtualFile, int startLineIncl, int window, Document editedDoc) {
        return AbstractEditActionKt.getEditedScreen(pathConverter, virtualFile, startLineIncl, window, editedDoc);
    }
}

