/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.api.AsIterableKt;
import org.jetbrains.kotlinx.dataframe.api.AsSequenceKt;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.Aggregator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012 \u0010\u0006\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ%\u0010\u000f\u001a\u0004\u0018\u00018\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R.\u0010\u0006\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/AggregatorBase;", "C", "R", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/Aggregator;", "name", "", "aggregator", "Lkotlin/Function2;", "", "Lkotlin/reflect/KType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getAggregator", "()Lkotlin/jvm/functions/Function2;", "getName", "()Ljava/lang/String;", "aggregate", "values", "type", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;)Ljava/lang/Object;", "column", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "(Lorg/jetbrains/kotlinx/dataframe/DataColumn;)Ljava/lang/Object;", "core"})
public abstract class AggregatorBase<C, R>
implements Aggregator<C, R> {
    @NotNull
    private final String name;
    @NotNull
    private final Function2<Iterable<? extends C>, KType, R> aggregator;

    public AggregatorBase(@NotNull String name, @NotNull Function2<? super Iterable<? extends C>, ? super KType, ? extends R> aggregator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(aggregator, (String)"aggregator");
        this.name = name;
        this.aggregator = aggregator;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    protected final Function2<Iterable<? extends C>, KType, R> getAggregator() {
        return this.aggregator;
    }

    @Override
    @Nullable
    public R aggregate(@NotNull DataColumn<? extends C> column2) {
        R r;
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        if (column2.hasNulls()) {
            r = this.aggregate(SequencesKt.asIterable((Sequence)SequencesKt.filterNotNull(AsSequenceKt.asSequence(column2))), column2.type());
        } else {
            Iterable<? extends C> iterable = AsIterableKt.asIterable(column2);
            Intrinsics.checkNotNull(iterable, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<C of org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.AggregatorBase>");
            r = this.aggregate(iterable, column2.type());
        }
        return r;
    }

    @Override
    @Nullable
    public R aggregate(@NotNull Iterable<? extends C> values2, @NotNull KType type) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return (R)this.aggregator.invoke(values2, (Object)type);
    }
}

