/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.codeSnippet.find;

import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.Alignment;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.Edit;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.EditType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007Jp\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/LevenshteinStringAligner;", "", "<init>", "()V", "find", "Lkotlin/ranges/IntRange;", "text", "", "sample", "alignStrings", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/Alignment;", "length1", "", "length2", "price", "Lkotlin/Function2;", "", "isValidRange1", "Lkotlin/Function1;", "", "isValidRange2", "priceOfDeletion", "priceOfInsertion", "isLocal", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nLevenshteinStringAligner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevenshteinStringAligner.kt\ncom/intellij/ml/llm/core/chat/actions/codeSnippet/find/LevenshteinStringAligner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n2423#2,14:133\n*S KotlinDebug\n*F\n+ 1 LevenshteinStringAligner.kt\ncom/intellij/ml/llm/core/chat/actions/codeSnippet/find/LevenshteinStringAligner\n*L\n49#1:133,14\n*E\n"})
public final class LevenshteinStringAligner {
    @NotNull
    public static final LevenshteinStringAligner INSTANCE = new LevenshteinStringAligner();

    private LevenshteinStringAligner() {
    }

    @Nullable
    public final IntRange find(@NotNull String text2, @NotNull String sample) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        if (((CharSequence)text2).length() == 0 || ((CharSequence)sample).length() == 0) {
            return null;
        }
        int priceOfDeletion = 2;
        int priceOfReplacement = 3;
        int[] prevDist = new int[text2.length()];
        int[] curDist = null;
        curDist = new int[text2.length()];
        int[] prevStart = new int[text2.length()];
        int n = 0;
        int n2 = text2.length();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = n3 + 1;
        }
        int[] curStart = nArray;
        n2 = ((CharSequence)sample).length();
        for (int i = 0; i < n2; ++i) {
            int[] temp = prevDist;
            prevDist = curDist;
            curDist = temp;
            temp = prevStart;
            prevStart = curStart;
            curStart = temp;
            int n4 = ((CharSequence)text2).length();
            for (int j = 0; j < n4; ++j) {
                curDist[j] = prevDist[j] + priceOfDeletion;
                curStart[j] = prevStart[j];
                int dist = (j > 0 ? prevDist[j - 1] : i * priceOfDeletion) + (sample.charAt(i) == text2.charAt(j) ? 0 : priceOfReplacement);
                if (curDist[j] > dist) {
                    curDist[j] = dist;
                    int n5 = curStart[j] = j > 0 ? prevStart[j - 1] : 0;
                }
                if (j <= 0 || curDist[j] <= curDist[j - 1] + priceOfDeletion) continue;
                curDist[j] = curDist[j - 1] + priceOfDeletion;
                curStart[j] = curStart[j - 1];
            }
        }
        Iterable $this$minByOrNull$iv = (Iterable)ArraysKt.getIndices((int[])curDist);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                int it = ((Number)minElem$iv).intValue();
                boolean bl = false;
                int minValue$iv = curDist[it];
                do {
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    $i$a$-minByOrNull-LevenshteinStringAligner$find$bestOffset$1 = false;
                    int v$iv = curDist[it2];
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Integer n6 = v1;
        if (n6 == null) {
            return null;
        }
        int bestOffset = n6;
        return RangesKt.until((int)curStart[bestOffset], (int)(bestOffset + 1));
    }

    @NotNull
    public final Alignment alignStrings(int length1, int length2, @NotNull Function2<? super Integer, ? super Integer, Double> price, @NotNull Function1<? super IntRange, Boolean> isValidRange1, @NotNull Function1<? super IntRange, Boolean> isValidRange2, double priceOfDeletion, double priceOfInsertion, boolean isLocal) {
        int i;
        Object object;
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter(price, (String)"price");
        Intrinsics.checkNotNullParameter(isValidRange1, (String)"isValidRange1");
        Intrinsics.checkNotNullParameter(isValidRange2, (String)"isValidRange2");
        int n4 = 0;
        int n5 = length1 + 1;
        double[][] dArrayArray = new double[n5][];
        while (n4 < n5) {
            int n6 = n4++;
            dArrayArray[n6] = new double[length2 + 1];
        }
        double[][] v = dArrayArray;
        int n7 = length1 + 1;
        Pair[][] pairArrayArray = new Pair[n7][];
        for (n5 = 0; n5 < n7; ++n5) {
            int n8 = n5;
            n3 = 0;
            n2 = length2 + 1;
            Pair[] pairArray = new Pair[n2];
            n = n8;
            object = pairArrayArray;
            while (n3 < n2) {
                int n9 = n3++;
                pairArray[n9] = new Pair((Object)n8, (Object)n9);
            }
            object[n] = pairArray;
        }
        Pair[][] s = pairArrayArray;
        int n10 = length1 + 1;
        EditType[][] editTypeArrayArray = new EditType[n10][];
        for (n7 = 0; n7 < n10; ++n7) {
            n3 = n7;
            n2 = 0;
            int n11 = length2 + 1;
            EditType[] editTypeArray = new EditType[n11];
            n = n3;
            object = editTypeArrayArray;
            while (n2 < n11) {
                int n12 = n2++;
                editTypeArray[n12] = EditType.Start;
            }
            object[n] = editTypeArray;
        }
        EditType[][] p = editTypeArrayArray;
        int bi = 0;
        int bj = 0;
        if (!isLocal) {
            int j;
            int i2 = 1;
            if (i2 <= length1) {
                while (true) {
                    v[i2][0] = (double)i2 * priceOfDeletion;
                    if (i2 == length1) break;
                    ++i2;
                }
            }
            if ((j = 1) <= length2) {
                while (true) {
                    v[0][j] = (double)j * priceOfInsertion;
                    if (j == length2) break;
                    ++j;
                }
            }
        }
        if ((i = 1) <= length1) {
            while (true) {
                int j;
                if ((j = 1) <= length2) {
                    while (true) {
                        v[i][j] = v[i - 1][j - 1] + ((Number)price.invoke((Object)(i - 1), (Object)(j - 1))).doubleValue();
                        s[i][j] = s[i - 1][j - 1];
                        p[i][j] = EditType.Match;
                        if (v[i][j] < v[i - 1][j] + priceOfDeletion) {
                            v[i][j] = v[i - 1][j] + priceOfDeletion;
                            s[i][j] = s[i - 1][j];
                            p[i][j] = EditType.Delete;
                        }
                        if (v[i][j] < v[i][j - 1] + priceOfInsertion) {
                            v[i][j] = v[i][j - 1] + priceOfInsertion;
                            s[i][j] = s[i][j - 1];
                            p[i][j] = EditType.Insert;
                        }
                        if (isLocal && v[i][j] < 0.0) {
                            v[i][j] = 0.0;
                            s[i][j] = new Pair((Object)i, (Object)j);
                            p[i][j] = EditType.Start;
                        }
                        if (v[bi][bj] < v[i][j] && ((Boolean)isValidRange1.invoke((Object)RangesKt.until((int)((Number)s[i][j].getFirst()).intValue(), (int)i))).booleanValue() && ((Boolean)isValidRange2.invoke((Object)RangesKt.until((int)((Number)s[i][j].getSecond()).intValue(), (int)j))).booleanValue()) {
                            bi = i;
                            bj = j;
                        }
                        if (j == length2) break;
                        ++j;
                    }
                }
                if (i == length1) break;
                ++i;
            }
        }
        if (!isLocal) {
            bi = length1;
            bj = length2;
        }
        int ci = bi;
        int cj = bj;
        int pi = bi;
        int pj = bj;
        List edits = new ArrayList();
        while (p[ci][cj] != EditType.Start) {
            EditType type = p[pi][pj];
            while (p[ci][cj] == type) {
                if (type == EditType.Match || type == EditType.Delete) {
                    --ci;
                }
                if (type != EditType.Match && type != EditType.Insert) continue;
                --cj;
            }
            edits.add(new Edit(RangesKt.until((int)ci, (int)pi), RangesKt.until((int)cj, (int)pj), type));
            pi = ci;
            pj = cj;
        }
        return new Alignment(v[bi][bj], RangesKt.until((int)((Number)s[bi][bj].getFirst()).intValue(), (int)bi), RangesKt.until((int)((Number)s[bi][bj].getSecond()).intValue(), (int)bj), edits);
    }
}

