/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.uiPicker.genericTextParser;

import com.intellij.ml.llm.core.chat.context.uiPicker.PickerHighlighter;
import com.intellij.ml.llm.privacy.ui.parser.ParsedTextData;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/GenericTextHighlighter;", "Lcom/intellij/ml/llm/core/chat/context/uiPicker/PickerHighlighter;", "component", "Ljava/awt/Component;", "texts", "", "Lcom/intellij/ml/llm/privacy/ui/parser/ParsedTextData;", "<init>", "(Ljava/awt/Component;Ljava/util/List;)V", "hintName", "", "getHintName", "()Ljava/lang/String;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nGenericTextHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericTextHighlighter.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/GenericTextHighlighter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1869#2,2:43\n*S KotlinDebug\n*F\n+ 1 GenericTextHighlighter.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/GenericTextHighlighter\n*L\n32#1:43,2\n*E\n"})
public final class GenericTextHighlighter
extends PickerHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ParsedTextData> texts;
    @NotNull
    private final String hintName;
    private static final int TEXT_HIGHLIGHT_RADIUS = JBUIScale.scale((int)3);

    public GenericTextHighlighter(@NotNull Component component, @NotNull List<ParsedTextData> texts) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        super(component);
        this.texts = texts;
        this.hintName = "Visible Text";
    }

    @Override
    @NotNull
    public String getHintName() {
        return this.hintName;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (GenericTextHighlighter.Companion.isDebugHighlightingEnabled()) {
            Graphics graphics = g.create();
            Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
            if (graphics2D == null) {
                return;
            }
            Graphics2D g2d = graphics2D;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor((Color)JBColor.DARK_GRAY);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
            Iterable $this$forEach$iv = this.texts;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParsedTextData data2 = (ParsedTextData)element$iv;
                boolean bl = false;
                g2d.fillRoundRect(data2.getBounds().x, data2.getBounds().y - data2.getBounds().height, data2.getBounds().width, data2.getBounds().height + data2.getBounds().height / 2, TEXT_HIGHLIGHT_RADIUS, TEXT_HIGHLIGHT_RADIUS);
            }
            g2d.dispose();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/GenericTextHighlighter$Companion;", "", "<init>", "()V", "TEXT_HIGHLIGHT_RADIUS", "", "isDebugHighlightingEnabled", "", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isDebugHighlightingEnabled() {
            return Registry.Companion.is("llm.chat.context.picker.debug", true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

