/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.messages.impl;

import com.intellij.lang.Language;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.core.chat.attachments.VisibleChatAttachment;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.ChatMessageButton;
import com.intellij.ml.llm.core.chat.messages.ChatMessageDumpKt;
import com.intellij.ml.llm.core.chat.messages.CompletableMessageButtonListener;
import com.intellij.ml.llm.core.chat.messages.CompletableMessageLinkListener;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ui.components.ActionLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0014H\u0016J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0018\u00107\u001a\u00020(*\u000608j\u0002`92\u0006\u0010:\u001a\u00020;H\u0016J\u0006\u0010<\u001a\u00020\u001cR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0016\u0010#\u001a\u0004\u0018\u00010$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R$\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020302j\u0002`4018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006="}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/AbstractChatMessage;", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "uid", "", "author", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "<init>", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;)V", "getChat", "()Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "setChat", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;)V", "getUid", "()Ljava/lang/String;", "getAuthor", "()Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "linkListener", "", "Lcom/intellij/ml/llm/core/chat/messages/CompletableMessageLinkListener;", "buttonListener", "Lcom/intellij/ml/llm/core/chat/messages/CompletableMessageButtonListener;", "messageLinks", "Lcom/intellij/ui/components/ActionLink;", "messageButtons", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageButton;", "timestamp", "", "links", "", "getLinks", "()Ljava/util/List;", "buttons", "getButtons", "markupLanguage", "Lcom/intellij/lang/Language;", "getMarkupLanguage", "()Lcom/intellij/lang/Language;", "addLink", "", "link", "addLinkListener", "listener", "addButton", "button", "removeButton", "addButtonListener", "contextFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/ml/llm/context/ContextEntity;", "Lcom/intellij/ml/llm/context/ContextEntities;", "getContextFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "dump", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "headerLength", "", "getTimestamp", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAbstractChatMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractChatMessage.kt\ncom/intellij/ml/llm/core/chat/messages/impl/AbstractChatMessage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n808#2,11:65\n1563#2:76\n1634#2,3:77\n*S KotlinDebug\n*F\n+ 1 AbstractChatMessage.kt\ncom/intellij/ml/llm/core/chat/messages/impl/AbstractChatMessage\n*L\n55#1:65,11\n55#1:76\n55#1:77,3\n*E\n"})
public abstract class AbstractChatMessage
implements MarkdownChatMessage {
    @NotNull
    private ChatSession chat;
    @NotNull
    private final String uid;
    @NotNull
    private final ChatMessageAuthor author;
    @NotNull
    private final List<CompletableMessageLinkListener> linkListener;
    @NotNull
    private final List<CompletableMessageButtonListener> buttonListener;
    @NotNull
    private final List<ActionLink> messageLinks;
    @NotNull
    private final List<ChatMessageButton> messageButtons;
    private final long timestamp;
    @Nullable
    private final Language markupLanguage;

    public AbstractChatMessage(@NotNull ChatSession chat, @NotNull String uid, @NotNull ChatMessageAuthor author) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
        this.chat = chat;
        this.uid = uid;
        this.author = author;
        this.linkListener = new ArrayList();
        this.buttonListener = new ArrayList();
        this.messageLinks = new ArrayList();
        this.messageButtons = new ArrayList();
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    @NotNull
    public final ChatSession getChat() {
        return this.chat;
    }

    @Override
    public final void setChat(@NotNull ChatSession chatSession2) {
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"<set-?>");
        this.chat = chatSession2;
    }

    @Override
    @NotNull
    public final String getUid() {
        return this.uid;
    }

    @Override
    @NotNull
    public final ChatMessageAuthor getAuthor() {
        return this.author;
    }

    @Override
    @NotNull
    public List<ActionLink> getLinks() {
        return this.messageLinks;
    }

    @Override
    @NotNull
    public List<ChatMessageButton> getButtons() {
        return this.messageButtons;
    }

    @Override
    @Nullable
    public Language getMarkupLanguage() {
        return this.markupLanguage;
    }

    @Override
    public void addLink(@NotNull ActionLink link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.messageLinks.add(link);
        for (CompletableMessageLinkListener listener2 : this.linkListener) {
            listener2.onLinksChanged();
        }
    }

    @Override
    public void addLinkListener(@NotNull CompletableMessageLinkListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.linkListener.add(listener2);
        listener2.onLinksChanged();
    }

    @Override
    public void addButton(@NotNull ChatMessageButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.messageButtons.add(button);
        for (CompletableMessageButtonListener listener2 : this.buttonListener) {
            listener2.onButtonsChanged();
        }
    }

    @Override
    public void removeButton(@NotNull ChatMessageButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.messageButtons.remove(button);
        for (CompletableMessageButtonListener listener2 : this.buttonListener) {
            listener2.onButtonsChanged();
        }
    }

    @Override
    public void addButtonListener(@NotNull CompletableMessageButtonListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.buttonListener.add(listener2);
        listener2.onButtonsChanged();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StateFlow<Iterable<ContextEntity>> getContextFlow() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getAttachments();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VisibleChatAttachment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisibleChatAttachment visibleChatAttachment = (VisibleChatAttachment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toContextAttachment());
        }
        return (StateFlow)StateFlowKt.MutableStateFlow((Object)((List)destination$iv$iv));
    }

    @Override
    public void dump(@NotNull StringBuilder $this$dump, int headerLength) {
        Intrinsics.checkNotNullParameter((Object)$this$dump, (String)"<this>");
        ChatMessageDumpKt.dumpChatMessage($this$dump, this, headerLength);
    }

    public final long getTimestamp() {
        return this.timestamp;
    }
}

