/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.ide.BrowserUtil;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.NotificationsKt;
import com.intellij.ml.llm.core.chat.ui.LLMTrustedDomainsConfigurable;
import com.intellij.ml.llm.core.settings.LLMSettings;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0000\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"EXTERNAL_LINKS_DISABLED_IN_TEST", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEXTERNAL_LINKS_DISABLED_IN_TEST", "()Lcom/intellij/openapi/util/Key;", "isExternalLinksEnabled", "handleExternalLinkEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Ljavax/swing/event/HyperlinkEvent;", "openAiGeneratedLink", "url", "", "isTrustedUrl", "trustedDomains", "", "intellij.ml.llm.chat"})
public final class AIAssistantExternalLinksKt {
    @NotNull
    private static final Key<Boolean> EXTERNAL_LINKS_DISABLED_IN_TEST;

    @NotNull
    public static final Key<Boolean> getEXTERNAL_LINKS_DISABLED_IN_TEST() {
        return EXTERNAL_LINKS_DISABLED_IN_TEST;
    }

    public static final boolean isExternalLinksEnabled() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return !TestModeFlags.is(EXTERNAL_LINKS_DISABLED_IN_TEST);
        }
        return Registry.Companion.is("llm.chat.external.links.enabled");
    }

    public static final void handleExternalLinkEvent(@NotNull Project project, @NotNull HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ENTERED)) {
            e.getInputEvent().getComponent().setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.EXITED)) {
            e.getInputEvent().getComponent().setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        Object object = e.getURL();
        if (object == null || (object = ((URL)object).toString()) == null) {
            return;
        }
        Object url = object;
        AIAssistantExternalLinksKt.openAiGeneratedLink(project, (String)url);
    }

    public static final void openAiGeneratedLink(@NotNull Project project, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (AIAssistantExternalLinksKt.isExternalLinksEnabled()) {
            if (AIAssistantExternalLinksKt.isTrustedUrl(url)) {
                BrowserUtil.browse((String)url);
                return;
            }
            Object[] objectArray = new Object[]{url};
            String string = LLMBundle.message((String)"chat.externalLinks.dialog.message", (Object[])objectArray);
            objectArray = new String[]{LLMBundle.message((String)"chat.externalLinks.cancel.button.text", (Object[])new Object[0]), LLMBundle.message((String)"chat.externalLinks.copy.button.text", (Object[])new Object[0]), LLMBundle.message((String)"chat.externalLinks.configure.button.text", (Object[])new Object[0]), LLMBundle.message((String)"chat.externalLinks.open.button.text", (Object[])new Object[0])};
            int exitCode = MessagesService.showMessageDialog$default((MessagesService)MessagesService.Companion.getInstance(), (Project)project, null, (String)string, (String)LLMBundle.message((String)"chat.externalLinks.dialog.title", (Object[])new Object[0]), (String[])objectArray, (int)3, (int)-1, (Icon)UIUtil.getQuestionIcon(), null, (boolean)false, null, (int)1536, null);
            switch (exitCode) {
                case 1: {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(url));
                    break;
                }
                case 2: {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, LLMTrustedDomainsConfigurable.class);
                    break;
                }
                case 3: {
                    BrowserUtil.browse((String)url);
                }
            }
        } else if (AIAssistantExternalLinksKt.isTrustedUrl(url, LLMSettings.Companion.getDEFAULT_TRUSTED_DOMAINS())) {
            BrowserUtil.browse((String)url);
        } else {
            Notification notification = NotificationsKt.createNotificationGroup().createNotification(LLMBundle.message((String)"chat.externalLinks.disabled.notification", (Object[])new Object[0]), NotificationType.INFORMATION);
            notification.notify(project);
        }
    }

    private static final boolean isTrustedUrl(String url) {
        return AIAssistantExternalLinksKt.isTrustedUrl(url, LLMSettingsManager.Companion.getInstance().getTrustedDomains());
    }

    public static final boolean isTrustedUrl(@NotNull String url, @NotNull List<String> trustedDomains) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(trustedDomains, (String)"trustedDomains");
        for (String domain : trustedDomains) {
            if (StringsKt.isBlank((CharSequence)domain)) continue;
            char[] cArray = new char[]{'*'};
            List parts = StringsKt.split$default((CharSequence)domain, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 1) {
                return Intrinsics.areEqual(parts.get(0), (Object)url);
            }
            String escapedPattern = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)".*", null, null, (int)0, null, AIAssistantExternalLinksKt::isTrustedUrl$lambda$0, (int)30, null);
            Pattern pattern = Pattern.compile(escapedPattern);
            if (!pattern.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    private static final CharSequence isTrustedUrl$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Pattern.quote(it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return string;
    }

    static {
        Key key = Key.create((String)"llm.chat.external.links.enabled");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXTERNAL_LINKS_DISABLED_IN_TEST = key;
    }
}

