/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.find.FindResult;
import com.intellij.find.impl.livePreview.EditorLivePreviewPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.parts.CodePart;
import com.intellij.ml.llm.core.chat.parts.MessagePartTextListener;
import com.intellij.ml.llm.core.chat.snippets.CodeSnippetProviderKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantChatUtil;
import com.intellij.ml.llm.core.chat.ui.chat.AICodeGenerationInfo;
import com.intellij.ml.llm.core.chat.ui.chat.CodePartEditorInfo;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartView;
import com.intellij.ml.llm.core.chat.ui.chat.SearchableView;
import com.intellij.ml.llm.core.chat.ui.chat.parts.MessagePartViewContext;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeSnippetLanguage;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeViewerKt;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorFragment;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.StickyComponentHolder;
import com.intellij.ml.llm.persistenceBasedMetrics.ChatAiGeneratedSnippetCreationContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Component;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 12\u00020\u00012\u00020\u00022\u00020\u0003:\u00011B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u0004\u0018\u00010%J\b\u0010&\u001a\u00020\u0010H\u0002J\b\u0010'\u001a\u00020\u0016H\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/CodePartView;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/SearchableView;", "Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "part", "Lcom/intellij/ml/llm/core/chat/parts/CodePart;", "previous", "context", "Lcom/intellij/ml/llm/core/chat/ui/chat/parts/MessagePartViewContext;", "<init>", "(Lcom/intellij/ml/llm/core/chat/parts/CodePart;Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;Lcom/intellij/ml/llm/core/chat/ui/chat/parts/MessagePartViewContext;)V", "getPart", "()Lcom/intellij/ml/llm/core/chat/parts/CodePart;", "getPrevious", "()Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "editorInfo", "Lcom/intellij/ml/llm/core/chat/ui/chat/CodePartEditorInfo;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "accessibleName", "", "getAccessibleName", "()Ljava/lang/String;", "codeContent", "getCodeContent", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "writeContent", "md", "Ljava/io/StringWriter;", "html", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "updateOrCreateCodeView", "getTextContent", "applyHighlighting", "result", "Lcom/intellij/find/FindResult;", "isCurrentlySelected", "", "repaintHighlighting", "removeHighlightings", "getYOffset", "", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCodePartView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodePartView.kt\ncom/intellij/ml/llm/core/chat/ui/chat/CodePartView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n1869#3,2:195\n*S KotlinDebug\n*F\n+ 1 CodePartView.kt\ncom/intellij/ml/llm/core/chat/ui/chat/CodePartView\n*L\n182#1:195,2\n*E\n"})
public final class CodePartView
extends UserDataHolderBase
implements SearchableView,
MessagePartView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodePart part;
    @Nullable
    private final MessagePartView previous;
    @NotNull
    private final MessagePartViewContext context;
    @Nullable
    private CodePartEditorInfo editorInfo;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private static final Key<EditorFragment> editorFragmentKey;

    public CodePartView(@NotNull CodePart part, @Nullable MessagePartView previous, @NotNull MessagePartViewContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.part = part;
        this.previous = previous;
        this.context = context;
        boolean bl2 = bl = this.context.getParentDisposable() != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Parent disposable for code part must be not null";
            throw new AssertionError((Object)string);
        }
        Disposable disposable = this.context.getParentDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.highlighters = new ArrayList();
        this.getPart().addTextListener(new MessagePartTextListener(){

            @Override
            public void onTextChanged(String newText) {
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                if (editorInfo != null) {
                    this.updateOrCreateCodeView();
                }
            }
        });
    }

    @Override
    @NotNull
    public CodePart getPart() {
        return this.part;
    }

    @Override
    @Nullable
    public MessagePartView getPrevious() {
        return this.previous;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        Object object = this.editorInfo;
        if (object == null || (object = ((CodePartEditorInfo)object).getComponent()) == null) {
            object = this.updateOrCreateCodeView().getComponent();
        }
        return object;
    }

    @Override
    @NotNull
    public String getAccessibleName() {
        return LLMBundle.message((String)"chat.message.code.part.accessible.name", (Object[])new Object[0]);
    }

    @NotNull
    public final String getCodeContent() {
        Object object = this.editorInfo;
        if (object == null || (object = object.getCode()) == null || (object = (String)object.get()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    public void initialize() {
        if (this.editorInfo == null) {
            this.updateOrCreateCodeView();
        }
    }

    @Override
    public void writeContent(@NotNull StringWriter md, @NotNull StringWriter html) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        String htmlContent = null;
        if (this.editorInfo != null) {
            md.append("```" + AIAssistantChatUtil.INSTANCE.getMarkdownLanguageId(this.getPart().getCode().getCodeSnippetLanguage().getIntellijLanguage()) + "\n");
            md.append(((Object)StringsKt.trim((CharSequence)this.getPart().getCode().getText())).toString());
            md.append("\n```\n");
            htmlContent = QuickDocHighlightingHelper.getStyledCodeFragment((Project)this.context.getProject(), (Language)this.getPart().getCode().getCodeSnippetLanguage().getIntellijLanguage(), (String)this.getPart().getCode().getText());
            html.append("<pre><code>\n");
            html.append(htmlContent);
            html.append("\n</code></pre>\n");
        }
    }

    @Nullable
    public final EditorEx getEditor() {
        CodePartEditorInfo codePartEditorInfo = this.editorInfo;
        return codePartEditorInfo != null ? codePartEditorInfo.getEditor() : null;
    }

    private final CodePartEditorInfo updateOrCreateCodeView() {
        Object object = WriteIntentReadAction.compute(() -> CodePartView.updateOrCreateCodeView$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (CodePartEditorInfo)object;
    }

    @Override
    @NotNull
    public String getTextContent() {
        return this.getCodeContent();
    }

    @Override
    public void applyHighlighting(@NotNull FindResult result2, boolean isCurrentlySelected) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        CodePartEditorInfo codePartEditorInfo = this.editorInfo;
        if (codePartEditorInfo == null || (codePartEditorInfo = codePartEditorInfo.getEditor()) == null) {
            return;
        }
        CodePartEditorInfo editor = codePartEditorInfo;
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorLivePreviewPresentation preview = new EditorLivePreviewPresentation(editorColorsScheme);
        if (isCurrentlySelected) {
            TextAttributes textAttributes2;
            TextAttributes $this$applyHighlighting_u24lambda_u242 = textAttributes2 = preview.getCursorAttributes();
            boolean bl = false;
            $this$applyHighlighting_u24lambda_u242.setBackgroundColor(editor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            textAttributes = textAttributes2;
        } else {
            textAttributes = preview.getDefaultAttributes();
        }
        TextAttributes textAttributes3 = textAttributes;
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(result2.getStartOffset(), result2.getEndOffset(), preview.getDefaultLayer(), textAttributes3, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        CodePartView.applyHighlighting$expandEditor(this);
        this.highlighters.add(highlighter);
    }

    @Override
    public void repaintHighlighting(@NotNull FindResult result2, boolean isCurrentlySelected) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Iterable iterable = this.highlighters;
            for (Object t : iterable) {
                RangeHighlighter it = (RangeHighlighter)t;
                boolean bl = false;
                if (!(it.getStartOffset() == result2.getStartOffset() && it.getEndOffset() == result2.getEndOffset())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        RangeHighlighter rangeHighlighter = v0;
        if (rangeHighlighter == null) {
            throw new IllegalStateException("Repaint called on non-existing search result");
        }
        RangeHighlighter highlighter = rangeHighlighter;
        CodePartEditorInfo codePartEditorInfo = this.editorInfo;
        if (codePartEditorInfo == null || (codePartEditorInfo = codePartEditorInfo.getEditor()) == null || (codePartEditorInfo = codePartEditorInfo.getMarkupModel()) == null) {
            return;
        }
        CodePartEditorInfo markupModel = codePartEditorInfo;
        markupModel.removeHighlighter(highlighter);
        this.highlighters.remove(highlighter);
        this.applyHighlighting(result2, isCurrentlySelected);
    }

    @Override
    public void removeHighlightings() {
        CodePartEditorInfo codePartEditorInfo = this.editorInfo;
        if (codePartEditorInfo == null || (codePartEditorInfo = codePartEditorInfo.getEditor()) == null) {
            return;
        }
        CodePartEditorInfo editor = codePartEditorInfo;
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        Iterable $this$forEach$iv = this.highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter highlighter = (RangeHighlighter)element$iv;
            boolean bl = false;
            markupModel.removeHighlighter(highlighter);
        }
        this.highlighters.clear();
    }

    @Override
    public int getYOffset(@NotNull FindResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        EditorEx editorEx = this.getEditor();
        if (editorEx == null) {
            return 0;
        }
        EditorEx editor = editorEx;
        return editor.visualPositionToXY((VisualPosition)editor.offsetToVisualPosition((int)result2.getStartOffset())).y;
    }

    private static final CodePartEditorInfo updateOrCreateCodeView$lambda$1(CodePartView this$0) {
        CodePart.Code code = this$0.getPart().getCode();
        if (this$0.editorInfo == null) {
            CodePartEditorInfo editorInfo;
            Project project = this$0.context.getProject();
            GraphProperty graphProperty = new PropertyGraph(null, false, 3, null).property((Object)code.getText());
            Disposable disposable = this$0.context.getParentDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            CodeSnippetLanguage codeSnippetLanguage = code.getCodeSnippetLanguage();
            MarkdownChatMessage markdownChatMessage = this$0.getPart().getMessage();
            Intrinsics.checkNotNull((Object)markdownChatMessage, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage");
            this$0.editorInfo = editorInfo = CodeViewerKt.createCodeViewer(project, (GraphProperty<String>)graphProperty, disposable, codeSnippetLanguage, markdownChatMessage);
        } else {
            CodePartEditorInfo codePartEditorInfo = this$0.editorInfo;
            Intrinsics.checkNotNull((Object)codePartEditorInfo);
            if (!Intrinsics.areEqual((Object)codePartEditorInfo.getLanguage(), (Object)code.getCodeSnippetLanguage())) {
                CodePartEditorInfo codePartEditorInfo2 = this$0.editorInfo;
                Intrinsics.checkNotNull((Object)codePartEditorInfo2);
                codePartEditorInfo2.setLanguage(code.getCodeSnippetLanguage());
            }
            CodePartEditorInfo codePartEditorInfo3 = this$0.editorInfo;
            Intrinsics.checkNotNull((Object)codePartEditorInfo3);
            codePartEditorInfo3.getCode().set((Object)code.getText());
        }
        String parsedLanguage = this$0.getPart().getParsedLanguageId();
        if (parsedLanguage != null) {
            CodePartEditorInfo codePartEditorInfo = this$0.editorInfo;
            Intrinsics.checkNotNull((Object)codePartEditorInfo);
            codePartEditorInfo.getEditor().putUserData(AICodeGenerationInfo.Companion.getUSER_DATA_KEY(), (Object)new AICodeGenerationInfo(parsedLanguage, new ChatAiGeneratedSnippetCreationContext(this$0.getPart().getMessage().getChat().getUid(), this$0.getPart().getMessage().getUid(), this$0.getPart().getMessage().getChat().getCreationContext().getSourceActionForStatistic())));
        }
        if (((Boolean)this$0.getPart().isCompleted().getValue()).booleanValue()) {
            Project project = this$0.context.getProject();
            CodePartEditorInfo codePartEditorInfo = this$0.editorInfo;
            Intrinsics.checkNotNull((Object)codePartEditorInfo);
            CodeSnippetProviderKt.finalizeEditorForChatCodeSnippet(project, (Editor)codePartEditorInfo.getEditor());
        }
        CodePartEditorInfo codePartEditorInfo = this$0.editorInfo;
        Intrinsics.checkNotNull((Object)codePartEditorInfo);
        return codePartEditorInfo;
    }

    private static final void applyHighlighting$expandEditor(CodePartView this$0) {
        block2: {
            Object object;
            Object object2;
            EditorFragment fragment;
            EditorEx editorEx = this$0.getEditor();
            EditorFragment editorFragment = fragment = editorEx != null ? (EditorFragment)editorEx.getUserData(editorFragmentKey) : null;
            if (editorFragment != null) {
                editorFragment.setCollapsed(false);
            }
            if ((object2 = fragment) != null && (object2 = ((StickyComponentHolder)object2).getComponent()) != null) {
                ((JComponent)object2).revalidate();
            }
            if ((object = fragment) == null || (object = ((StickyComponentHolder)object).getComponent()) == null) break block2;
            ((Component)object).repaint();
        }
    }

    static {
        Key key = Key.create((String)"editor.code.fragment.key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        editorFragmentKey = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/CodePartView$Companion;", "", "<init>", "()V", "editorFragmentKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFragment;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEditorFragmentKey$intellij_ml_llm_chat", "()Lcom/intellij/openapi/util/Key;", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<EditorFragment> getEditorFragmentKey$intellij_ml_llm_chat() {
            return editorFragmentKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

