/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.ChatMessageKt;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantDimensions;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatMessageAttachmentView;
import com.intellij.ml.llm.core.chat.ui.chat.context.CollapsibleTitle;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.openapi.Disposable;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatMessageAttachmentView;", "Ljavax/swing/JPanel;", "text", "", "author", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "expanded", "", "disposable", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;ZLcom/intellij/openapi/Disposable;Lkotlinx/coroutines/CoroutineScope;)V", "chatMessage", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "bgColor", "Ljava/awt/Color;", "setChatMessage", "", "message", "drawAttachments", "attachments", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "intellij.ml.llm.chat"})
public final class AIChatMessageAttachmentView
extends JPanel {
    @NotNull
    private final String text;
    @NotNull
    private final ChatMessageAuthor author;
    private final boolean expanded;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final CoroutineScope scope;
    private MarkdownChatMessage chatMessage;
    @Nullable
    private final Color bgColor;

    public AIChatMessageAttachmentView(@NotNull String text2, @NotNull ChatMessageAuthor author, boolean expanded, @NotNull Disposable disposable, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(new GridBagLayout());
        this.text = text2;
        this.author = author;
        this.expanded = expanded;
        this.disposable = disposable;
        this.scope = scope;
        this.bgColor = AIAssistantColors.INSTANCE.getMessageBackground(this.author);
        this.setOpaque(false);
        if (this.author == ChatMessageAuthor.User) {
            this.setBorder((Border)JBUI.Borders.empty((int)AIAssistantDimensions.INSTANCE.userAttachmentDropdownTopVerticalSpacing(), (int)0, (int)AIAssistantDimensions.INSTANCE.userAttachmentDropdownBottomVerticalSpacing(), (int)0));
        } else {
            this.setBorder((Border)JBUI.Borders.empty());
        }
        this.getAccessibleContext().setAccessibleName(LLMBundle.message((String)"chat.message.context.attachments.accessible.name", (Object[])new Object[0]));
    }

    public final void setChatMessage(@NotNull MarkdownChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.chatMessage = message;
        UiScopeKt.launchOnShow$default((Component)this, (String)"Context attachments scope", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AIChatMessageAttachmentView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        MarkdownChatMessage markdownChatMessage = AIChatMessageAttachmentView.access$getChatMessage$p(this.this$0);
                        if (markdownChatMessage == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
                            markdownChatMessage = null;
                        }
                        this.label = 1;
                        Object object2 = markdownChatMessage.getContextFlow().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ AIChatMessageAttachmentView this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(Iterable<? extends ContextEntity> contextEntities, Continuation<? super Unit> $completion) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                void $this$filterIsInstanceTo$iv$iv;
                                Iterable $this$filterIsInstance$iv = contextEntities;
                                boolean $i$f$filterIsInstance = false;
                                Iterable iterable = $this$filterIsInstance$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterIsInstanceTo = false;
                                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                    if (!(element$iv$iv instanceof ContextAttachment)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filterIsInstance$iv = (List)destination$iv$iv;
                                boolean $i$f$filter = false;
                                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    ContextAttachment it = (ContextAttachment)element$iv$iv;
                                    boolean bl = false;
                                    if (!((Boolean)it.isVisible().get()).booleanValue()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                List attachments = (List)destination$iv$iv;
                                switch (setChatMessage.WhenMappings.$EnumSwitchMapping$0[AIChatMessageAttachmentView.access$getAuthor$p(this.this$0).ordinal()]) {
                                    case 1: {
                                        Iterable $this$filterNotTo$iv$iv;
                                        Iterable $this$filterNot$iv = attachments;
                                        boolean $i$f$filterNot = false;
                                        Iterable iterable2 = $this$filterNot$iv;
                                        Collection destination$iv$iv2 = new ArrayList<E>();
                                        boolean $i$f$filterNotTo = false;
                                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                            ContextAttachment it = (ContextAttachment)element$iv$iv;
                                            boolean bl = false;
                                            if (ChatMessageKt.isAutomaticallyCollected(it)) continue;
                                            destination$iv$iv2.add(element$iv$iv);
                                        }
                                        List userAttachments = (List)destination$iv$iv2;
                                        AIChatMessageAttachmentView.access$drawAttachments(this.this$0, userAttachments);
                                        break;
                                    }
                                    case 2: {
                                        void $this$filterTo$iv$iv2;
                                        Iterable $this$filter$iv2 = attachments;
                                        boolean $i$f$filter2 = false;
                                        Iterable $this$filterNotTo$iv$iv = $this$filter$iv2;
                                        Collection destination$iv$iv2 = new ArrayList<E>();
                                        boolean $i$f$filterTo2 = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv2) {
                                            ContextAttachment it = (ContextAttachment)element$iv$iv;
                                            boolean bl = false;
                                            if (!ChatMessageKt.isAutomaticallyCollected(it)) continue;
                                            destination$iv$iv2.add(element$iv$iv);
                                        }
                                        List automaticAttachments = (List)destination$iv$iv2;
                                        AIChatMessageAttachmentView.access$drawAttachments(this.this$0, automaticAttachments);
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void drawAttachments(List<? extends ContextAttachment> attachments) {
        if (!((Collection)attachments).isEmpty()) {
            GridBagConstraints gridBagConstraints;
            JBEmptyBorder jBEmptyBorder = this.author == ChatMessageAuthor.User ? JBUI.Borders.empty() : JBUI.Borders.empty((int)5, (int)0);
            Intrinsics.checkNotNull((Object)jBEmptyBorder);
            JBEmptyBorder border = jBEmptyBorder;
            CollapsibleTitle panel2 = new CollapsibleTitle(this.text + " " + attachments.size(), this.bgColor, this.expanded, attachments, border, this.disposable, this.scope);
            GridBagConstraints $this$drawAttachments_u24lambda_u240 = gridBagConstraints = new GridBagConstraints();
            boolean bl = false;
            $this$drawAttachments_u24lambda_u240.fill = 2;
            $this$drawAttachments_u24lambda_u240.weightx = 1.0;
            GridBagConstraints gbc = gridBagConstraints;
            this.removeAll();
            this.add((Component)panel2, gbc);
        }
    }

    public static final /* synthetic */ MarkdownChatMessage access$getChatMessage$p(AIChatMessageAttachmentView $this) {
        return $this.chatMessage;
    }

    public static final /* synthetic */ ChatMessageAuthor access$getAuthor$p(AIChatMessageAttachmentView $this) {
        return $this.author;
    }

    public static final /* synthetic */ void access$drawAttachments(AIChatMessageAttachmentView $this, List attachments) {
        $this.drawAttachments(attachments);
    }
}

