/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.RelatedCodeChatAttachmentWithFile;
import com.intellij.ml.llm.core.chat.context.traverser.ChatAttachmentWithSourcePosition;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013BD\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u0012\u0006\u0010\n\u001a\u00020\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010)\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001f\u0010\u0019\u001a\r\u0012\u0004\u0012\u00020\u00160\u001a\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001f\u0010\u001d\u001a\r\u0012\u0004\u0012\u00020\u00160\u001a\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0019\u0010\u001f\u001a\u00070\b\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001c\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/RelatedCodeWithFileContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "psiItem", "Lcom/intellij/ide/actions/searcheverywhere/PSIPresentationBgRendererWrapper$PsiItemWithPresentation;", "psName", "Lcom/intellij/ml/llm/privacy/PSString;", "Lcom/intellij/openapi/util/NlsSafe;", "psText", "virtualFilePointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "attachedBy", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/actions/searcheverywhere/PSIPresentationBgRendererWrapper$PsiItemWithPresentation;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAttachedBy", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "Companion", "intellij.ml.llm.chat"})
public class RelatedCodeWithFileContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final PSIPresentationBgRendererWrapper.PsiItemWithPresentation psiItem;
    @NotNull
    private final PSString psName;
    @NotNull
    private final PSString psText;
    @Nullable
    private final VirtualFilePointer virtualFilePointer;
    @NotNull
    private final ContextAttachmentSource attachedBy;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<String> name;
    @NotNull
    private final ObservableProperty<String> hint;
    @NotNull
    private final ObservableProperty<Icon> icon;

    public RelatedCodeWithFileContextAttachment(@NotNull Project project, @Nullable PSIPresentationBgRendererWrapper.PsiItemWithPresentation psiItem, @NotNull PSString psName, @NotNull PSString psText, @Nullable VirtualFilePointer virtualFilePointer, @NotNull ContextAttachmentSource attachedBy) {
        VirtualFilePointer virtualFilePointer2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psName, (String)"psName");
        Intrinsics.checkNotNullParameter((Object)psText, (String)"psText");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.project = project;
        this.psiItem = psiItem;
        this.psName = psName;
        this.psText = psText;
        this.virtualFilePointer = virtualFilePointer;
        this.attachedBy = attachedBy;
        this.id = String.valueOf(("" + this.psText.unwrap() + this.virtualFilePointer).hashCode());
        Object object = this.psiItem;
        if (object == null || (object = object.getPresentation()) == null || (object = object.getPresentableText()) == null) {
            VirtualFile virtualFile2 = this.virtualFile();
            object = virtualFile2 != null ? virtualFile2.getName() : null;
            if (object == null) {
                object = (String)this.psName.unwrap();
            }
        }
        this.name = (ObservableProperty)new AtomicProperty(object);
        this.hint = (ObservableProperty)new AtomicProperty((Object)"");
        Object object2 = this.psiItem;
        if ((object2 == null || (object2 = object2.getPresentation()) == null || (object2 = object2.getIcon()) == null) && ((virtualFilePointer2 = this.virtualFilePointer) != null && (virtualFilePointer2 = virtualFilePointer2.getFile()) != null && (virtualFilePointer2 = virtualFilePointer2.getFileType()) != null ? virtualFilePointer2.getIcon() : (object2 = null)) == null) {
            Icon icon = AllIcons.FileTypes.Custom;
            object2 = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Custom");
        }
        this.icon = (ObservableProperty)new AtomicProperty(object2);
    }

    public /* synthetic */ RelatedCodeWithFileContextAttachment(Project project, PSIPresentationBgRendererWrapper.PsiItemWithPresentation psiItemWithPresentation, PSString pSString, PSString pSString2, VirtualFilePointer virtualFilePointer, ContextAttachmentSource contextAttachmentSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            virtualFilePointer = null;
        }
        if ((n & 0x20) != 0) {
            contextAttachmentSource = ContextAttachmentSource.Other.INSTANCE;
        }
        this(project, psiItemWithPresentation, pSString, pSString2, virtualFilePointer, contextAttachmentSource);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public ContextAttachmentSource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.psText;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return (String)this.psName.unwrap();
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return (String)this.psName.unwrap();
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return RelatedCodeWithFileContextAttachment.createChatAttachment$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object createChatAttachment$suspendImpl(RelatedCodeWithFileContextAttachment $this, Continuation<? super ChatAttachment> $completion) {
        return new RelatedCodeChatAttachmentWithFile($this.psName, $this.psText, ChatAttachment.Kind.Visible, $this.virtualFilePointer, $this.getProject(), $this.psiItem, $this.getAttachedBy());
    }

    @Override
    public void performAction(boolean isInMessage) {
        PSIPresentationBgRendererWrapper.PsiItemWithPresentation file;
        Object object = this.psiItem;
        if (object == null || (object = (PsiElement)object.getItem()) == null || (object = object.getContainingFile()) == null || (object = object.getVirtualFile()) == null) {
            VirtualFilePointer virtualFilePointer = this.virtualFilePointer;
            object = virtualFilePointer != null ? virtualFilePointer.getFile() : null;
            if (object == null) {
                object = (VirtualFile)new LightVirtualFile((String)this.psName.unwrap(), this.psText.unwrap());
            }
        }
        if ((file = object).isValid()) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.getProject()).openFile((VirtualFile)file, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            Object object2 = ArraysKt.firstOrNull((Object[])fileEditorArray);
            TextEditor textEditor = object2 instanceof TextEditor ? (TextEditor)object2 : null;
            TextEditor textEditor2 = textEditor;
            if (textEditor2 == null || (textEditor2 = textEditor2.getEditor()) == null) {
                return;
            }
            TextEditor editor = textEditor2;
            if (this.psiItem != null && ((PsiElement)this.psiItem.getItem()).isValid() && Intrinsics.areEqual((Object)((PsiElement)this.psiItem.getItem()).getContainingFile().getVirtualFile(), (Object)file)) {
                editor.getCaretModel().moveToOffset(((PsiElement)this.psiItem.getItem()).getTextOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    @Override
    @Nullable
    public VirtualFile virtualFile() {
        VirtualFilePointer virtualFilePointer = this.virtualFilePointer;
        return virtualFilePointer != null ? virtualFilePointer.getFile() : null;
    }

    @NotNull
    public String toString() {
        return "RelatedCodeWithFileContextAttachment(" + this.psName + ", by=" + this.getAttachedBy().getName() + ", id='" + this.getId() + "')";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/RelatedCodeWithFileContextAttachment$Companion;", "", "<init>", "()V", "createFromPsiElement", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/RelatedCodeWithFileContextAttachment;", "psiElement", "Lcom/intellij/psi/PsiElement;", "attachedBy", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource;", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RelatedCodeWithFileContextAttachment createFromPsiElement(@NotNull PsiElement psiElement, @NotNull ContextAttachmentSource attachedBy) {
            LightFilePointer lightFilePointer;
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
            PSIPresentationBgRendererWrapper.PsiItemWithPresentation psiItemWithPresentation = ChatAttachmentWithSourcePosition.Companion.findClosestParentWithPresentation$intellij_ml_llm_chat(psiElement);
            if (psiItemWithPresentation == null) {
                return null;
            }
            PSIPresentationBgRendererWrapper.PsiItemWithPresentation psiWithPresentation = psiItemWithPresentation;
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile != null) {
                String string = containingFile.getViewProvider().getVirtualFile().getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                lightFilePointer = new LightFilePointer(string);
            } else {
                lightFilePointer = null;
            }
            LightFilePointer virtualFilePointer = lightFilePointer;
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            TargetPresentation targetPresentation = psiWithPresentation.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"getPresentation(...)");
            PSString pSString = SharedExtensionsKtKt.getPrivacySafe((TargetPresentation)targetPresentation).getPresentableText();
            Object object = psiWithPresentation.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
            PSString pSString2 = ExtensionsKtKt.getPrivacySafe((PsiElement)((PsiElement)object)).getText();
            return new RelatedCodeWithFileContextAttachment(project2, psiWithPresentation, pSString, pSString2, (VirtualFilePointer)virtualFilePointer, attachedBy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

