/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.modelSelector;

import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.ui.ChatModelPopupElement;
import com.intellij.ml.llm.core.chat.ui.chat.modelSelector.AIAssistantChatModelSelectorKt;
import com.intellij.ml.llm.core.chat.ui.popup.BaseDetailsComponent;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileIDUtils;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0016\u0010\u001c\u001a\u00020\u0017*\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u0013H\u0002J\u001e\u0010\u001f\u001a\u00020\u0017*\u00020\u001d2\u0006\u0010 \u001a\u00020!2\b\b\u0001\u0010\u001e\u001a\u00020\u0013H\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent;", "Lcom/intellij/ml/llm/core/chat/ui/popup/BaseDetailsComponent;", "Lcom/intellij/ml/llm/core/chat/ui/ChatModelPopupElement$Model;", "list", "Ljavax/swing/JList;", "Lcom/intellij/ml/llm/core/chat/ui/ChatModelPopupElement;", "submenu", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ui/popup/WizardPopup;", "<init>", "(Ljavax/swing/JList;Ljava/util/concurrent/atomic/AtomicReference;)V", "extractTooltipData", "listElement", "", "shouldShowTooltip", "", "data", "shouldCreatePopup", "getDisplayName", "", "createTooltipContent", "Ljavax/swing/JComponent;", "onTooltipShown", "", "createDescriptionPanel", "descriptions", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem;", "addDescription", "Ljavax/swing/JPanel;", "text", "addDescriptionWithIcon", "icon", "Ljavax/swing/Icon;", "DescriptionItem", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nModelDetailsComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelDetailsComponent.kt\ncom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1869#2,2:126\n1#3:128\n*S KotlinDebug\n*F\n+ 1 ModelDetailsComponent.kt\ncom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent\n*L\n84#1:126,2\n*E\n"})
public final class ModelDetailsComponent
extends BaseDetailsComponent<ChatModelPopupElement.Model> {
    @NotNull
    private final AtomicReference<WizardPopup> submenu;

    public ModelDetailsComponent(@NotNull JList<? super ChatModelPopupElement> list, @NotNull AtomicReference<WizardPopup> submenu) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(submenu, (String)"submenu");
        this.submenu = submenu;
        this.install(list);
    }

    @Override
    @Nullable
    protected ChatModelPopupElement.Model extractTooltipData(@NotNull Object listElement) {
        Intrinsics.checkNotNullParameter((Object)listElement, (String)"listElement");
        return listElement instanceof ChatModelPopupElement.Model ? (ChatModelPopupElement.Model)listElement : null;
    }

    @Override
    protected boolean shouldShowTooltip(@NotNull ChatModelPopupElement.Model data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return true;
    }

    @Override
    protected boolean shouldCreatePopup() {
        return this.submenu.get() == null;
    }

    @Override
    @NotNull
    protected String getDisplayName(@NotNull ChatModelPopupElement.Model data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return AiaLlmProfileIDUtils.INSTANCE.isAuto(AiaLlmProfileIDUtils.INSTANCE.fromString(data2.getModel().getId())) ? LLMBundle.message((String)"chat.model.chooser.auto.tooltip.title", (Object[])new Object[0]) : data2.getModel().getDisplayName();
    }

    @Override
    @Nullable
    protected JComponent createTooltipContent(@NotNull ChatModelPopupElement.Model data2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List $this$createTooltipContent_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (AiaLlmProfileIDUtils.INSTANCE.isAuto(AiaLlmProfileIDUtils.INSTANCE.fromString(data2.getModel().getId()))) {
            $this$createTooltipContent_u24lambda_u240.add(new DescriptionItem.TextOnly(LLMBundle.message((String)"chat.model.chooser.auto.tooltip.description.text", (Object[])new Object[0])));
        } else {
            if (AIAssistantChatModelSelectorKt.isThinking(data2.getModel())) {
                Icon icon = MLLlmIcons.Chat.Model.Brain;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Brain");
                $this$createTooltipContent_u24lambda_u240.add(new DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.thinking.description.text", (Object[])new Object[0])));
            }
            if (AIAssistantChatModelSelectorKt.isExpensive(data2.getModel())) {
                Icon icon = MLLlmIcons.Chat.Model.Ruby;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ruby");
                $this$createTooltipContent_u24lambda_u240.add(new DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.expensive.description.text", (Object[])new Object[0])));
            }
            if (AIAssistantChatModelSelectorKt.isBeta(data2.getModel())) {
                $this$createTooltipContent_u24lambda_u240.add(new DescriptionItem.TextOnly(LLMBundle.message((String)"chat.model.chooser.beta.description.text", (Object[])new Object[0])));
            }
            if (AiaLlmProfileIDUtils.INSTANCE.supportsImages(AiaLlmProfileIDUtils.INSTANCE.fromString(data2.getModel().getId()))) {
                Icon icon = MLLlmIcons.Chat.Model.Image_grey;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Image_grey");
                $this$createTooltipContent_u24lambda_u240.add(new DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.support.image.text", (Object[])new Object[0])));
            }
        }
        List descriptions = CollectionsKt.build((List)list);
        return this.createDescriptionPanel(descriptions);
    }

    @Override
    protected void onTooltipShown(@NotNull ChatModelPopupElement.Model data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        AIAssistantChatEventLogger.logChatModelSelectorTooltipIsShown(data2.getModel().getId());
    }

    private final JComponent createDescriptionPanel(List<? extends DescriptionItem> descriptions) {
        if (descriptions.isEmpty()) {
            return null;
        }
        JPanel panel2 = CollaborationToolsUIUtilKt.VerticalListPanel((int)0);
        Iterable $this$forEach$iv = descriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DescriptionItem item = (DescriptionItem)element$iv;
            boolean bl = false;
            DescriptionItem descriptionItem = item;
            if (descriptionItem instanceof DescriptionItem.TextOnly) {
                this.addDescription(panel2, ((DescriptionItem.TextOnly)item).getText());
                continue;
            }
            if (descriptionItem instanceof DescriptionItem.WithIcon) {
                this.addDescriptionWithIcon(panel2, ((DescriptionItem.WithIcon)item).getIcon(), ((DescriptionItem.WithIcon)item).getText());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return (JComponent)new BorderLayoutPanel(panel2){
            {
                this.setOpaque(false);
                this.addToCenter($panel);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return (Dimension)new JBDimension(210, dimension != null ? dimension.height : 0);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void addDescription(JPanel $this$addDescription, @NlsContexts.Label String text2) {
        void $this$addDescription_u24lambda_u242;
        JBLabel jBLabel;
        JBLabel jBLabel2 = jBLabel = new JBLabel(text2);
        JPanel jPanel = $this$addDescription;
        boolean bl = false;
        $this$addDescription_u24lambda_u242.setForeground((Color)JBColor.namedColor((String)"ToolTip.infoForeground", (Color)JBUI.CurrentTheme.ContextHelp.FOREGROUND));
        jPanel.add((Component)jBLabel);
    }

    /*
     * WARNING - void declaration
     */
    private final void addDescriptionWithIcon(JPanel $this$addDescriptionWithIcon, Icon icon, @NlsContexts.Label String text2) {
        void $this$addDescriptionWithIcon_u24lambda_u245_u24lambda_u244;
        Wrapper $this$addDescriptionWithIcon_u24lambda_u245_u24lambda_u243;
        Wrapper wrapper;
        void $this$addDescriptionWithIcon_u24lambda_u245;
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        JPanel jPanel = $this$addDescriptionWithIcon;
        boolean bl = false;
        $this$addDescriptionWithIcon_u24lambda_u245.setBackground(JBUI.CurrentTheme.Tooltip.background());
        Wrapper wrapper2 = wrapper = new Wrapper((JComponent)new JBLabel(icon));
        void var9_10 = $this$addDescriptionWithIcon_u24lambda_u245;
        boolean bl2 = false;
        $this$addDescriptionWithIcon_u24lambda_u245_u24lambda_u243.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        var9_10.addToLeft((Component)wrapper);
        $this$addDescriptionWithIcon_u24lambda_u245_u24lambda_u243 = wrapper = new JBLabel(text2);
        var9_10 = $this$addDescriptionWithIcon_u24lambda_u245;
        boolean bl3 = false;
        $this$addDescriptionWithIcon_u24lambda_u245_u24lambda_u244.setForeground((Color)JBColor.namedColor((String)"ToolTip.infoForeground", (Color)JBUI.CurrentTheme.ContextHelp.FOREGROUND));
        var9_10.addToCenter((Component)wrapper);
        jPanel.add((Component)borderLayoutPanel);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem;", "", "<init>", "()V", "TextOnly", "WithIcon", "Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem$TextOnly;", "Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem$WithIcon;", "intellij.ml.llm.chat"})
    public static abstract class DescriptionItem {
        private DescriptionItem() {
        }

        public /* synthetic */ DescriptionItem(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem$TextOnly;", "Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
        public static final class TextOnly
        extends DescriptionItem {
            @NotNull
            private final String text;

            public TextOnly(@NlsContexts.Label @NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(null);
                this.text = text2;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final TextOnly copy(@NlsContexts.Label @NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new TextOnly(text2);
            }

            public static /* synthetic */ TextOnly copy$default(TextOnly textOnly, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = textOnly.text;
                }
                return textOnly.copy(string);
            }

            @NotNull
            public String toString() {
                return "TextOnly(text=" + this.text + ")";
            }

            public int hashCode() {
                return this.text.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextOnly)) {
                    return false;
                }
                TextOnly textOnly = (TextOnly)other;
                return Intrinsics.areEqual((Object)this.text, (Object)textOnly.text);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem$WithIcon;", "Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent$DescriptionItem;", "icon", "Ljavax/swing/Icon;", "text", "", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
        public static final class WithIcon
        extends DescriptionItem {
            @NotNull
            private final Icon icon;
            @NotNull
            private final String text;

            public WithIcon(@NotNull Icon icon, @NlsContexts.Label @NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(null);
                this.icon = icon;
                this.text = text2;
            }

            @NotNull
            public final Icon getIcon() {
                return this.icon;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final Icon component1() {
                return this.icon;
            }

            @NotNull
            public final String component2() {
                return this.text;
            }

            @NotNull
            public final WithIcon copy(@NotNull Icon icon, @NlsContexts.Label @NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new WithIcon(icon, text2);
            }

            public static /* synthetic */ WithIcon copy$default(WithIcon withIcon, Icon icon, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    icon = withIcon.icon;
                }
                if ((n & 2) != 0) {
                    string = withIcon.text;
                }
                return withIcon.copy(icon, string);
            }

            @NotNull
            public String toString() {
                return "WithIcon(icon=" + this.icon + ", text=" + this.text + ")";
            }

            public int hashCode() {
                int result2 = this.icon.hashCode();
                result2 = result2 * 31 + this.text.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WithIcon)) {
                    return false;
                }
                WithIcon withIcon = (WithIcon)other;
                if (!Intrinsics.areEqual((Object)this.icon, (Object)withIcon.icon)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.text, (Object)withIcon.text);
            }
        }
    }
}

