/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.selection;

import com.intellij.ml.llm.core.chat.ui.chat.HtmlToMarkdownConverterKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectChatProcessor;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectChatProcessorKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectUtilsKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectViewProcessor;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectViewProcessorKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageView;
import com.intellij.ml.llm.core.chat.ui.chat.selection.PartsImporterAsFakeClipboard;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002$,\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020'H\u0002J\u0006\u0010.\u001a\u00020\"J\u0018\u00101\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001dH\u0002J\u000e\u00105\u001a\u00020\"2\u0006\u00102\u001a\u000203J\u000e\u00106\u001a\u00020\"2\u0006\u00102\u001a\u000203J\u0006\u00107\u001a\u00020\u001dJ&\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u001dJ\u0006\u0010>\u001a\u00020\u001dJ\u0016\u0010?\u001a\u00020\"2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J\u0006\u0010A\u001a\u00020\u001dJ\u000e\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020\u001dJ\u0006\u0010D\u001a\u00020EJ\u000e\u00101\u001a\u00020\"2\u0006\u00104\u001a\u00020\u001dJ\u0006\u0010G\u001a\u00020\u001dJ\u000e\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u001dJ\u0016\u0010J\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020'2\u0006\u0010L\u001a\u00020MJ\u0010\u0010N\u001a\u00020\"2\b\b\u0002\u0010O\u001a\u00020\u001dJ\b\u0010P\u001a\u00020\"H\u0002JH\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020M2\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u001b2\u0006\u0010Y\u001a\u00020\u001b2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020WH\u0002J0\u0010]\u001a\u00020\"2\u0006\u0010K\u001a\u00020'2\u0006\u0010R\u001a\u00020M2\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010^\u001a\u00020\u001d2\u0006\u0010Z\u001a\u00020[H\u0002J\u0006\u0010_\u001a\u00020\u001dJ\u0006\u0010`\u001a\u00020\u001dJ\u0015\u0010a\u001a\u00020\"2\u0006\u0010b\u001a\u00020UH\u0000\u00a2\u0006\u0002\bcJ\u0006\u0010d\u001a\u00020\"J\u0014\u0010e\u001a\u00020\"2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\"0gJ\u0016\u0010h\u001a\u00020\"2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\"0gH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010-R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor;", "", "messageView", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageView;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageView;)V", "getMessageView", "()Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageView;", "setMessageView", "customSelectAll", "Lcom/intellij/openapi/actionSystem/AnAction;", "getCustomSelectAll", "()Lcom/intellij/openapi/actionSystem/AnAction;", "customSelectAll$delegate", "Lkotlin/Lazy;", "customCancelSelection", "getCustomCancelSelection", "customCancelSelection$delegate", "customCopySelection", "getCustomCopySelection", "customCopySelection$delegate", "aiMessagesContainer", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectChatProcessor;", "getAiMessagesContainer", "()Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectChatProcessor;", "aiMessagesContainer$delegate", "scrollBlocked", "", "scrollUnblocked", "", "repaintBlocked", "needRepaint", "showFocusableStatus", "updateVisibilityOfMessageFocusedStatus", "", "focusProcessor", "com/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor$focusProcessor$1", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor$focusProcessor$1;", "lastLeftMousePressedEvent", "Ljava/awt/event/MouseEvent;", "dragByPrimaryMouseButton", "isInternalEvent", "e", "mouseProcessor", "com/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor$mouseProcessor$1", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor$mouseProcessor$1;", "setupGroupSelectionDetector", "copyPopupHandler", "Ljava/awt/event/MouseListener;", "redirectMouseProcessingToMessageContainer", "component", "Ljava/awt/Component;", "redirect", "addPart", "removePart", "hasSelectedText", "writeContent", "md", "Ljava/io/StringWriter;", "html", "copyWithHeaderAndFooter", "copyOnlySelectedText", "isAllTextSelected", "writeSelectedContent", "messageSelected", "isMessageSelected", "setMessageSelected", "selected", "getMessageComponent", "Ljavax/swing/JComponent;", "innerSelected", "isInnerSelected", "setMessageInnerSelected", "selectedInside", "processMouseInternalDraggedSelectionAndCheckMouseInsideParts", "dragEvent", "dragSourceEditor", "Ljavax/swing/text/JTextComponent;", "dropSelectionInAllParts", "dropSelectionInFocused", "repaintBackground", "updateSelectionInExternalPart", "editorPane", "selectionUpFromSourceEditor", "partBoundsInMessage", "Ljava/awt/Rectangle;", "mousePosInMessage", "Ljava/awt/Point;", "upperSourceBound", "downSourceBound", "document", "Ljavax/swing/text/Document;", "inEditorMousePos", "fixSelectionInStarterPart", "selectionDownFromSourceEditor", "canShowFocusableStatus", "canScroll", "doScrollRectToVisible", "rect", "doScrollRectToVisible$intellij_ml_llm_chat", "selectAllText", "doWithoutScrollChange", "action", "Lkotlin/Function0;", "doPostponedBackgroundRepaint", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIMessageSelectViewProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIMessageSelectViewProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,852:1\n1869#2,2:853\n*S KotlinDebug\n*F\n+ 1 AIMessageSelectViewProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor\n*L\n362#1:853,2\n*E\n"})
public final class AIMessageSelectViewProcessor {
    @NotNull
    private AIMessageView messageView;
    @NotNull
    private final Lazy customSelectAll$delegate;
    @NotNull
    private final Lazy customCancelSelection$delegate;
    @NotNull
    private final Lazy customCopySelection$delegate;
    @NotNull
    private final Lazy aiMessagesContainer$delegate;
    private int scrollBlocked;
    private boolean scrollUnblocked;
    private int repaintBlocked;
    private boolean needRepaint;
    private boolean showFocusableStatus;
    @NotNull
    private focusProcessor.1 focusProcessor;
    @Nullable
    private MouseEvent lastLeftMousePressedEvent;
    private boolean dragByPrimaryMouseButton;
    @NotNull
    private mouseProcessor.1 mouseProcessor;
    @NotNull
    private final MouseListener copyPopupHandler;
    private boolean messageSelected;
    private boolean innerSelected;

    public AIMessageSelectViewProcessor(@NotNull AIMessageView messageView) {
        Intrinsics.checkNotNullParameter((Object)messageView, (String)"messageView");
        this.messageView = messageView;
        this.customSelectAll$delegate = LazyKt.lazy(AIMessageSelectViewProcessor::customSelectAll_delegate$lambda$0);
        this.customCancelSelection$delegate = LazyKt.lazy(AIMessageSelectViewProcessor::customCancelSelection_delegate$lambda$1);
        this.customCopySelection$delegate = LazyKt.lazy(AIMessageSelectViewProcessor::customCopySelection_delegate$lambda$2);
        this.aiMessagesContainer$delegate = LazyKt.lazy(() -> AIMessageSelectViewProcessor.aiMessagesContainer_delegate$lambda$3(this));
        this.focusProcessor = new FocusListener(this){
            final /* synthetic */ AIMessageSelectViewProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                boolean traversalEvent = AIMessageSelectViewProcessorKt.access$isTraversalEvent(e);
                AIMessageSelectViewProcessor.access$setShowFocusableStatus$p(this.this$0, traversalEvent);
                Component component = e.getComponent();
                if (component instanceof JTextComponent) {
                    if (traversalEvent) {
                        AIMessageSelectViewProcessorKt.access$safeSetCaretVisibleInEditor((JTextComponent)component, true);
                        Caret caret = ((JTextComponent)component).getCaret();
                        try {
                            Rectangle2D caretLocation = ((JTextComponent)component).modelToView2D(caret.getDot());
                            if (caretLocation != null) {
                                Rectangle caretBounds = caretLocation.getBounds();
                                JComponent messageComponent = this.this$0.getMessageComponent();
                                Rectangle converted = SwingUtilities.convertRectangle(component, caretBounds, messageComponent);
                                messageComponent.scrollRectToVisible(converted);
                            }
                        }
                        catch (BadLocationException ignore) {
                            ((JTextComponent)component).scrollRectToVisible(new Rectangle(0, 0, ((JTextComponent)component).getWidth(), ((JTextComponent)component).getHeight()));
                        }
                    } else {
                        this.this$0.doWithoutScrollChange((Function0<Unit>)((Function0)() -> focusProcessor.1.focusGained$lambda$0(component)));
                    }
                }
                AIMessageSelectViewProcessor.access$updateVisibilityOfMessageFocusedStatus(this.this$0);
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AIMessageSelectViewProcessor.access$setShowFocusableStatus$p(this.this$0, false);
                Component component = e.getComponent();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).getCaret().setSelectionVisible(true);
                    AIMessageSelectViewProcessorKt.access$safeSetCaretVisibleInEditor((JTextComponent)component, false);
                }
                AIMessageSelectViewProcessor.access$updateVisibilityOfMessageFocusedStatus(this.this$0);
            }

            private static final Unit focusGained$lambda$0(Component $component) {
                AIMessageSelectViewProcessorKt.access$safeSetCaretVisibleInEditor((JTextComponent)$component, true);
                return Unit.INSTANCE;
            }
        };
        this.mouseProcessor = new MouseInputAdapter(this){
            final /* synthetic */ AIMessageSelectViewProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public final void transferFocusToNearestEditor(MouseEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Ref.IntRef dist = new Ref.IntRef();
                    dist.element = Integer.MAX_VALUE;
                    Ref.ObjectRef best = new Ref.ObjectRef();
                    AIMessageSelectViewProcessorKt.access$processInternalEditors(this.this$0.getMessageComponent(), arg_0 -> mouseProcessor.1.transferFocusToNearestEditor$lambda$0(e, dist, best, arg_0));
                    JTextComponent jTextComponent = (JTextComponent)best.element;
                    if (jTextComponent == null) break block0;
                    jTextComponent.requestFocus();
                }
            }

            public final boolean fixupDropSelectionAcrossTheParts(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return false;
                }
                AIMessageSelectChatProcessor aIMessageSelectChatProcessor = AIMessageSelectViewProcessor.access$getAiMessagesContainer(this.this$0);
                boolean bl = aIMessageSelectChatProcessor != null ? aIMessageSelectChatProcessor.isOneClickSelectionMode() : false;
                if (bl) {
                    return !e.isPopupTrigger() && !this.this$0.isMessageSelected();
                }
                Component editorPane = e.getComponent();
                if (!(editorPane instanceof JTextComponent)) {
                    return false;
                }
                if (e.isPopupTrigger()) {
                    e.consume();
                    return false;
                }
                if (!AIMessageSelectViewProcessorKt.safeHasSelection((JTextComponent)editorPane)) {
                    return true;
                }
                if (editorPane instanceof EditorComponentImpl) {
                    return false;
                }
                int editorOffset = ((JTextComponent)editorPane).viewToModel2D(e.getPoint());
                if (((JTextComponent)editorPane).getSelectionStart() <= editorOffset && editorOffset <= ((JTextComponent)editorPane).getSelectionEnd()) {
                    return false;
                }
                ((JTextComponent)editorPane).setCaretPosition(editorOffset);
                return true;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AIMessageSelectChatProcessor container = AIMessageSelectViewProcessor.access$getAiMessagesContainer(this.this$0);
                if (container == null) {
                    return;
                }
                this.transferFocusToNearestEditor(e);
                if (this.fixupDropSelectionAcrossTheParts(e)) {
                    AIMessageSelectChatProcessor aIMessageSelectChatProcessor = AIMessageSelectViewProcessor.access$getAiMessagesContainer(this.this$0);
                    if (aIMessageSelectChatProcessor != null) {
                        aIMessageSelectChatProcessor.dropSelection(true);
                    }
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                AIMessageSelectViewProcessor.access$setLastLeftMousePressedEvent$p(this.this$0, e);
                if (AIMessageSelectViewProcessor.access$getShowFocusableStatus$p(this.this$0)) {
                    AIMessageSelectViewProcessor.access$setShowFocusableStatus$p(this.this$0, false);
                    AIMessageSelectViewProcessor.access$updateVisibilityOfMessageFocusedStatus(this.this$0);
                }
                this.this$0.doWithoutScrollChange((Function0<Unit>)((Function0)() -> mouseProcessor.1.mousePressed$lambda$2(container, this.this$0)));
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AIMessageSelectChatProcessor container = AIMessageSelectViewProcessor.access$getAiMessagesContainer(this.this$0);
                if (container == null) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                this.this$0.doWithoutScrollChange((Function0<Unit>)((Function0)() -> mouseProcessor.1.mouseReleased$lambda$3(this.this$0, container, e)));
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AIMessageSelectChatProcessor container = AIMessageSelectViewProcessor.access$getAiMessagesContainer(this.this$0);
                if (container == null || !AIMessageSelectViewProcessor.access$getDragByPrimaryMouseButton$p(this.this$0)) {
                    return;
                }
                this.this$0.doWithoutScrollChange((Function0<Unit>)((Function0)() -> mouseProcessor.1.mouseDragged$lambda$5(this.this$0, container, e)));
            }

            private static final Unit transferFocusToNearestEditor$lambda$0(MouseEvent $e, Ref.IntRef $dist, Ref.ObjectRef $best, JTextComponent editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Point mp = SwingUtilities.convertPoint($e.getComponent(), $e.getPoint(), editor);
                Rectangle visibleRect = editor.getVisibleRect();
                if (mp.y >= visibleRect.y && mp.y <= visibleRect.y + visibleRect.height) {
                    $dist.element = -2147483647;
                    $best.element = editor;
                } else {
                    int ed;
                    int n = ed = mp.y < visibleRect.y ? visibleRect.y - mp.y : mp.y - visibleRect.y - visibleRect.height;
                    if (ed < $dist.element) {
                        $dist.element = ed;
                        $best.element = editor;
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void mousePressed$lambda$2$lambda$1(AIMessageSelectChatProcessor $container) {
                $container.dropSelection(false);
            }

            private static final Unit mousePressed$lambda$2(AIMessageSelectChatProcessor $container, AIMessageSelectViewProcessor this$0) {
                if (!$container.isOneClickSelectionMode()) {
                    SwingUtilities.invokeLater(() -> mouseProcessor.1.mousePressed$lambda$2$lambda$1($container));
                    if ($container.isOneClickSelectionMode()) {
                        return Unit.INSTANCE;
                    }
                }
                AIMessageSelectViewProcessor.access$setDragByPrimaryMouseButton$p(this$0, true);
                return Unit.INSTANCE;
            }

            private static final Unit mouseReleased$lambda$3(AIMessageSelectViewProcessor this$0, AIMessageSelectChatProcessor $container, MouseEvent $e) {
                AIMessageSelectViewProcessor.access$setDragByPrimaryMouseButton$p(this$0, false);
                AIMessageSelectViewProcessorKt.access$transferFocusToMessageOrMessagePartUnderCursorOrRestoreEventSourceEditor($container, $e, AIMessageSelectViewProcessor.access$getLastLeftMousePressedEvent$p(this$0));
                $container.stopAutoscrolling$intellij_ml_llm_chat();
                return Unit.INSTANCE;
            }

            private static final Unit mouseDragged$lambda$5$lambda$4(AIMessageSelectChatProcessor $container, MouseEvent $e, AIMessageSelectViewProcessor this$0) {
                if (!$container.isMouseProcessingRedirectedToMessageContainer()) {
                    Component component = $e.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                    JTextComponent dragSourceEditor = AIMessageSelectUtilsKt.getSourceEditor(component, $container.getMessageContainerView().getMessageContainerComponent());
                    if (dragSourceEditor != null) {
                        $container.processMouseDraggedSelection(this$0, $e);
                    }
                }
                return Unit.INSTANCE;
            }

            private static final Unit mouseDragged$lambda$5(AIMessageSelectViewProcessor this$0, AIMessageSelectChatProcessor $container, MouseEvent $e) {
                AIMessageSelectViewProcessor.access$doPostponedBackgroundRepaint(this$0, () -> mouseProcessor.1.mouseDragged$lambda$5$lambda$4($container, $e, this$0));
                return Unit.INSTANCE;
            }
        };
        this.copyPopupHandler = AIMessageSelectUtilsKt.createStackedPopupHandler(this.getMessageComponent(), AIMessageSelectUtilsKt.messagePartPopupGroupId(), "AIMessageSelectViewProcessor.popup", false);
    }

    @NotNull
    public final AIMessageView getMessageView() {
        return this.messageView;
    }

    public final void setMessageView(@NotNull AIMessageView aIMessageView) {
        Intrinsics.checkNotNullParameter((Object)aIMessageView, (String)"<set-?>");
        this.messageView = aIMessageView;
    }

    private final AnAction getCustomSelectAll() {
        Lazy lazy = this.customSelectAll$delegate;
        return (AnAction)lazy.getValue();
    }

    private final AnAction getCustomCancelSelection() {
        Lazy lazy = this.customCancelSelection$delegate;
        return (AnAction)lazy.getValue();
    }

    private final AnAction getCustomCopySelection() {
        Lazy lazy = this.customCopySelection$delegate;
        return (AnAction)lazy.getValue();
    }

    private final AIMessageSelectChatProcessor getAiMessagesContainer() {
        Lazy lazy = this.aiMessagesContainer$delegate;
        return (AIMessageSelectChatProcessor)lazy.getValue();
    }

    private final void updateVisibilityOfMessageFocusedStatus() {
        JComponent messageComponent = this.getMessageComponent();
        messageComponent.invalidate();
        messageComponent.repaint();
    }

    private final boolean isInternalEvent(MouseEvent e) {
        return e.getComponent().contains(e.getPoint());
    }

    public final void setupGroupSelectionDetector() {
        JComponent messageComponent = this.getMessageComponent();
        messageComponent.addMouseListener(this.mouseProcessor);
        messageComponent.addMouseMotionListener(this.mouseProcessor);
        messageComponent.addFocusListener(new FocusListener(this, messageComponent){
            final /* synthetic */ AIMessageSelectViewProcessor this$0;
            final /* synthetic */ JComponent $messageComponent;
            {
                this.this$0 = $receiver;
                this.$messageComponent = $messageComponent;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AIMessageSelectViewProcessorKt.access$isTraversalEvent(e)) {
                    AIMessageSelectViewProcessor.access$setShowFocusableStatus$p(this.this$0, true);
                    this.$messageComponent.scrollRectToVisible(new Rectangle(0, 0, this.$messageComponent.getWidth(), this.$messageComponent.getHeight()));
                }
                AIMessageSelectViewProcessor.access$updateVisibilityOfMessageFocusedStatus(this.this$0);
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AIMessageSelectViewProcessor.access$setShowFocusableStatus$p(this.this$0, false);
                AIMessageSelectViewProcessor.access$updateVisibilityOfMessageFocusedStatus(this.this$0);
            }
        });
    }

    private final void redirectMouseProcessingToMessageContainer(Component component, boolean redirect) {
        if (component instanceof JComponent) {
            if (redirect) {
                component.addMouseListener(this.copyPopupHandler);
            } else {
                component.removeMouseListener(this.copyPopupHandler);
            }
        }
        if (AIMessageSelectViewProcessorKt.access$isMessagePart(component)) {
            return;
        }
        boolean toggleIsEnabled = component instanceof ActionButton;
        if (redirect) {
            if (toggleIsEnabled) {
                AIMessageSelectViewProcessorKt.access$setPropertyValue("aiMessageActionButtonInfo", (JComponent)component, ((ActionButton)component).isEnabled());
                ((ActionButton)component).setEnabled(false);
            }
            component.addMouseListener(this.mouseProcessor);
            component.addMouseMotionListener(this.mouseProcessor);
        } else {
            if (toggleIsEnabled) {
                ((ActionButton)component).setEnabled(AIMessageSelectViewProcessorKt.access$hasTruePropertyValue("aiMessageActionButtonInfo", component));
                AIMessageSelectViewProcessorKt.access$dropPropertyValue("aiMessageActionButtonInfo", (JComponent)component);
            }
            component.removeMouseListener(this.mouseProcessor);
            component.removeMouseMotionListener(this.mouseProcessor);
        }
    }

    public final void addPart(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        AIMessageSelectViewProcessorKt.access$executeRecursiveAction(component, arg_0 -> AIMessageSelectViewProcessor.addPart$lambda$4(this, arg_0));
    }

    public final void removePart(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        AIMessageSelectViewProcessorKt.access$executeRecursiveAction(component, arg_0 -> AIMessageSelectViewProcessor.removePart$lambda$5(this, arg_0));
    }

    public final boolean hasSelectedText() {
        Ref.BooleanRef hasSelection = new Ref.BooleanRef();
        AIMessageSelectViewProcessorKt.access$processInternalEditors(this.getMessageComponent(), arg_0 -> AIMessageSelectViewProcessor.hasSelectedText$lambda$6(hasSelection, arg_0));
        return hasSelection.element;
    }

    public final void writeContent(@NotNull StringWriter md, @NotNull StringWriter html, boolean copyWithHeaderAndFooter, boolean copyOnlySelectedText) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        if (copyWithHeaderAndFooter) {
            this.messageView.writeHeader(md, html);
        }
        if (copyOnlySelectedText) {
            this.writeSelectedContent(md, html);
        } else {
            this.messageView.writeContent(md, html);
        }
        if (copyWithHeaderAndFooter) {
            this.messageView.writeFooter(md, html);
        }
    }

    public final boolean isAllTextSelected() {
        Ref.BooleanRef fullSelected = new Ref.BooleanRef();
        fullSelected.element = true;
        AIMessageSelectViewProcessorKt.access$processInternalEditors(this.getMessageComponent(), arg_0 -> AIMessageSelectViewProcessor.isAllTextSelected$lambda$7(fullSelected, arg_0));
        return fullSelected.element;
    }

    public final void writeSelectedContent(@NotNull StringWriter md, @NotNull StringWriter html) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        List selections = new ArrayList();
        AIMessageSelectViewProcessorKt.access$processInternalEditors(this.getMessageComponent(), arg_0 -> AIMessageSelectViewProcessor.writeSelectedContent$lambda$8(selections, arg_0));
        boolean exportCodeAsMarkdown = selections.size() > 1;
        Iterable $this$forEach$iv = selections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String htmlAsString;
            PartsImporterAsFakeClipboard importer = (PartsImporterAsFakeClipboard)element$iv;
            boolean bl = false;
            String languageAsString = importer.getLanguageAsString();
            String contentAsString = importer.getTextAsString();
            if (exportCodeAsMarkdown && contentAsString != null && languageAsString != null) {
                AIMessageSelectViewProcessorKt.access$writeContentWithEndNewLine(md, "``` " + languageAsString + "\n" + contentAsString);
                AIMessageSelectViewProcessorKt.access$writeContentWithEndNewLine(md, "```");
            } else {
                String string = contentAsString;
                if (string == null) {
                    string = "";
                }
                md.write(string);
            }
            if ((htmlAsString = importer.getHTMLAsString()) == null) continue;
            AIMessageSelectViewProcessorKt.access$writeContentWithEndNewLine(html, HtmlToMarkdownConverterKt.extractInnerBody(htmlAsString));
        }
    }

    public final boolean isMessageSelected() {
        return this.messageSelected;
    }

    public final void setMessageSelected(boolean selected) {
        if (this.messageSelected == selected) {
            return;
        }
        this.messageSelected = selected;
        if (!this.messageSelected) {
            this.dropSelectionInAllParts(!this.dragByPrimaryMouseButton);
        }
        this.repaintBackground();
    }

    @NotNull
    public final JComponent getMessageComponent() {
        return this.messageView.getMessageComponent();
    }

    public final void redirectMouseProcessingToMessageContainer(boolean redirect) {
        JComponent messageComponent = this.getMessageComponent();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])messageComponent.getComponents());
        while (iterator.hasNext()) {
            Component child = (Component)iterator.next();
            Intrinsics.checkNotNull((Object)child);
            AIMessageSelectViewProcessorKt.access$executeRecursiveAction(child, arg_0 -> AIMessageSelectViewProcessor.redirectMouseProcessingToMessageContainer$lambda$10(this, redirect, arg_0));
        }
    }

    public final boolean isInnerSelected() {
        return this.innerSelected;
    }

    public final void setMessageInnerSelected(boolean selectedInside) {
        if (this.innerSelected == selectedInside) {
            return;
        }
        this.innerSelected = selectedInside;
        if (!this.innerSelected) {
            AIMessageSelectViewProcessor.dropSelectionInAllParts$default(this, false, 1, null);
        }
        this.repaintBackground();
    }

    public final boolean processMouseInternalDraggedSelectionAndCheckMouseInsideParts(@NotNull MouseEvent dragEvent, @NotNull JTextComponent dragSourceEditor) {
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        Intrinsics.checkNotNullParameter((Object)dragSourceEditor, (String)"dragSourceEditor");
        JComponent messageComponent = this.getMessageComponent();
        Rectangle sourceBoundsInChat = SwingUtilities.convertRectangle(dragSourceEditor, dragSourceEditor.getVisibleRect(), messageComponent);
        int upperSourceBound = sourceBoundsInChat.y;
        int downSourceBound = sourceBoundsInChat.y + sourceBoundsInChat.height;
        Point mousePosInMessage = SwingUtilities.convertPoint(dragEvent.getComponent(), dragEvent.getPoint(), messageComponent);
        boolean selectionUpFromSourceEditor = mousePosInMessage.y < upperSourceBound;
        boolean selectionDownFromSourceEditor = mousePosInMessage.y > downSourceBound;
        Ref.IntRef firstEditorTop = new Ref.IntRef();
        firstEditorTop.element = upperSourceBound;
        Ref.IntRef lastEditorBottom = new Ref.IntRef();
        lastEditorBottom.element = downSourceBound;
        AIMessageSelectViewProcessorKt.access$processInternalEditors(messageComponent, arg_0 -> AIMessageSelectViewProcessor.processMouseInternalDraggedSelectionAndCheckMouseInsideParts$lambda$11(messageComponent, firstEditorTop, lastEditorBottom, dragSourceEditor, this, dragEvent, selectionUpFromSourceEditor, selectionDownFromSourceEditor, mousePosInMessage, upperSourceBound, downSourceBound, arg_0));
        int n = mousePosInMessage.y;
        return firstEditorTop.element <= n ? n <= lastEditorBottom.element : false;
    }

    public final void dropSelectionInAllParts(boolean dropSelectionInFocused) {
        this.doWithoutScrollChange((Function0<Unit>)((Function0)() -> AIMessageSelectViewProcessor.dropSelectionInAllParts$lambda$13(this, dropSelectionInFocused)));
    }

    public static /* synthetic */ void dropSelectionInAllParts$default(AIMessageSelectViewProcessor aIMessageSelectViewProcessor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        aIMessageSelectViewProcessor.dropSelectionInAllParts(bl);
    }

    private final void repaintBackground() {
        if (this.repaintBlocked == 0) {
            JComponent messageComponent = this.getMessageComponent();
            AIMessageSelectViewProcessorKt.access$processInternalEditors(messageComponent, arg_0 -> AIMessageSelectViewProcessor.repaintBackground$lambda$14(this, arg_0));
            messageComponent.invalidate();
            messageComponent.repaint();
            this.needRepaint = false;
        } else {
            this.needRepaint = true;
        }
    }

    private final void updateSelectionInExternalPart(JTextComponent editorPane, boolean selectionUpFromSourceEditor, Rectangle partBoundsInMessage, Point mousePosInMessage, int upperSourceBound, int downSourceBound, Document document, Point inEditorMousePos) {
        boolean bl;
        if (selectionUpFromSourceEditor) {
            var10_9 = mousePosInMessage.y;
            var11_10 = partBoundsInMessage.y;
            bl = var10_9 <= var11_10 ? var11_10 <= upperSourceBound : false;
        } else {
            var10_9 = mousePosInMessage.y;
            var11_10 = partBoundsInMessage.y + partBoundsInMessage.height;
            bl = downSourceBound <= var11_10 ? var11_10 <= var10_9 : false;
        }
        boolean allPartInSelectedRange = bl;
        boolean isCaretVisible = false;
        if (allPartInSelectedRange) {
            AIMessageSelectViewProcessorKt.access$safeSetSelectionInEditor(editorPane, 0, document.getLength());
        } else if (partBoundsInMessage.contains(mousePosInMessage)) {
            int mousePosition = editorPane.viewToModel2D(inEditorMousePos);
            if (selectionUpFromSourceEditor) {
                AIMessageSelectViewProcessorKt.access$safeSetSelectionInEditor(editorPane, document.getLength(), mousePosition);
            } else {
                AIMessageSelectViewProcessorKt.access$safeSetSelectionInEditor(editorPane, 0, mousePosition);
            }
            isCaretVisible = true;
        } else {
            AIMessageSelectViewProcessorKt.access$safeDropSelectionInEditor(editorPane);
        }
        AIMessageSelectViewProcessorKt.access$safeSetCaretVisibleInEditor(editorPane, isCaretVisible);
    }

    private final void fixSelectionInStarterPart(MouseEvent dragEvent, JTextComponent editorPane, boolean selectionUpFromSourceEditor, boolean selectionDownFromSourceEditor, Document document) {
        MouseEvent startEvent = this.lastLeftMousePressedEvent;
        if (editorPane instanceof EditorComponentImpl && startEvent != null && (selectionUpFromSourceEditor || selectionDownFromSourceEditor)) {
            int selectionStartOffset = editorPane.viewToModel2D(SwingUtilities.convertPoint(startEvent.getComponent(), startEvent.getPoint(), editorPane));
            if (selectionUpFromSourceEditor) {
                AIMessageSelectViewProcessorKt.access$safeSetSelectionInEditor(editorPane, selectionStartOffset, 0);
                dragEvent.consume();
            } else if (selectionDownFromSourceEditor) {
                AIMessageSelectViewProcessorKt.access$safeSetSelectionInEditor(editorPane, selectionStartOffset, document.getLength());
                dragEvent.consume();
            }
        }
    }

    public final boolean canShowFocusableStatus() {
        return this.showFocusableStatus;
    }

    public final boolean canScroll() {
        return this.scrollBlocked == 0 || this.scrollUnblocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doScrollRectToVisible$intellij_ml_llm_chat(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.scrollUnblocked = true;
        try {
            this.getMessageComponent().scrollRectToVisible(rect);
        }
        finally {
            this.scrollUnblocked = false;
        }
    }

    public final void selectAllText() {
        JComponent messageComponent = this.getMessageComponent();
        AIMessageSelectViewProcessorKt.access$processInternalEditors(messageComponent, AIMessageSelectViewProcessor::selectAllText$lambda$15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWithoutScrollChange(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        ++this.scrollBlocked;
        try {
            action2.invoke();
        }
        finally {
            SwingUtilities.invokeLater(() -> AIMessageSelectViewProcessor.doWithoutScrollChange$lambda$16(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPostponedBackgroundRepaint(Function0<Unit> action2) {
        ++this.repaintBlocked;
        try {
            action2.invoke();
        }
        finally {
            this.repaintBlocked += -1;
            if (this.repaintBlocked == 0 && this.needRepaint) {
                this.repaintBackground();
            }
        }
    }

    private static final AnAction customSelectAll_delegate$lambda$0() {
        return ActionManager.getInstance().getAction("AIAssistant.ToolWindow.Chat.Custom.Select.All");
    }

    private static final AnAction customCancelSelection_delegate$lambda$1() {
        return ActionManager.getInstance().getAction("AIAssistant.ToolWindow.Chat.Cancel.Selection");
    }

    private static final AnAction customCopySelection_delegate$lambda$2() {
        return ActionManager.getInstance().getAction("AIAssistant.ToolWindow.Chat.Copy.Chameleon");
    }

    private static final AIMessageSelectChatProcessor aiMessagesContainer_delegate$lambda$3(AIMessageSelectViewProcessor this$0) {
        return AIMessageSelectChatProcessorKt.findAIMessagesContainer(this$0.getMessageComponent());
    }

    private static final Unit addPart$lambda$4(AIMessageSelectViewProcessor this$0, Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof EditorComponentImpl) {
            ((EditorComponentImpl)it).setFocusTraversalKeysEnabled(true);
        }
        if (it instanceof JComponent) {
            AIMessageSelectViewProcessorKt.access$markAsMessagePart((JComponent)it, true);
            it.addMouseListener(this$0.mouseProcessor);
            it.addMouseMotionListener(this$0.mouseProcessor);
            if (it instanceof JTextComponent) {
                AnAction anAction = this$0.getCustomSelectAll();
                if (anAction != null) {
                    anAction.registerCustomShortcutSet((JComponent)it, null);
                }
                AnAction anAction2 = this$0.getCustomCancelSelection();
                if (anAction2 != null) {
                    anAction2.registerCustomShortcutSet((JComponent)it, null);
                }
                AnAction anAction3 = this$0.getCustomCopySelection();
                if (anAction3 != null) {
                    anAction3.registerCustomShortcutSet((JComponent)it, null);
                }
                it.addFocusListener(this$0.focusProcessor);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit removePart$lambda$5(AIMessageSelectViewProcessor this$0, Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof JComponent) {
            AIMessageSelectViewProcessorKt.access$markAsMessagePart((JComponent)it, false);
            it.removeMouseListener(this$0.mouseProcessor);
            it.removeMouseMotionListener(this$0.mouseProcessor);
            if (it instanceof JTextComponent) {
                it.removeFocusListener(this$0.focusProcessor);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit hasSelectedText$lambda$6(Ref.BooleanRef $hasSelection, JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        if (AIMessageSelectViewProcessorKt.safeHasSelection(editorPane)) {
            $hasSelection.element = true;
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit isAllTextSelected$lambda$7(Ref.BooleanRef $fullSelected, JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        $fullSelected.element = $fullSelected.element && AIMessageSelectViewProcessorKt.safeHasAllDocumentSelection(editorPane);
        return Unit.INSTANCE;
    }

    private static final Unit writeSelectedContent$lambda$8(List $selections, JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        if (AIMessageSelectViewProcessorKt.safeHasSelection(editorPane) && editorPane.getTransferHandler() != null) {
            PartsImporterAsFakeClipboard importer = new PartsImporterAsFakeClipboard();
            editorPane.getTransferHandler().exportToClipboard(editorPane, importer, 1);
            $selections.add(importer);
        }
        return Unit.INSTANCE;
    }

    private static final Unit redirectMouseProcessingToMessageContainer$lambda$10(AIMessageSelectViewProcessor this$0, boolean $redirect, Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.redirectMouseProcessingToMessageContainer(it, $redirect);
        return Unit.INSTANCE;
    }

    private static final Unit processMouseInternalDraggedSelectionAndCheckMouseInsideParts$lambda$11(JComponent $messageComponent, Ref.IntRef $firstEditorTop, Ref.IntRef $lastEditorBottom, JTextComponent $dragSourceEditor, AIMessageSelectViewProcessor this$0, MouseEvent $dragEvent, boolean $selectionUpFromSourceEditor, boolean $selectionDownFromSourceEditor, Point $mousePosInMessage, int $upperSourceBound, int $downSourceBound, JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        Rectangle partBoundsInMessage = SwingUtilities.convertRectangle(editorPane, editorPane.getVisibleRect(), $messageComponent);
        $firstEditorTop.element = Math.min($firstEditorTop.element, partBoundsInMessage.y);
        $lastEditorBottom.element = Math.max($lastEditorBottom.element, partBoundsInMessage.y + partBoundsInMessage.height);
        Document document = editorPane.getDocument();
        if (editorPane.getCaret() != null && document != null) {
            if (Intrinsics.areEqual((Object)editorPane, (Object)$dragSourceEditor)) {
                this$0.fixSelectionInStarterPart($dragEvent, editorPane, $selectionUpFromSourceEditor, $selectionDownFromSourceEditor, document);
                AIMessageSelectViewProcessorKt.access$safeSetCaretVisibleInEditor(editorPane, this$0.isInternalEvent($dragEvent));
            } else {
                Point inEditorMousePos = SwingUtilities.convertPoint($dragEvent.getComponent(), $dragEvent.getPoint(), editorPane);
                Intrinsics.checkNotNull((Object)partBoundsInMessage);
                Intrinsics.checkNotNull((Object)$mousePosInMessage);
                Intrinsics.checkNotNull((Object)inEditorMousePos);
                this$0.updateSelectionInExternalPart(editorPane, $selectionUpFromSourceEditor, partBoundsInMessage, $mousePosInMessage, $upperSourceBound, $downSourceBound, document, inEditorMousePos);
            }
            editorPane.getCaret().setSelectionVisible(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit dropSelectionInAllParts$lambda$13$lambda$12(boolean $dropSelectionInFocused, JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        if ($dropSelectionInFocused || !editorPane.hasFocus()) {
            AIMessageSelectViewProcessorKt.access$safeDropSelectionInEditor(editorPane);
        }
        return Unit.INSTANCE;
    }

    private static final Unit dropSelectionInAllParts$lambda$13(AIMessageSelectViewProcessor this$0, boolean $dropSelectionInFocused) {
        AIMessageSelectViewProcessorKt.access$processInternalEditors(this$0.getMessageComponent(), arg_0 -> AIMessageSelectViewProcessor.dropSelectionInAllParts$lambda$13$lambda$12($dropSelectionInFocused, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit repaintBackground$lambda$14(AIMessageSelectViewProcessor this$0, JTextComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AIMessageSelectViewProcessorKt.access$setFakeAllTextSelectionAndSaveRealLocalSelection(it, this$0.isMessageSelected() && !this$0.isInnerSelected());
        return Unit.INSTANCE;
    }

    private static final Unit selectAllText$lambda$15(JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        Document document = editorPane.getDocument();
        if (editorPane.getCaret() != null && document != null) {
            if (editorPane instanceof EditorComponentImpl) {
                ((EditorComponentImpl)editorPane).getEditor().getSelectionModel().setSelection(0, document.getLength());
            } else {
                editorPane.selectAll();
            }
            editorPane.getCaret().setSelectionVisible(true);
        }
        return Unit.INSTANCE;
    }

    private static final void doWithoutScrollChange$lambda$16(AIMessageSelectViewProcessor this$0) {
        this$0.scrollBlocked += -1;
        int cfr_ignored_0 = this$0.scrollBlocked;
    }

    public static final /* synthetic */ void access$setShowFocusableStatus$p(AIMessageSelectViewProcessor $this, boolean bl) {
        $this.showFocusableStatus = bl;
    }

    public static final /* synthetic */ void access$updateVisibilityOfMessageFocusedStatus(AIMessageSelectViewProcessor $this) {
        $this.updateVisibilityOfMessageFocusedStatus();
    }

    public static final /* synthetic */ AIMessageSelectChatProcessor access$getAiMessagesContainer(AIMessageSelectViewProcessor $this) {
        return $this.getAiMessagesContainer();
    }

    public static final /* synthetic */ void access$setLastLeftMousePressedEvent$p(AIMessageSelectViewProcessor $this, MouseEvent mouseEvent) {
        $this.lastLeftMousePressedEvent = mouseEvent;
    }

    public static final /* synthetic */ boolean access$getShowFocusableStatus$p(AIMessageSelectViewProcessor $this) {
        return $this.showFocusableStatus;
    }

    public static final /* synthetic */ boolean access$getDragByPrimaryMouseButton$p(AIMessageSelectViewProcessor $this) {
        return $this.dragByPrimaryMouseButton;
    }

    public static final /* synthetic */ void access$setDragByPrimaryMouseButton$p(AIMessageSelectViewProcessor $this, boolean bl) {
        $this.dragByPrimaryMouseButton = bl;
    }

    public static final /* synthetic */ MouseEvent access$getLastLeftMousePressedEvent$p(AIMessageSelectViewProcessor $this) {
        return $this.lastLeftMousePressedEvent;
    }

    public static final /* synthetic */ void access$doPostponedBackgroundRepaint(AIMessageSelectViewProcessor $this, Function0 action2) {
        $this.doPostponedBackgroundRepaint((Function0<Unit>)action2);
    }
}

