/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.enry.model;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;

public class ArrayReader {
    public static float[][] readDoublesFromText(BufferedReader r) throws IOException {
        int[] rc = ArrayReader.readHeader(r);
        int rows = rc[0];
        int cols = rc[1];
        float[][] res2 = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            StringTokenizer st = new StringTokenizer(r.readLine());
            for (int j = 0; j < cols; ++j) {
                res2[i][j] = Float.parseFloat(st.nextToken());
            }
        }
        return res2;
    }

    public static String[] readStringsFromText(BufferedReader r) throws IOException {
        int[] rc = ArrayReader.readHeader(r);
        int cols = rc[1];
        String[] res2 = new String[cols];
        StringTokenizer st = new StringTokenizer(r.readLine());
        for (int i = 0; i < cols; ++i) {
            res2[i] = st.nextToken();
        }
        return res2;
    }

    private static int[] readHeader(BufferedReader r) throws IOException {
        StringTokenizer st = new StringTokenizer(r.readLine());
        String prefix = st.nextToken().trim();
        if (!prefix.startsWith("#")) {
            throw new IOException("Fist line should start with #, instead got: '" + prefix + "'");
        }
        int rows = Integer.parseInt(st.nextToken());
        int cols = Integer.parseInt(st.nextToken());
        return new int[]{rows, cols};
    }

    public static double[][] readDoubleFromBin(String filename) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(filename));){
            double[][] dArray = ArrayReader.readDoubleArray(dis);
            return dArray;
        }
    }

    public static double[][] readDoubleArray(DataInputStream dis) throws IOException {
        int rows = dis.readInt();
        int columns = dis.readInt();
        double[][] array = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                array[i][j] = dis.readDouble();
            }
        }
        return array;
    }

    public static float[][] readFloatArray(DataInputStream dis) throws IOException {
        int rows = dis.readInt();
        int columns = dis.readInt();
        float[][] array = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                array[i][j] = dis.readFloat();
            }
        }
        return array;
    }

    public static String[] readNgramStringArray(DataInputStream dis) throws IOException {
        int MAX_BYTES_IN_UTF8_3GRAM = 12;
        int numStrings = dis.readInt();
        String[] strings = new String[numStrings];
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(12);
        for (int i = 0; i < numStrings; ++i) {
            int b;
            while ((b = dis.read()) != -1 && b != 0) {
                byteArrayStream.write(b);
            }
            strings[i] = byteArrayStream.toString(StandardCharsets.UTF_8);
            byteArrayStream.reset();
        }
        return strings;
    }
}

