/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptCustomDetector;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptExtensionPoints;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptDetectorUtil;", "", "<init>", "()V", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "detector", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptCustomDetector;", "isEditorFocused", "intellij.ml.llm.inlinePromptDetector"})
public final class InlinePromptDetectorUtil {
    @NotNull
    public static final InlinePromptDetectorUtil INSTANCE = new InlinePromptDetectorUtil();

    private InlinePromptDetectorUtil() {
    }

    public final boolean isAvailable(@NotNull PsiFile file, @NotNull Editor editor, @NotNull InlinePromptCustomDetector detector) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DumbService.Companion.getInstance(project).isUsableInCurrentContext((Object)detector)) {
            return false;
        }
        if (!detector.isApplicable(file)) {
            return false;
        }
        if (!editor.getDocument().isWritable()) {
            return false;
        }
        return this.isEditorFocused(editor) && AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(file.getProject()) || ApplicationManager.getApplication().isUnitTestMode();
    }

    public final boolean isAvailable(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        InlinePromptCustomDetector inlinePromptCustomDetector = InlinePromptExtensionPoints.INSTANCE.findDetectorByLanguage(language);
        if (inlinePromptCustomDetector == null) {
            return false;
        }
        InlinePromptCustomDetector detector = inlinePromptCustomDetector;
        return this.isAvailable(psiFile2, editor, detector);
    }

    private final boolean isEditorFocused(Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        return Intrinsics.areEqual((Object)FileEditorManager.getInstance((Project)project2).getSelectedTextEditor(), (Object)editor);
    }
}

