/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.exec.jvm;

import ai.grazie.code.exec.model.DeviceArchitecture;
import ai.grazie.code.exec.model.DeviceMetadataProvider;
import ai.grazie.code.exec.model.DeviceOS;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lai/grazie/code/exec/jvm/JVMDeviceMetadataProvider;", "Lai/grazie/code/exec/model/DeviceMetadataProvider;", "<init>", "()V", "architecture", "Lai/grazie/code/exec/model/DeviceArchitecture;", "os", "Lai/grazie/code/exec/model/DeviceOS;", "code-exec-jvm"})
public final class JVMDeviceMetadataProvider
implements DeviceMetadataProvider {
    @NotNull
    public static final JVMDeviceMetadataProvider INSTANCE = new JVMDeviceMetadataProvider();

    private JVMDeviceMetadataProvider() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DeviceArchitecture architecture() {
        DeviceArchitecture deviceArchitecture;
        String string = System.getProperty("os.arch");
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1221096139: {
                    if (!string.equals("aarch64")) break;
                    n = 1;
                    break;
                }
                case -806050265: {
                    if (!string.equals("x86_64")) break;
                    n = 2;
                    break;
                }
                case 93084186: {
                    if (!string.equals("arm64")) break;
                    n = 1;
                    break;
                }
                case 92926582: {
                    if (!string.equals("amd64")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    deviceArchitecture = DeviceArchitecture.ARM_64;
                    return deviceArchitecture;
                }
                case 2: {
                    deviceArchitecture = DeviceArchitecture.X86_64;
                    return deviceArchitecture;
                }
            }
        }
        deviceArchitecture = DeviceArchitecture.UNKNOWN;
        return deviceArchitecture;
    }

    @Override
    @NotNull
    public DeviceOS os() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String name2 = string2;
        return StringsKt.contains$default((CharSequence)name2, (CharSequence)"win", (boolean)false, (int)2, null) ? DeviceOS.WINDOWS : (StringsKt.contains$default((CharSequence)name2, (CharSequence)"mac", (boolean)false, (int)2, null) ? DeviceOS.MAC_OS : (Intrinsics.areEqual((Object)name2, (Object)"linux") ? DeviceOS.LINUX : (Intrinsics.areEqual((Object)name2, (Object)"unix") ? DeviceOS.UNIX : DeviceOS.UNKNOWN)));
    }
}

