/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.features.opentelemetry.feature;

import ai.koog.agents.features.common.config.FeatureConfig;
import ai.koog.agents.features.opentelemetry.attribute.AttributesKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.io.InputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013J\u000e\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\bJ\u001a\u0010-\u001a\u00020*2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nJ*\u0010/\u001a\u00020*\"\b\b\u0000\u00100*\u00020\u000f2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00\u000e\u0012\u0004\u0012\u0002H002J\u000e\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u0018J\u000e\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\u001aJ\b\u00107\u001a\u00020\u0011H\u0002J\b\u00108\u001a\u00020\u0018H\u0002J\b\u00109\u001a\u00020:H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0<H\u0002J\u0014\u0010=\u001a\u00020**\u00020>2\u0006\u0010,\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006@"}, d2={"Lai/koog/agents/features/opentelemetry/feature/OpenTelemetryConfig;", "Lai/koog/agents/features/common/config/FeatureConfig;", "<init>", "()V", "productProperties", "Ljava/util/Properties;", "customSpanExporters", "", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "customSpanProcessorsCreator", "Lkotlin/Function1;", "Lio/opentelemetry/sdk/trace/SpanProcessor;", "customResourceAttributes", "", "Lio/opentelemetry/api/common/AttributeKey;", "", "_sdk", "Lio/opentelemetry/sdk/OpenTelemetrySdk;", "_serviceName", "", "_serviceVersion", "_instrumentationScopeName", "_instrumentationScopeVersion", "_sampler", "Lio/opentelemetry/sdk/trace/samplers/Sampler;", "_verbose", "", "isVerbose", "()Z", "sdk", "getSdk", "()Lio/opentelemetry/sdk/OpenTelemetrySdk;", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "getTracer", "()Lio/opentelemetry/api/trace/Tracer;", "serviceName", "getServiceName", "()Ljava/lang/String;", "serviceVersion", "getServiceVersion", "setServiceInfo", "", "addSpanExporter", "exporter", "addSpanProcessor", "processor", "addResourceAttributes", "T", "attributes", "", "setSampler", "sampler", "setVerbose", "verbose", "initializeOpenTelemetry", "createSampler", "createResources", "Lio/opentelemetry/sdk/resources/Resource;", "createExporters", "", "addProcessors", "Lio/opentelemetry/sdk/trace/SdkTracerProviderBuilder;", "Companion", "agents-features-opentelemetry"})
@SourceDebugExtension(value={"SMAP\nOpenTelemetryConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTelemetryConfig.kt\nai/koog/agents/features/opentelemetry/feature/OpenTelemetryConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1869#2,2:279\n1869#2,2:282\n1869#2,2:284\n1#3:281\n*S KotlinDebug\n*F\n+ 1 OpenTelemetryConfig.kt\nai/koog/agents/features/opentelemetry/feature/OpenTelemetryConfig\n*L\n208#1:279,2\n255#1:282,2\n269#1:284,2\n*E\n"})
public final class OpenTelemetryConfig
extends FeatureConfig {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties productProperties;
    @NotNull
    private final List<SpanExporter> customSpanExporters;
    @NotNull
    private final List<Function1<SpanExporter, SpanProcessor>> customSpanProcessorsCreator;
    @NotNull
    private final Map<AttributeKey<?>, Object> customResourceAttributes;
    @Nullable
    private OpenTelemetrySdk _sdk;
    @NotNull
    private String _serviceName;
    @NotNull
    private String _serviceVersion;
    @NotNull
    private String _instrumentationScopeName;
    @NotNull
    private String _instrumentationScopeVersion;
    @Nullable
    private Sampler _sampler;
    private boolean _verbose;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)OpenTelemetryConfig::logger$lambda$16));
    private static final String osName = System.getProperty("os.name");
    private static final String osVersion = System.getProperty("os.version");
    private static final String osArch = System.getProperty("os.arch");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public OpenTelemetryConfig() {
        String string;
        void var3_4;
        void $this$productProperties_u24lambda_u241;
        OpenTelemetryConfig openTelemetryConfig = this;
        OpenTelemetryConfig openTelemetryConfig2 = this;
        boolean bl = false;
        Properties props = new Properties();
        InputStream inputStream = $this$productProperties_u24lambda_u241.getClass().getClassLoader().getResourceAsStream("product.properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                props.load(stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        openTelemetryConfig2.productProperties = var3_4;
        this.customSpanExporters = new ArrayList();
        this.customSpanProcessorsCreator = new ArrayList();
        this.customResourceAttributes = new LinkedHashMap();
        String string2 = this.productProperties.getProperty("name");
        if (string2 == null) {
            string2 = this._serviceName = "ai.koog";
        }
        if ((string = this.productProperties.getProperty("version")) == null) {
            string = "0.0.0";
        }
        this._serviceVersion = string;
        this._instrumentationScopeName = this._serviceName;
        this._instrumentationScopeVersion = this._serviceVersion;
    }

    public final boolean isVerbose() {
        return this._verbose;
    }

    @NotNull
    public final OpenTelemetrySdk getSdk() {
        OpenTelemetrySdk openTelemetrySdk = this._sdk;
        if (openTelemetrySdk == null) {
            OpenTelemetrySdk openTelemetrySdk2;
            OpenTelemetrySdk sdk = openTelemetrySdk2 = this.initializeOpenTelemetry();
            boolean bl = false;
            this._sdk = sdk;
            this._instrumentationScopeName = this._serviceName;
            this._instrumentationScopeVersion = this._serviceVersion;
            openTelemetrySdk = openTelemetrySdk2;
        }
        return openTelemetrySdk;
    }

    @NotNull
    public final Tracer getTracer() {
        Tracer tracer = this.getSdk().getTracer(this._instrumentationScopeName, this._instrumentationScopeVersion);
        Intrinsics.checkNotNullExpressionValue((Object)tracer, (String)"getTracer(...)");
        return tracer;
    }

    @NotNull
    public final String getServiceName() {
        return this._serviceName;
    }

    @NotNull
    public final String getServiceVersion() {
        return this._serviceVersion;
    }

    public final void setServiceInfo(@NotNull String serviceName, @NotNull String serviceVersion) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)serviceVersion, (String)"serviceVersion");
        this._serviceName = serviceName;
        this._serviceVersion = serviceVersion;
    }

    public final void addSpanExporter(@NotNull SpanExporter exporter) {
        Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
        this.customSpanExporters.add(exporter);
    }

    public final void addSpanProcessor(@NotNull Function1<? super SpanExporter, ? extends SpanProcessor> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.customSpanProcessorsCreator.add(processor);
    }

    public final <T> void addResourceAttributes(@NotNull Map<AttributeKey<T>, ? extends T> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.customResourceAttributes.putAll(attributes);
    }

    public final void setSampler(@NotNull Sampler sampler) {
        Intrinsics.checkNotNullParameter((Object)sampler, (String)"sampler");
        this._sampler = sampler;
    }

    public final void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    private final OpenTelemetrySdk initializeOpenTelemetry() {
        OpenTelemetrySdkBuilder builder = OpenTelemetrySdk.builder();
        Sampler sampler = this.createSampler();
        Resource resource = this.createResources();
        List<SpanExporter> exporters = this.createExporters();
        SdkTracerProviderBuilder traceProviderBuilder = SdkTracerProvider.builder().setSampler(sampler).setResource(resource);
        Iterable $this$forEach$iv = exporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpanExporter exporter = (SpanExporter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)traceProviderBuilder);
            this.addProcessors(traceProviderBuilder, exporter);
        }
        OpenTelemetrySdk sdk = builder.setTracerProvider(traceProviderBuilder.build()).setPropagators(ContextPropagators.create((TextMapPropagator)((TextMapPropagator)W3CTraceContextPropagator.getInstance()))).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> OpenTelemetryConfig.initializeOpenTelemetry$lambda$4(sdk)));
        Intrinsics.checkNotNull((Object)sdk);
        return sdk;
    }

    private final Sampler createSampler() {
        Sampler sampler = this._sampler;
        if (sampler == null) {
            Sampler sampler2 = Sampler.alwaysOn();
            sampler = sampler2;
            Intrinsics.checkNotNullExpressionValue((Object)sampler2, (String)"alwaysOn(...)");
        }
        return sampler;
    }

    private final Resource createResources() {
        Map map2;
        Map $this$createResources_u24lambda_u248 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        AttributeKey attributeKey = AttributeKey.stringKey((String)"service.name");
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"stringKey(...)");
        $this$createResources_u24lambda_u248.put(attributeKey, this._serviceName);
        AttributeKey attributeKey2 = AttributeKey.stringKey((String)"service.version");
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey2, (String)"stringKey(...)");
        $this$createResources_u24lambda_u248.put(attributeKey2, this._serviceVersion);
        AttributeKey attributeKey3 = AttributeKey.stringKey((String)"service.instance.time");
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey3, (String)"stringKey(...)");
        String string = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        $this$createResources_u24lambda_u248.put(attributeKey3, string);
        String string2 = osName;
        if (string2 != null) {
            String osName = string2;
            boolean bl2 = false;
            AttributeKey attributeKey4 = AttributeKey.stringKey((String)"os.type");
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey4, (String)"stringKey(...)");
            $this$createResources_u24lambda_u248.put(attributeKey4, osName);
        }
        String string3 = osVersion;
        if (string3 != null) {
            String osVersion = string3;
            boolean bl3 = false;
            AttributeKey attributeKey5 = AttributeKey.stringKey((String)"os.version");
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey5, (String)"stringKey(...)");
            $this$createResources_u24lambda_u248.put(attributeKey5, osVersion);
        }
        String string4 = osArch;
        if (string4 != null) {
            String osArch = string4;
            boolean bl4 = false;
            AttributeKey attributeKey6 = AttributeKey.stringKey((String)"os.arch");
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey6, (String)"stringKey(...)");
            $this$createResources_u24lambda_u248.put(attributeKey6, osArch);
        }
        Map defaultResourceAttributes = MapsKt.build((Map)map2);
        AttributesBuilder attributesBuilder = Attributes.builder();
        Intrinsics.checkNotNullExpressionValue((Object)attributesBuilder, (String)"builder(...)");
        Attributes resourceAttributes = AttributesKt.addAttributes(AttributesKt.addAttributes(attributesBuilder, defaultResourceAttributes), this.customResourceAttributes).build();
        Resource resource = Resource.create((Attributes)resourceAttributes);
        Intrinsics.checkNotNull((Object)resource);
        return resource;
    }

    private final List<SpanExporter> createExporters() {
        List list2;
        List $this$createExporters_u24lambda_u2412 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.customSpanExporters.isEmpty()) {
            logger.debug((Function0<? extends Object>)((Function0)OpenTelemetryConfig::createExporters$lambda$12$lambda$9));
            LoggingSpanExporter loggingSpanExporter = LoggingSpanExporter.create();
            Intrinsics.checkNotNullExpressionValue((Object)loggingSpanExporter, (String)"create(...)");
            $this$createExporters_u24lambda_u2412.add(loggingSpanExporter);
        }
        Iterable $this$forEach$iv = this.customSpanExporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpanExporter exporter = (SpanExporter)element$iv;
            boolean bl2 = false;
            logger.debug((Function0<? extends Object>)((Function0)() -> OpenTelemetryConfig.createExporters$lambda$12$lambda$11$lambda$10(exporter)));
            $this$createExporters_u24lambda_u2412.add(exporter);
        }
        return CollectionsKt.build((List)list2);
    }

    private final void addProcessors(SdkTracerProviderBuilder $this$addProcessors, SpanExporter exporter) {
        if (this.customSpanProcessorsCreator.isEmpty()) {
            logger.debug((Function0<? extends Object>)((Function0)() -> OpenTelemetryConfig.addProcessors$lambda$13(exporter)));
            $this$addProcessors.addSpanProcessor((SpanProcessor)SimpleSpanProcessor.builder((SpanExporter)exporter).build());
            return;
        }
        Iterable $this$forEach$iv = this.customSpanProcessorsCreator;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 processorCreator = (Function1)element$iv;
            boolean bl = false;
            SpanProcessor spanProcessor = (SpanProcessor)processorCreator.invoke((Object)exporter);
            logger.debug((Function0<? extends Object>)((Function0)() -> OpenTelemetryConfig.addProcessors$lambda$15$lambda$14(spanProcessor)));
            $this$addProcessors.addSpanProcessor(spanProcessor);
        }
    }

    private static final void initializeOpenTelemetry$lambda$4(OpenTelemetrySdk $sdk) {
        $sdk.close();
    }

    private static final Object createExporters$lambda$12$lambda$9() {
        return "No custom span exporters configured. Use log span exporter by default.";
    }

    private static final Object createExporters$lambda$12$lambda$11$lambda$10(SpanExporter $exporter) {
        return "Adding span exporter: " + Reflection.getOrCreateKotlinClass($exporter.getClass()).getSimpleName();
    }

    private static final Object addProcessors$lambda$13(SpanExporter $exporter) {
        return "No custom span processors configured. Use batch span processor with " + Reflection.getOrCreateKotlinClass($exporter.getClass()).getSimpleName() + " as an exporter.";
    }

    private static final Object addProcessors$lambda$15$lambda$14(SpanProcessor $spanProcessor) {
        return "Adding span processor: " + Reflection.getOrCreateKotlinClass($spanProcessor.getClass()).getSimpleName();
    }

    private static final Unit logger$lambda$16() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/koog/agents/features/opentelemetry/feature/OpenTelemetryConfig$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "osName", "", "kotlin.jvm.PlatformType", "osVersion", "osArch", "agents-features-opentelemetry"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

