/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.features.opentelemetry.span;

import ai.koog.agents.features.opentelemetry.attribute.Attribute;
import ai.koog.agents.features.opentelemetry.attribute.AttributesKt;
import ai.koog.agents.features.opentelemetry.event.GenAIAgentEvent;
import ai.koog.agents.features.opentelemetry.span.CreateAgentSpan;
import ai.koog.agents.features.opentelemetry.span.GenAIAgentSpan;
import ai.koog.agents.features.opentelemetry.span.InvokeAgentSpan;
import ai.koog.agents.features.opentelemetry.span.SpanEndStatus;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001a\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\t2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J*\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ$\u0010\u001f\u001a\u0004\u0018\u0001H \"\n\b\u0000\u0010 \u0018\u0001*\u00020\t2\u0006\u0010\u0012\u001a\u00020\bH\u0086\b\u00a2\u0006\u0002\u0010!J\"\u0010\"\u001a\u0002H \"\n\b\u0000\u0010 \u0018\u0001*\u00020\t2\u0006\u0010#\u001a\u00020\bH\u0086\b\u00a2\u0006\u0002\u0010!J+\u0010$\u001a\u00020\u00112#\b\u0002\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020)0&J\u0016\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bJ\u0010\u0010-\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0018\u0010.\u001a\u00020\u0011*\u00020/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001eH\u0002J\u001a\u00101\u001a\u00020\u0011*\u0002022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0002J\u001a\u00101\u001a\u00020\u0011*\u00020/2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00064"}, d2={"Lai/koog/agents/features/opentelemetry/span/SpanProcessor;", "", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "<init>", "(Lio/opentelemetry/api/trace/Tracer;)V", "_spans", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lai/koog/agents/features/opentelemetry/span/GenAIAgentSpan;", "spansLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "spansCount", "", "getSpansCount", "()I", "addEventsToSpan", "", "spanId", "events", "", "Lai/koog/agents/features/opentelemetry/event/GenAIAgentEvent;", "startSpan", "span", "instant", "Ljava/time/Instant;", "endSpan", "attributes", "Lai/koog/agents/features/opentelemetry/attribute/Attribute;", "spanEndStatus", "Lai/koog/agents/features/opentelemetry/span/SpanEndStatus;", "getSpan", "T", "(Ljava/lang/String;)Lai/koog/agents/features/opentelemetry/span/GenAIAgentSpan;", "getSpanOrThrow", "id", "endUnfinishedSpans", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "endUnfinishedInvokeAgentSpans", "agentId", "runId", "addSpan", "setSpanStatus", "Lio/opentelemetry/api/trace/Span;", "endStatus", "setAttributes", "Lio/opentelemetry/api/trace/SpanBuilder;", "Companion", "agents-features-opentelemetry"})
@SourceDebugExtension(value={"SMAP\nSpanProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpanProcessor.kt\nai/koog/agents/features/opentelemetry/span/SpanProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n774#2:155\n865#2,2:156\n1869#2,2:158\n1#3:160\n*S KotlinDebug\n*F\n+ 1 SpanProcessor.kt\nai/koog/agents/features/opentelemetry/span/SpanProcessor\n*L\n104#1:155\n104#1:156,2\n108#1:158,2\n*E\n"})
public final class SpanProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tracer tracer;
    @NotNull
    private final ConcurrentHashMap<String, GenAIAgentSpan> _spans;
    @NotNull
    private final ReentrantReadWriteLock spansLock;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)SpanProcessor::logger$lambda$14));

    public SpanProcessor(@NotNull Tracer tracer) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        this.tracer = tracer;
        this._spans = new ConcurrentHashMap();
        this.spansLock = new ReentrantReadWriteLock();
    }

    public final int getSpansCount() {
        return ((Map)this._spans).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEventsToSpan(@NotNull String spanId, @NotNull List<? extends GenAIAgentEvent> events) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ReentrantReadWriteLock.ReadLock readLock = this.spansLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            GenAIAgentSpan genAIAgentSpan = this._spans.get(spanId);
            if (genAIAgentSpan == null) {
                throw new IllegalStateException(("Span with id '" + spanId + "' not found").toString());
            }
            GenAIAgentSpan span = genAIAgentSpan;
            span.addEvents(events);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    public final void startSpan(@NotNull GenAIAgentSpan span, @Nullable Instant instant) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        logger.debug((Function0<? extends Object>)((Function0)() -> SpanProcessor.startSpan$lambda$1(span)));
        SpanKind spanKind = span.getKind();
        GenAIAgentSpan genAIAgentSpan = span.getParent();
        if (genAIAgentSpan == null || (genAIAgentSpan = genAIAgentSpan.getContext()) == null) {
            genAIAgentSpan = Context.current();
        }
        GenAIAgentSpan parentContext = genAIAgentSpan;
        SpanBuilder spanBuilder = this.tracer.spanBuilder(span.getName());
        Instant instant2 = instant;
        if (instant2 == null) {
            instant2 = Instant.now();
        }
        SpanBuilder spanBuilder2 = spanBuilder.setStartTimestamp(instant2).setSpanKind(spanKind).setParent((Context)parentContext);
        Intrinsics.checkNotNull((Object)spanBuilder2);
        this.setAttributes(spanBuilder2, span.getAttributes());
        Span startedSpan = spanBuilder2.startSpan();
        this.addSpan(span);
        Intrinsics.checkNotNull((Object)startedSpan);
        span.setSpan(startedSpan);
        Context context2 = startedSpan.storeInContext((Context)parentContext);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"storeInContext(...)");
        span.setContext(context2);
        logger.debug((Function0<? extends Object>)((Function0)() -> SpanProcessor.startSpan$lambda$2(span)));
    }

    public static /* synthetic */ void startSpan$default(SpanProcessor spanProcessor, GenAIAgentSpan genAIAgentSpan, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = null;
        }
        spanProcessor.startSpan(genAIAgentSpan, instant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endSpan(@NotNull String spanId, @NotNull List<? extends Attribute> attributes, @Nullable SpanEndStatus spanEndStatus) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        logger.debug((Function0<? extends Object>)((Function0)() -> SpanProcessor.endSpan$lambda$3(spanId)));
        ReentrantReadWriteLock reentrantReadWriteLock = this.spansLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            GenAIAgentSpan genAIAgentSpan = this._spans.get(spanId);
            if (genAIAgentSpan == null) {
                throw new IllegalStateException(("Span with id '" + spanId + "' not found. Make sure span was started or was not finished previously").toString());
            }
            GenAIAgentSpan existingSpan = genAIAgentSpan;
            logger.debug((Function0<? extends Object>)((Function0)() -> SpanProcessor.endSpan$lambda$6$lambda$4(existingSpan)));
            Span spanToFinish = existingSpan.getSpan();
            this.setAttributes(spanToFinish, attributes);
            this.setSpanStatus(spanToFinish, spanEndStatus);
            spanToFinish.end();
            GenAIAgentSpan removedSpan = this._spans.remove(spanId);
            if (removedSpan == null) {
                logger.warn((Function0<? extends Object>)((Function0)() -> SpanProcessor.endSpan$lambda$6$lambda$5(spanId)));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static /* synthetic */ void endSpan$default(SpanProcessor spanProcessor, String string, List list2, SpanEndStatus spanEndStatus, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            spanEndStatus = null;
        }
        spanProcessor.endSpan(string, list2, spanEndStatus);
    }

    public final /* synthetic */ <T extends GenAIAgentSpan> T getSpan(String spanId) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        boolean $i$f$getSpan = false;
        Object v = this._spans.get(spanId);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)((GenAIAgentSpan)v);
    }

    public final /* synthetic */ <T extends GenAIAgentSpan> T getSpanOrThrow(String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        boolean $i$f$getSpanOrThrow = false;
        GenAIAgentSpan genAIAgentSpan = (GenAIAgentSpan)this._spans.get(id);
        if (genAIAgentSpan == null) {
            throw new IllegalStateException(("Span with id: " + id + " not found").toString());
        }
        GenAIAgentSpan span = genAIAgentSpan;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        GenAIAgentSpan genAIAgentSpan2 = span;
        if (genAIAgentSpan2 == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException(("Span with id <" + id + "> is not of expected type. Expected: <" + Reflection.getOrCreateKotlinClass(GenAIAgentSpan.class).getSimpleName() + ">, actual: <" + Reflection.getOrCreateKotlinClass(span.getClass()).getSimpleName() + ">").toString());
        }
        return (T)genAIAgentSpan2;
    }

    /*
     * WARNING - void declaration
     */
    public final void endUnfinishedSpans(@NotNull Function1<? super String, Boolean> filter2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Set set2 = this._spans.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String spanId = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)spanId);
            boolean isRequireFinish = (Boolean)filter2.invoke((Object)spanId);
            if (!isRequireFinish) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String spanId = (String)element$iv;
            boolean bl = false;
            logger.warn((Function0<? extends Object>)((Function0)() -> SpanProcessor.endUnfinishedSpans$lambda$10$lambda$9(spanId)));
            Intrinsics.checkNotNull((Object)spanId);
            this.endSpan(spanId, CollectionsKt.emptyList(), new SpanEndStatus(StatusCode.UNSET, null, 2, null));
        }
    }

    public static /* synthetic */ void endUnfinishedSpans$default(SpanProcessor spanProcessor, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = SpanProcessor::endUnfinishedSpans$lambda$7;
        }
        spanProcessor.endUnfinishedSpans((Function1<? super String, Boolean>)function1);
    }

    public final void endUnfinishedInvokeAgentSpans(@NotNull String agentId, @NotNull String runId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)runId, (String)"runId");
        String agentRunSpanId = InvokeAgentSpan.Companion.createId(agentId, runId);
        String agentSpanId = CreateAgentSpan.Companion.createId(agentId);
        this.endUnfinishedSpans((Function1<? super String, Boolean>)((Function1)arg_0 -> SpanProcessor.endUnfinishedInvokeAgentSpans$lambda$11(agentSpanId, agentRunSpanId, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addSpan(GenAIAgentSpan span) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.spansLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String spanId = span.getSpanId();
            GenAIAgentSpan existingSpan = this._spans.get(spanId);
            if (!(existingSpan == null)) {
                boolean bl2 = false;
                String string = "Span with id '" + spanId + "' already added";
                throw new IllegalStateException(string.toString());
            }
            ((Map)this._spans).put(span.getSpanId(), span);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void setSpanStatus(Span $this$setSpanStatus, SpanEndStatus endStatus) {
        Object object;
        SpanEndStatus statusCode;
        SpanEndStatus spanEndStatus = endStatus;
        if (spanEndStatus == null || (spanEndStatus = spanEndStatus.getCode()) == null) {
            spanEndStatus = statusCode = StatusCode.OK;
        }
        if ((object = endStatus) == null || (object = ((SpanEndStatus)object).getDescription()) == null) {
            object = "";
        }
        Object statusDescription = object;
        $this$setSpanStatus.setStatus((StatusCode)statusCode, (String)statusDescription);
    }

    static /* synthetic */ void setSpanStatus$default(SpanProcessor spanProcessor, Span span, SpanEndStatus spanEndStatus, int n, Object object) {
        if ((n & 1) != 0) {
            spanEndStatus = null;
        }
        spanProcessor.setSpanStatus(span, spanEndStatus);
    }

    private final void setAttributes(SpanBuilder $this$setAttributes, List<? extends Attribute> attributes) {
        $this$setAttributes.setAllAttributes(AttributesKt.toSdkAttributes(attributes));
    }

    private final void setAttributes(Span $this$setAttributes, List<? extends Attribute> attributes) {
        $this$setAttributes.setAllAttributes(AttributesKt.toSdkAttributes(attributes));
    }

    private static final Object startSpan$lambda$1(GenAIAgentSpan $span) {
        return "Starting span (name: " + $span.getName() + ", id: " + $span.getSpanId() + ")";
    }

    private static final Object startSpan$lambda$2(GenAIAgentSpan $span) {
        return "Span has been started (name: " + $span.getName() + ", id: " + $span.getSpanId() + ")";
    }

    private static final Object endSpan$lambda$3(String $spanId) {
        return "Finishing the span (id: " + $spanId + ")";
    }

    private static final Object endSpan$lambda$6$lambda$4(GenAIAgentSpan $existingSpan) {
        return "Finishing the span (name: $" + $existingSpan.getName() + ", id: " + $existingSpan.getSpanId() + ")";
    }

    private static final Object endSpan$lambda$6$lambda$5(String $spanId) {
        return "Span with id '" + $spanId + "' not found. Make sure you do not delete span with same id several times";
    }

    private static final boolean endUnfinishedSpans$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Object endUnfinishedSpans$lambda$10$lambda$9(String $spanId) {
        return "Force close span with id: " + $spanId;
    }

    private static final boolean endUnfinishedInvokeAgentSpans$lambda$11(String $agentSpanId, String $agentRunSpanId, String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !Intrinsics.areEqual((Object)id, (Object)$agentSpanId) && !Intrinsics.areEqual((Object)id, (Object)$agentRunSpanId);
    }

    private static final Unit logger$lambda$14() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/koog/agents/features/opentelemetry/span/SpanProcessor$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "agents-features-opentelemetry"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

