/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.miniAiChat;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupInputTextField;
import com.intellij.ml.llm.core.chat.ui.AIAssistantChatUtil;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatCustomUiPanel;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B \u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000f\b\u0002\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0014J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H$J\b\u0010&\u001a\u00020\u001bH\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\u0015J\u0006\u0010,\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatEditorControlBase;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "hint", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "editorTextField", "Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupInputTextField;", "getEditorTextField", "()Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupInputTextField;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "buttonPanel", "Ljavax/swing/JPanel;", "getButtonPanel", "()Ljavax/swing/JPanel;", "customButtonPanel", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatCustomUiPanel;", "getCustomButtonPanel", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatCustomUiPanel;", "setCustomButtonPanel", "(Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatCustomUiPanel;)V", "setPlaceholderColor", "", "color", "Lcom/intellij/ui/JBColor;", "setupDocument", "setupEditorTextField", "setupCustomKeyboardShortcuts", "setupButtons", "addNotify", "onEnter", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "removeNotify", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "setCustomPanel", "panel", "updateSizeAndRepaint", "intellij.ml.llm.minichat"})
@SourceDebugExtension(value={"SMAP\nMiniAiChatEditorControlBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiniAiChatEditorControlBase.kt\ncom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatEditorControlBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public abstract class MiniAiChatEditorControlBase
extends BorderLayoutPanel
implements UiDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final AICodeGenerationPopupInputTextField editorTextField;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @NotNull
    private final JPanel buttonPanel;
    @Nullable
    private MiniChatCustomUiPanel customButtonPanel;

    public MiniAiChatEditorControlBase(@NotNull Project project, @Nullable String hint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project project2 = this.project = project;
        this.editorTextField = new AICodeGenerationPopupInputTextField(project2){

            protected EditorEx createEditor() {
                EditorEx editorEx;
                EditorEx $this$createEditor_u24lambda_u240 = editorEx = super.createEditor();
                boolean bl = false;
                $this$createEditor_u24lambda_u240.getScrollPane().setBorder(null);
                $this$createEditor_u24lambda_u240.putUserData(MiniChatUtils.INSTANCE.getMINI_CHAT_LOOKUP_EDITOR_KEY(), (Object)true);
                $this$createEditor_u24lambda_u240.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
                $this$createEditor_u24lambda_u240.putUserData(AutoPopupController.NO_ADS, (Object)true);
                ClientProperty.putRecursive((JComponent)$this$createEditor_u24lambda_u240.getScrollPane(), (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
                $this$createEditor_u24lambda_u240.setPlaceholderAttributes(new TextAttributes((Color)MiniChatUtils.INSTANCE.getPlaceholderColor(), null, null, EffectType.BOXED, 0));
                EditorColorsScheme editorColorsScheme = $this$createEditor_u24lambda_u240.getColorsScheme();
                $this$createEditor_u24lambda_u240.setColorsScheme((EditorColorsScheme)new DelegateColorScheme(editorColorsScheme){

                    public Color getDefaultForeground() {
                        return (Color)MiniChatUtils.INSTANCE.getPromptColor();
                    }

                    public TextAttributes getAttributes(TextAttributesKey key) {
                        TextAttributes attributes = super.getAttributes(key);
                        if (attributes != null && key == HighlighterColors.TEXT) {
                            return new TextAttributes((Color)MiniChatUtils.INSTANCE.getPromptColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
                        }
                        return attributes;
                    }
                });
                return editorEx;
            }
        };
        this.buttonPanel = new JPanel();
        this.setupEditorTextField();
        this.setupButtons();
        this.setupCustomKeyboardShortcuts();
        this.setupDocument();
        if (hint != null) {
            this.editorTextField.setPlaceholder((CharSequence)hint);
        }
    }

    public /* synthetic */ MiniAiChatEditorControlBase(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(project, string);
    }

    @NotNull
    public final AICodeGenerationPopupInputTextField getEditorTextField() {
        return this.editorTextField;
    }

    @NotNull
    public final JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    @Nullable
    public final MiniChatCustomUiPanel getCustomButtonPanel() {
        return this.customButtonPanel;
    }

    public final void setCustomButtonPanel(@Nullable MiniChatCustomUiPanel miniChatCustomUiPanel) {
        this.customButtonPanel = miniChatCustomUiPanel;
    }

    public final void setPlaceholderColor(@NotNull JBColor color) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            EditorEx editorEx = this.editorTextField.getEditor(false);
            if (editorEx == null) break block0;
            editorEx.setPlaceholderAttributes(new TextAttributes((Color)color, null, null, EffectType.BOXED, 0));
        }
    }

    private final void setupDocument() {
        boolean chatInputLanguageEnabled = Registry.Companion.is("llm.chat.input.language.in.inlay");
        String fileExtension = chatInputLanguageEnabled ? "chatInput" : "txt";
        String fileName = "AIAssistantInput-" + UUID.randomUUID() + "." + fileExtension;
        String languageName = chatInputLanguageEnabled ? "ChatInput" : "TEXT";
        Language language = AIAssistantChatUtil.INSTANCE.findLanguage(languageName);
        ActionsKt.runReadAction(() -> MiniAiChatEditorControlBase.setupDocument$lambda$1(this, fileName, language));
    }

    private final void setupEditorTextField() {
        this.editorTextField.setBorder(BorderFactory.createEmptyBorder(4, 0, 3, 0));
        this.addToCenter((Component)this.editorTextField);
    }

    protected void setupCustomKeyboardShortcuts() {
        Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null)};
        DumbAwareAction.create(arg_0 -> MiniAiChatEditorControlBase.setupCustomKeyboardShortcuts$lambda$6(arg_0 -> MiniAiChatEditorControlBase.setupCustomKeyboardShortcuts$lambda$5(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)this.editorTextField);
    }

    private final void setupButtons() {
        JPanel jPanel;
        JPanel $this$setupButtons_u24lambda_u247 = jPanel = this.buttonPanel;
        boolean bl = false;
        $this$setupButtons_u24lambda_u247.setLayout(new BoxLayout($this$setupButtons_u24lambda_u247, 1));
        $this$setupButtons_u24lambda_u247.setOpaque(false);
        this.addToRight(this.buttonPanel);
    }

    public void addNotify() {
        block0: {
            super.addNotify();
            this.messageBusConnection = this.project.getMessageBus().connect();
            AnActionListener enterToSubmitActionListener2 = new AnActionListener(this){
                final /* synthetic */ MiniAiChatEditorControlBase this$0;
                {
                    this.this$0 = $receiver;
                }

                public void afterActionPerformed(AnAction action, AnActionEvent event, AnActionResult result2) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    if (event.getDataContext().getData(CommonDataKeys.EDITOR) != this.this$0.getEditorTextField().getEditor()) {
                        return;
                    }
                    if (!(action instanceof EnterAction)) {
                        return;
                    }
                    this.this$0.onEnter(event);
                }
            };
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection == null) break block0;
            Topic topic = AnActionListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)enterToSubmitActionListener2);
        }
    }

    protected abstract void onEnter(@NotNull AnActionEvent var1);

    public void removeNotify() {
        super.removeNotify();
        MessageBusConnection messageBusConnection = this.messageBusConnection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.messageBusConnection = null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.set(dataKey, (Object)this.editorTextField.getEditor());
    }

    public final void setCustomPanel(@Nullable MiniChatCustomUiPanel panel2) {
        block1: {
            MiniChatCustomUiPanel miniChatCustomUiPanel = this.customButtonPanel;
            if (miniChatCustomUiPanel != null) {
                MiniChatCustomUiPanel it = miniChatCustomUiPanel;
                boolean bl = false;
                this.buttonPanel.remove(it.getComponent());
            }
            this.customButtonPanel = panel2;
            MiniChatCustomUiPanel miniChatCustomUiPanel2 = panel2;
            if (miniChatCustomUiPanel2 == null) break block1;
            MiniChatCustomUiPanel it = miniChatCustomUiPanel2;
            boolean bl = false;
            this.buttonPanel.add(it.getComponent());
        }
    }

    public final void updateSizeAndRepaint() {
        Object object;
        Object object2;
        MiniChatCustomUiPanel miniChatCustomUiPanel = this.customButtonPanel;
        if (miniChatCustomUiPanel != null) {
            miniChatCustomUiPanel.updateSizeAndRepaint();
        }
        if ((object2 = this.customButtonPanel) != null && (object2 = object2.getComponent()) != null) {
            ((Component)object2).revalidate();
        }
        if ((object = this.customButtonPanel) != null && (object = object.getComponent()) != null) {
            ((Component)object).repaint();
        }
        this.buttonPanel.revalidate();
        this.buttonPanel.repaint();
        this.editorTextField.revalidate();
        this.editorTextField.repaint();
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit setupDocument$lambda$1(MiniAiChatEditorControlBase this$0, String $fileName, Language $language) {
        void $this$setupDocument_u24lambda_u241_u24lambda_u240;
        LightVirtualFile lightVirtualFile;
        LightVirtualFile lightVirtualFile2 = lightVirtualFile = new LightVirtualFile($fileName, $language, (CharSequence)"");
        AICodeGenerationPopupInputTextField aICodeGenerationPopupInputTextField = this$0.editorTextField;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)$this$setupDocument_u24lambda_u241_u24lambda_u240.getFileType(), (Object)UnknownFileType.INSTANCE)) {
            $this$setupDocument_u24lambda_u241_u24lambda_u240.setFileType((FileType)PlainTextFileType.INSTANCE);
        }
        Document document = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)lightVirtualFile));
        if (document == null) {
            throw new IllegalStateException("Can't create inmemory document".toString());
        }
        aICodeGenerationPopupInputTextField.setDocument(document);
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$5$lambda$4$lambda$3$lambda$2(Editor $it, MiniAiChatEditorControlBase this$0) {
        String eol = "\n";
        int caretOffset = $it.getCaretModel().getOffset();
        this$0.editorTextField.getDocument().insertString(caretOffset, (CharSequence)eol);
        $it.getCaretModel().moveToOffset(caretOffset + eol.length());
        EditorModificationUtil.scrollToCaret((Editor)$it);
    }

    private static final void setupCustomKeyboardShortcuts$lambda$5$lambda$4$lambda$3(Editor $it, MiniAiChatEditorControlBase this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> MiniAiChatEditorControlBase.setupCustomKeyboardShortcuts$lambda$5$lambda$4$lambda$3$lambda$2($it, this$0));
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$5(MiniAiChatEditorControlBase this$0, AnActionEvent it) {
        block0: {
            Editor editor = this$0.editorTextField.getEditor();
            if (editor == null) break block0;
            Editor it2 = editor;
            boolean bl = false;
            CommandProcessor.getInstance().executeCommand(this$0.project, () -> MiniAiChatEditorControlBase.setupCustomKeyboardShortcuts$lambda$5$lambda$4$lambda$3(it2, this$0), null, null);
        }
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

