/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer;

import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingKey;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingsRemoveScheduler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B+\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0012\u001a\u00020\f2\b\u0010\r\u001a\u0004\b\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0016\u001a\u00020\fH\u0016J7\u0010\u0017\u001a\u00020\b\"\f\b\u0002\u0010\u0018*\u00060\u0019j\u0002`\u001a2\u0006\u0010\r\u001a\u00028\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00180\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\bH\u0016J*\u0010#\u001a\u00020\b2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexStorage;", "K", "V", "Lcom/intellij/util/indexing/VfsAwareIndexStorage;", "delegate", "indexId", "Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexId;", "dependsOnFileContent", "", "<init>", "(Lcom/intellij/util/indexing/VfsAwareIndexStorage;Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexId;Z)V", "addValue", "", "key", "inputId", "", "value", "(Ljava/lang/Object;ILjava/lang/Object;)V", "removeAllValues", "(Ljava/lang/Object;I)V", "updateValue", "newValue", "clear", "read", "E", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processor", "Lcom/intellij/util/indexing/impl/ValueContainerProcessor;", "(Ljava/lang/Object;Lcom/intellij/util/indexing/impl/ValueContainerProcessor;)Z", "clearCaches", "flush", "isDirty", "close", "isClosed", "processKeys", "Lcom/intellij/util/Processor;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "idFilter", "Lcom/intellij/util/indexing/IdFilter;", "keysCountApproximately", "intellij.ml.llm.embeddings"})
public final class EmbeddingIndexStorage<K, V>
implements VfsAwareIndexStorage<K, V> {
    @NotNull
    private final VfsAwareIndexStorage<K, V> delegate;
    @NotNull
    private final EmbeddingIndexId indexId;
    private final boolean dependsOnFileContent;

    public EmbeddingIndexStorage(@NotNull VfsAwareIndexStorage<K, V> delegate, @NotNull EmbeddingIndexId indexId, boolean dependsOnFileContent) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        this.delegate = delegate;
        this.indexId = indexId;
        this.dependsOnFileContent = dependsOnFileContent;
    }

    public void addValue(@Nullable K key, int inputId, @Nullable V value) {
        this.delegate.addValue(key, inputId, value);
    }

    public void removeAllValues(@NotNull K key, int inputId) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.delegate.removeAllValues(key, inputId);
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        List projects = this.dependsOnFileContent ? fileBasedIndex2.getFilesToUpdateCollector().getDirtyFiles().getProjects(inputId) : fileBasedIndex2.getChangedFilesCollector().getDirtyFiles().getProjects(inputId);
        long externalKey = EmbeddingKey.toLong-impl(((EmbeddingKey)key).unbox-impl(), inputId);
        for (Project project : projects) {
            EmbeddingsRemoveScheduler.Companion.getInstance(project).scheduleRemove(this.indexId, externalKey);
        }
    }

    public void updateValue(K key, int inputId, V newValue) {
        this.delegate.updateValue(key, inputId, newValue);
    }

    public void clear() {
        this.delegate.clear();
    }

    public <E extends Exception> boolean read(K key, @NotNull ValueContainerProcessor<V, E> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return this.delegate.read(key, processor);
    }

    public void clearCaches() {
        this.delegate.clearCaches();
    }

    public void flush() {
        this.delegate.flush();
    }

    public boolean isDirty() {
        return this.delegate.isDirty();
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public boolean processKeys(@NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.delegate.processKeys(processor, scope, idFilter);
    }

    public int keysCountApproximately() {
        return this.delegate.keysCountApproximately();
    }
}

